/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.tests.viewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.dtd.ui.tests.ProjectUtil;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.reconcile.ISourceReconcilingListener;

public class DTDCodeFoldingTest
extends TestCase
implements ISourceReconcilingListener {
    private static final int MAX_WAIT_TIME = 4000;
    private static final int WAIT_TIME = 200;
    private static final String PROJECT_NAME = "DTDCodeFoldingTest";
    private static final String PROJECT_FILES = "/testresources/folding";
    private static IProject fProject;
    private static Map fFileToEditorMap;
    private static IDocument fReconciledDoc;

    static {
        fFileToEditorMap = new HashMap();
        fReconciledDoc = null;
    }

    public DTDCodeFoldingTest() {
        super("DTD Code Folding Test");
    }

    public DTDCodeFoldingTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(DTDCodeFoldingTest.class, "DTD Code Folding Test");
        return new DTDCodeFoldingTestSetup((Test)ts);
    }

    protected void setUp() throws Exception {
        super.setUp();
        fReconciledDoc = null;
    }

    public void testInitFolding() throws Exception {
        IFile file = DTDCodeFoldingTest.getFile("DTDFoldingTest1.dtd");
        StructuredTextEditor editor = this.getEditor(file);
        ArrayList<Position> expectedPositions = new ArrayList<Position>();
        expectedPositions.add(new Position(1299, 234));
        expectedPositions.add(new Position(39, 296));
        expectedPositions.add(new Position(498, 751));
        expectedPositions.add(new Position(1251, 17));
        expectedPositions.add(new Position(1269, 28));
        expectedPositions.add(new Position(337, 159));
        this.waitForReconcileThenVerify(editor.getTextViewer(), expectedPositions);
    }

    public void testAddNode() throws Exception {
        IFile file = DTDCodeFoldingTest.getFile("DTDFoldingTest2.dtd");
        StructuredTextEditor editor = this.getEditor(file);
        try {
            StructuredTextViewer viewer = editor.getTextViewer();
            IDocument doc = viewer.getDocument();
            String newNodeText = "<!ATTLIST BDO\n%coreattrs;\t\t\t\t-- id, class, style, title --\nlang\t%LanguageCode;\t#IMPLIED\t-- language code --\ndir\t(ltr|rtl)\t#REQUIRED\t-- directionality --\n>\n";
            doc.replace(597, 0, newNodeText);
            editor.doSave(null);
            ArrayList<Position> expectedPositions = new ArrayList<Position>();
            expectedPositions.add(new Position(1454, 234));
            expectedPositions.add(new Position(498, 906));
            expectedPositions.add(new Position(39, 296));
            expectedPositions.add(new Position(1406, 17));
            expectedPositions.add(new Position(337, 159));
            expectedPositions.add(new Position(1424, 28));
            this.waitForReconcileThenVerify(viewer, expectedPositions);
        }
        catch (BadLocationException e) {
            DTDCodeFoldingTest.fail((String)("Test is broken, add location has become invalid.\n" + e.getMessage()));
        }
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        DTDCodeFoldingTest.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private StructuredTextEditor getEditor(IFile file) {
        StructuredTextEditor editor = (StructuredTextEditor)fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true, (boolean)true);
                if (editorPart instanceof StructuredTextEditor) {
                    editor = (StructuredTextEditor)editorPart;
                    this.standardizeLineEndings(editor);
                } else {
                    DTDCodeFoldingTest.fail((String)"Unable to open structured text editor");
                }
                if (editor != null) {
                    fFileToEditorMap.put(file, editor);
                } else {
                    DTDCodeFoldingTest.fail((String)("Could not open viewer for " + file));
                }
            }
            catch (Exception e) {
                DTDCodeFoldingTest.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    private void waitForReconcileThenVerify(StructuredTextViewer viewer, List expectedPositions) throws Exception {
        IDocument doc = viewer.getDocument();
        int time = 0;
        while (doc != fReconciledDoc && time <= 4000) {
            Thread.sleep(200L);
            time += 200;
        }
        if (doc == fReconciledDoc) {
            this.verifyAnnotationPositions(viewer, expectedPositions);
        } else {
            Assert.fail((String)("Document " + viewer.getDocument() + " was not reconciled with in " + 4000 + " so gave up waiting and in turn could not validate folding anotations"));
        }
    }

    private void verifyAnnotationPositions(StructuredTextViewer viewer, List expectedPositions) throws Exception {
        Position pos;
        ProjectionAnnotationModel projectionModel = viewer.getProjectionAnnotationModel();
        Iterator annotationIter = projectionModel.getAnnotationIterator();
        ArrayList<Position> unexpectedPositions = new ArrayList<Position>();
        while (annotationIter.hasNext()) {
            ProjectionAnnotation annotation;
            boolean found;
            Object obj = annotationIter.next();
            if (!(obj instanceof ProjectionAnnotation) || (found = expectedPositions.remove(pos = projectionModel.getPosition((Annotation)(annotation = (ProjectionAnnotation)obj))))) continue;
            unexpectedPositions.add(pos);
        }
        String error = "";
        if (unexpectedPositions.size() != 0) {
            error = String.valueOf(error) + "There were " + unexpectedPositions.size() + " unexpected positions that were found";
            int i = 0;
            while (i < unexpectedPositions.size()) {
                pos = (Position)unexpectedPositions.get(i);
                error = String.valueOf(error) + "\n\t" + pos;
                error = String.valueOf(error) + "\n(" + fReconciledDoc.get(pos.offset, pos.length) + ")";
                ++i;
            }
        }
        if (expectedPositions.size() != 0) {
            error = String.valueOf(error) + "\nThere were " + expectedPositions.size() + " expected positions that were not found";
            int i = 0;
            while (i < expectedPositions.size()) {
                error = String.valueOf(error) + "\n\t" + expectedPositions.get(i);
                ++i;
            }
        }
        if (expectedPositions.size() != 0 || unexpectedPositions.size() != 0) {
            error = String.valueOf(error) + "\nFull Document:\n(" + fReconciledDoc.get() + ")";
        }
        if (error.length() != 0) {
            DTDCodeFoldingTest.fail((String)error);
        }
    }

    private void standardizeLineEndings(StructuredTextEditor editor) {
        IDocument doc = editor.getTextViewer().getDocument();
        String contents = doc.get();
        contents = StringUtils.replace((String)contents, (String)"\r\n", (String)"\n");
        contents = StringUtils.replace((String)contents, (String)"\r", (String)"\n");
        doc.set(contents);
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(IDocument document, IAnnotationModel model, boolean forced, IProgressMonitor progressMonitor) {
        fReconciledDoc = document;
    }

    private static class DTDCodeFoldingTestSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public DTDCodeFoldingTestSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            DTDCodeFoldingTestSetup.initializeResources();
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            for (StructuredTextEditor editor : fFileToEditorMap.values()) {
                editor.doSave(null);
                editor.close(false);
            }
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }

        private static void initializeResources() {
            fProject = ProjectUtil.createProject(DTDCodeFoldingTest.PROJECT_NAME, null, null);
            ProjectUtil.copyBundleEntriesIntoWorkspace(DTDCodeFoldingTest.PROJECT_FILES, DTDCodeFoldingTest.PROJECT_NAME);
        }
    }
}

