/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.tests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IBoundedListTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.tests.ContextSymbolTestPlugin;
import org.eclipse.jst.jsf.context.symbol.tests.ModelBaseTestCase;

public class TestTypeCoercion
extends ModelBaseTestCase {
    private static final String packageName = "com.test";
    private IBeanInstanceSymbol _testMapBeanSymbol;
    private IBeanInstanceSymbol _testListBeanSymbol;
    private IBeanInstanceSymbol _testBeanWithGenericProperties;
    private Map<String, IPropertySymbol> _genericProperties;
    private static final ValueType LIST_GETTER_ARG = new ValueType("I", 2);
    private static final ValueType MAP_GETTER_ARG_STRING = new ValueType("Ljava.lang.String;", 2);

    protected void setUp() throws Exception {
        super.setUp();
        this._testMapBeanSymbol = this.setupBeanProperty(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/TestBeanMap.java.data", packageName, "TestBeanMap", new HashMap<String, IPropertySymbol>());
        this._testListBeanSymbol = this.setupBeanProperty(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/MyListBean.java.data", packageName, "MyListBean", new HashMap<String, IPropertySymbol>());
        this._genericProperties = new HashMap<String, IPropertySymbol>();
        this._testBeanWithGenericProperties = this.setupBeanProperty(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/TestBeanWithGenericProperties.java.data", packageName, "TestBeanWithGenericProperties", this._genericProperties);
    }

    public void testSanity() {
        TestTypeCoercion.assertNotNull((Object)this._testMapBeanSymbol);
        TestTypeCoercion.assertNotNull((Object)this._testListBeanSymbol);
        TestTypeCoercion.assertNotNull((Object)this._testBeanWithGenericProperties);
    }

    public void testBasicMapBean() {
        TestTypeCoercion.assertTrue((boolean)this._testMapBeanSymbol.getTypeDescriptor().instanceOf("Ljava.util.Map;"));
        TestTypeCoercion.assertTrue((boolean)this._testMapBeanSymbol.supportsCoercion("Ljava.util.Map;"));
        ITypeDescriptor typeDesc = this._testMapBeanSymbol.coerce("Ljava.util.Map;");
        TestTypeCoercion.assertNotNull((Object)typeDesc);
        TestTypeCoercion.assertTrue((boolean)typeDesc.instanceOf("Ljava.util.Map;"));
        TestTypeCoercion.assertTrue((boolean)(typeDesc instanceof IBoundedMapTypeDescriptor));
        TestTypeCoercion.assertTrue((boolean)((IBoundedMapTypeDescriptor)typeDesc).isUnboundedForType("Ljava.util.Map;"));
        ISymbol symbol = ((IBoundedMapTypeDescriptor)typeDesc).getUnboundedProperty((Object)"chelsea", "Ljava.util.Map;");
        TestTypeCoercion.assertEquals((String)"chelsea", (String)symbol.getName());
    }

    public void testBasicListBean() {
        TestTypeCoercion.assertTrue((boolean)this._testListBeanSymbol.getTypeDescriptor().instanceOf("Ljava.util.List;"));
        TestTypeCoercion.assertTrue((boolean)this._testListBeanSymbol.supportsCoercion("Ljava.util.List;"));
        ITypeDescriptor typeDesc = this._testListBeanSymbol.coerce("Ljava.util.List;");
        TestTypeCoercion.assertNotNull((Object)typeDesc);
        TestTypeCoercion.assertTrue((boolean)typeDesc.instanceOf("Ljava.util.List;"));
        TestTypeCoercion.assertTrue((boolean)(typeDesc instanceof IBoundedListTypeDescriptor));
        TestTypeCoercion.assertTrue((boolean)((IBoundedListTypeDescriptor)typeDesc).isUnboundedForType("Ljava.lang.Integer;"));
        Integer symbolKey = 0;
        ISymbol symbol = ((IBoundedListTypeDescriptor)typeDesc).getUnboundedProperty((Object)symbolKey, "Ljava.lang.Integer;");
        TestTypeCoercion.assertEquals((String)symbolKey.toString(), (String)symbol.getName());
    }

    public void testListGetCall() {
        TestTypeCoercion.assertTrue((boolean)this._testListBeanSymbol.getTypeDescriptor().instanceOf("Ljava.util.List;"));
        TestTypeCoercion.assertTrue((boolean)this._testListBeanSymbol.supportsCoercion("Ljava.util.List;"));
        BasicEList valueTypes = new BasicEList();
        valueTypes.add((Object)LIST_GETTER_ARG);
        ISymbol symbol = this._testListBeanSymbol.call("get", (EList)valueTypes, "listBean[0]");
        TestTypeCoercion.assertNotNull((Object)symbol);
        TestTypeCoercion.assertTrue((boolean)(symbol instanceof IPropertySymbol));
        TestTypeCoercion.assertEquals((String)"Ljava.lang.Object;", (String)((IPropertySymbol)symbol).getTypeDescriptor().getTypeSignature());
    }

    public void testMapGetCall() {
        TestTypeCoercion.assertTrue((boolean)this._testMapBeanSymbol.getTypeDescriptor().instanceOf("Ljava.util.Map;"));
        TestTypeCoercion.assertTrue((boolean)this._testMapBeanSymbol.supportsCoercion("Ljava.util.Map;"));
        BasicEList valueTypes = new BasicEList();
        valueTypes.add((Object)MAP_GETTER_ARG_STRING);
        ISymbol symbol = this._testMapBeanSymbol.call("get", (EList)valueTypes, "foo");
        TestTypeCoercion.assertNotNull((Object)symbol);
        TestTypeCoercion.assertTrue((boolean)(symbol instanceof IPropertySymbol));
        TestTypeCoercion.assertEquals((String)"Ljava.lang.Object;", (String)((IPropertySymbol)symbol).getTypeDescriptor().getTypeSignature());
    }

    public void testListGetCallWithSimpleTypeArguments() {
        BasicEList valueTypes = new BasicEList();
        valueTypes.add((Object)LIST_GETTER_ARG);
        IPropertySymbol propSymbol = this._genericProperties.get("listOfStrings");
        TestTypeCoercion.assertNotNull((Object)propSymbol);
        TestTypeCoercion.assertTrue((boolean)propSymbol.supportsCoercion("Ljava.util.List;"));
        TestTypeCoercion.assertFalse((boolean)propSymbol.supportsCoercion("Ljava.util.Map;"));
        TestTypeCoercion.assertEquals((String)"Ljava.util.List;", (String)propSymbol.getTypeDescriptor().getTypeSignature());
        TestTypeCoercion.assertEquals((int)1, (int)propSymbol.getTypeDescriptor().getTypeParameterSignatures().size());
        TestTypeCoercion.assertEquals((Object)"Ljava.lang.String;", (Object)propSymbol.getTypeDescriptor().getTypeParameterSignatures().get(0));
        ISymbol symbol = propSymbol.call("get", (EList)valueTypes, "listBean[0]");
        TestTypeCoercion.assertNotNull((Object)symbol);
        TestTypeCoercion.assertTrue((boolean)(symbol instanceof IPropertySymbol));
        TestTypeCoercion.assertEquals((String)"Ljava.lang.String;", (String)((IPropertySymbol)symbol).getTypeDescriptor().getTypeSignature());
    }

    public void testMapGetCallWithSimpleTypeArguments() {
        BasicEList valueTypes = new BasicEList();
        valueTypes.add((Object)MAP_GETTER_ARG_STRING);
        IPropertySymbol propSymbol = this._genericProperties.get("mapOfStringsKeyedByString");
        TestTypeCoercion.assertNotNull((Object)propSymbol);
        TestTypeCoercion.assertTrue((boolean)propSymbol.supportsCoercion("Ljava.util.Map;"));
        TestTypeCoercion.assertFalse((boolean)propSymbol.supportsCoercion("Ljava.util.List;"));
        TestTypeCoercion.assertEquals((String)"Ljava.util.Map;", (String)propSymbol.getTypeDescriptor().getTypeSignature());
        TestTypeCoercion.assertEquals((int)2, (int)propSymbol.getTypeDescriptor().getTypeParameterSignatures().size());
        TestTypeCoercion.assertEquals((Object)"Ljava.lang.String;", (Object)propSymbol.getTypeDescriptor().getTypeParameterSignatures().get(0));
        TestTypeCoercion.assertEquals((Object)"Ljava.lang.String;", (Object)propSymbol.getTypeDescriptor().getTypeParameterSignatures().get(1));
        ISymbol symbol = propSymbol.call("get", (EList)valueTypes, "mapBean['someKey']");
        TestTypeCoercion.assertNotNull((Object)symbol);
        TestTypeCoercion.assertTrue((boolean)(symbol instanceof IPropertySymbol));
        TestTypeCoercion.assertEquals((String)"Ljava.lang.String;", (String)((IPropertySymbol)symbol).getTypeDescriptor().getTypeSignature());
    }
}

