/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.stack;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.queue.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.FixedCapacityArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.LinkedStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.internal.stack.SynchronizedStack;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class StackToolsTests
extends TestCase {
    public static final Transformer<String, String> FIRST_LETTER_TRANSFORMER = new FirstLetterTransformer();
    public static final Transformer<String, String> EMPHASIZER = new StringTools.CharDelimiter('*');

    public StackToolsTests(String name) {
        super(name);
    }

    public void testPushAllIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayStack stack = StackTools.arrayStack();
        StackToolsTests.assertTrue((boolean)StackTools.pushAll((Stack)stack, iterable));
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testPushAllIterable_empty() {
        ArrayList iterable = new ArrayList();
        ArrayStack stack = StackTools.arrayStack();
        StackToolsTests.assertFalse((boolean)StackTools.pushAll((Stack)stack, iterable));
        StackToolsTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testPushAllIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayStack stack = StackTools.arrayStack();
        StackToolsTests.assertTrue((boolean)StackTools.pushAll((Stack)stack, iterable.iterator()));
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testPushAllArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayStack stack = StackTools.arrayStack();
        StackToolsTests.assertTrue((boolean)StackTools.pushAll((Stack)stack, (Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY)));
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testPushAllArray_empty() {
        ArrayList iterable = new ArrayList();
        ArrayStack stack = StackTools.arrayStack();
        StackToolsTests.assertFalse((boolean)StackTools.pushAll((Stack)stack, (Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY)));
        StackToolsTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testPopAll() {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"one");
        stack.push((Object)"two");
        stack.push((Object)"three");
        ArrayList list = StackTools.popAll((Stack)stack);
        StackToolsTests.assertEquals((String)"three", (String)((String)list.get(0)));
        StackToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        StackToolsTests.assertEquals((String)"one", (String)((String)list.get(2)));
    }

    public void testPopAllToCollection() {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"one");
        stack.push((Object)"two");
        stack.push((Object)"three");
        ArrayList list = new ArrayList();
        StackToolsTests.assertTrue((boolean)StackTools.popAllTo((Stack)stack, list));
        StackToolsTests.assertEquals((String)"three", (String)((String)list.get(0)));
        StackToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        StackToolsTests.assertEquals((String)"one", (String)((String)list.get(2)));
    }

    public void testPopAllToCollection_empty() {
        ArrayStack stack = StackTools.arrayStack();
        ArrayList list = new ArrayList();
        StackToolsTests.assertFalse((boolean)StackTools.popAllTo((Stack)stack, list));
        StackToolsTests.assertTrue((boolean)list.isEmpty());
    }

    public void testPopAllToListIndex() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"aaa");
        stack.push((Object)"bbb");
        stack.push((Object)"ccc");
        StackToolsTests.assertTrue((boolean)StackTools.popAllTo((Stack)stack, list, (int)2));
        StackToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        StackToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        StackToolsTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
        StackToolsTests.assertEquals((String)"bbb", (String)((String)list.get(3)));
        StackToolsTests.assertEquals((String)"aaa", (String)((String)list.get(4)));
        StackToolsTests.assertEquals((String)"three", (String)((String)list.get(5)));
    }

    public void testPopAllToListIndex_end() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"aaa");
        stack.push((Object)"bbb");
        stack.push((Object)"ccc");
        StackToolsTests.assertTrue((boolean)StackTools.popAllTo((Stack)stack, list, (int)3));
        StackToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        StackToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        StackToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
        StackToolsTests.assertEquals((String)"ccc", (String)((String)list.get(3)));
        StackToolsTests.assertEquals((String)"bbb", (String)((String)list.get(4)));
        StackToolsTests.assertEquals((String)"aaa", (String)((String)list.get(5)));
    }

    public void testPopAllToListIndex_empty() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayStack stack = StackTools.arrayStack();
        StackToolsTests.assertFalse((boolean)StackTools.popAllTo((Stack)stack, list, (int)3));
        StackToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        StackToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        StackToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testPopAllToStack() {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"one");
        stack.push((Object)"two");
        stack.push((Object)"three");
        ArrayStack stack2 = StackTools.arrayStack();
        StackToolsTests.assertTrue((boolean)StackTools.popAllTo((Stack)stack, (Stack)stack2));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack2.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack2.pop()));
        StackToolsTests.assertEquals((String)"three", (String)((String)stack2.pop()));
    }

    public void testPopAllToStack_empty() {
        ArrayStack stack = StackTools.arrayStack();
        ArrayStack stack2 = StackTools.arrayStack();
        StackToolsTests.assertFalse((boolean)StackTools.popAllTo((Stack)stack, (Stack)stack2));
        StackToolsTests.assertTrue((boolean)stack2.isEmpty());
    }

    public void testPopAllToQueue() {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"one");
        stack.push((Object)"two");
        stack.push((Object)"three");
        ArrayQueue queue = QueueTools.arrayQueue();
        StackToolsTests.assertTrue((boolean)StackTools.popAllTo((Stack)stack, (Queue)queue));
        StackToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
        StackToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        StackToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
    }

    public void testPopAllToQueue_empty() {
        ArrayStack stack = StackTools.arrayStack();
        ArrayQueue queue = QueueTools.arrayQueue();
        StackToolsTests.assertFalse((boolean)StackTools.popAllTo((Stack)stack, (Queue)queue));
        StackToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testPopAllToMapTransformer() {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"zero");
        stack.push((Object)"one");
        stack.push((Object)"two");
        HashMap map = new HashMap();
        StackToolsTests.assertTrue((boolean)StackTools.popAllTo((Stack)stack, map, FIRST_LETTER_TRANSFORMER));
        StackToolsTests.assertEquals((String)"one", (String)((String)map.get("o")));
        StackToolsTests.assertEquals((String)"two", (String)((String)map.get("t")));
        StackToolsTests.assertEquals((String)"zero", (String)((String)map.get("z")));
    }

    public void testPopAllToMapTransformer_empty() {
        ArrayStack stack = StackTools.arrayStack();
        HashMap map = new HashMap();
        StackToolsTests.assertFalse((boolean)StackTools.popAllTo((Stack)stack, map, FIRST_LETTER_TRANSFORMER));
        StackToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testPopAllToMapTransformerTransformer() {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"zero");
        stack.push((Object)"one");
        stack.push((Object)"two");
        HashMap map = new HashMap();
        StackToolsTests.assertTrue((boolean)StackTools.popAllTo((Stack)stack, map, FIRST_LETTER_TRANSFORMER, EMPHASIZER));
        StackToolsTests.assertEquals((String)"*one*", (String)((String)map.get("o")));
        StackToolsTests.assertEquals((String)"*two*", (String)((String)map.get("t")));
        StackToolsTests.assertEquals((String)"*zero*", (String)((String)map.get("z")));
    }

    public void testPopAllToMapTransformerTransformer_empty() {
        ArrayStack stack = StackTools.arrayStack();
        HashMap map = new HashMap();
        StackToolsTests.assertFalse((boolean)StackTools.popAllTo((Stack)stack, map, FIRST_LETTER_TRANSFORMER, EMPHASIZER));
        StackToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testArrayStack() {
        ArrayStack d = StackTools.arrayStack();
        StackToolsTests.assertTrue((boolean)d.isEmpty());
    }

    public void testArrayStackInt() {
        ArrayStack d = StackTools.arrayStack((int)20);
        StackToolsTests.assertTrue((boolean)d.isEmpty());
        StackToolsTests.assertEquals((int)20, (int)((Object[])ObjectTools.get((Object)d, (String)"elements")).length);
    }

    public void testArrayStackIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayStack stack = StackTools.arrayStack(iterable);
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testArrayStackIterableInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayStack stack = StackTools.arrayStack(iterable, (int)5);
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testArrayStackIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayStack stack = StackTools.arrayStack(iterable.iterator());
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testArrayStackIteratorInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayStack stack = StackTools.arrayStack(iterable.iterator(), (int)5);
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testArrayStackArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayStack stack = StackTools.arrayStack((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY));
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testLinkedStack() {
        LinkedStack d = StackTools.linkedStack();
        StackToolsTests.assertTrue((boolean)d.isEmpty());
    }

    public void testLinkedStackInt() {
        LinkedStack d = StackTools.linkedStack((int)20);
        StackToolsTests.assertTrue((boolean)d.isEmpty());
    }

    public void testLinkedStackIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedStack stack = StackTools.linkedStack(iterable);
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testLinkedStackIterableInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedStack stack = StackTools.linkedStack(iterable, (int)5);
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testLinkedStackIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedStack stack = StackTools.linkedStack(iterable.iterator());
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testLinkedStackIteratorInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedStack stack = StackTools.linkedStack(iterable.iterator(), (int)5);
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testLinkedStackArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedStack stack = StackTools.linkedStack((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY));
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testLinkedStackArrayInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedStack stack = StackTools.linkedStack((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY), (int)2);
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testFixedCapacityArrayStackCollection() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        FixedCapacityArrayStack stack = StackTools.fixedCapacityArrayStack(iterable);
        StackToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testSynchronizedStackObject() {
        Object lock = new Object();
        SynchronizedStack stack = StackTools.synchronizedStack((Object)lock);
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        StackToolsTests.assertEquals((String)second, (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)first, (String)((String)stack.pop()));
        StackToolsTests.assertEquals((Object)lock, (Object)stack.getMutex());
    }

    public void testSynchronizedStackStackObject() {
        Object lock = new Object();
        ArrayStack innerStack = StackTools.arrayStack();
        String first = "first";
        String second = "second";
        innerStack.push((Object)first);
        innerStack.push((Object)second);
        SynchronizedStack stack = StackTools.synchronizedStack((Stack)innerStack, (Object)lock);
        StackToolsTests.assertEquals((String)second, (String)((String)stack.pop()));
        StackToolsTests.assertEquals((String)first, (String)((String)stack.pop()));
        StackToolsTests.assertEquals((Object)lock, (Object)stack.getMutex());
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(StackTools.class);
                StackToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        StackToolsTests.assertTrue((boolean)exCaught);
    }

    static class FirstLetterTransformer
    implements Transformer<String, String> {
        FirstLetterTransformer() {
        }

        public String transform(String string) {
            return string.substring(0, 1);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

