/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.exception.CompositeException;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public abstract class MultiThreadedTestCase
extends TestCase {
    private final ArrayList<Thread> threads = new ArrayList();
    final Vector<Throwable> exceptions = new Vector();
    public static final String TICK_SYSTEM_PROPERTY_NAME = "org.eclipse.jpt.common.utility.tests.tick";
    public static final long TICK = Long.getLong("org.eclipse.jpt.common.utility.tests.tick", 1000L);
    public static final long TWO_TICKS = 2L * TICK;
    public static final long THREE_TICKS = 3L * TICK;

    public MultiThreadedTestCase() {
    }

    public MultiThreadedTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        for (Thread thread : this.threads) {
            if (!thread.isAlive()) continue;
            throw new IllegalStateException("thread is still alive: " + thread);
        }
        if (!this.exceptions.isEmpty()) {
            throw new CompositeException(this.exceptions);
        }
        TestTools.clear(this);
        super.tearDown();
    }

    protected Thread buildThread(Runnable runnable) {
        return this.buildThread(runnable, null);
    }

    protected Thread buildThread(Runnable runnable, String name) {
        Thread thread = new Thread(new RunnableWrapper(runnable));
        if (name != null) {
            thread.setName(name);
        }
        this.threads.add(thread);
        return thread;
    }

    protected ThreadFactory buildThreadFactory() {
        return new TestThreadFactory();
    }

    public void sleep(long millis) {
        TestTools.sleep(millis);
    }

    private class RunnableWrapper
    implements Runnable {
        private final Runnable runnable;

        RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (RuntimeException ex) {
                MultiThreadedTestCase.this.exceptions.add(ex);
            }
        }
    }

    public abstract class TestRunnable
    implements Runnable {
        @Override
        public final void run() {
            try {
                this.run_();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }

        protected abstract void run_() throws Throwable;
    }

    public class TestThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            return MultiThreadedTestCase.this.buildThread(r);
        }
    }
}

