/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlListAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlListAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlListAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlList() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlList"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlList");
            }
        });
    }

    public void testGetXmlList() throws Exception {
        ICompilationUnit cu = this.createTestXmlList();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlListAnnotation xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        XmlListAnnotationTests.assertTrue((xmlListAnnotation != null ? 1 : 0) != 0);
        resourceAttribute.removeAnnotation("javax.xml.bind.annotation.XmlList");
        this.assertSourceDoesNotContain("@XmlList", cu);
    }
}

