/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlElementRefAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ELEMENT_REF_NAME = "elementName";
    private static final String XML_ELEMENT_REF_NAMESPACE = "XmlElementRefNamespace";
    private static final String XML_ELEMENT_REF_TYPE = "String";

    public XmlElementRefAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlElementRef() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementRef"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRef");
            }
        });
    }

    private ICompilationUnit createTestXmlElementRefWithName() throws Exception {
        return this.createTestXmlElementRefWithStringElement("name", XML_ELEMENT_REF_NAME);
    }

    private ICompilationUnit createTestXmlElementRefWithNamespace() throws Exception {
        return this.createTestXmlElementRefWithStringElement("namespace", XML_ELEMENT_REF_NAMESPACE);
    }

    private ICompilationUnit createTestXmlElementRefWithStringElement(final String element, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementRef"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRef(" + element + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestXmlElementRefWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementRef"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRef(" + booleanElement + " = true)");
            }
        });
    }

    private ICompilationUnit createTestXmlElementRefWithType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementRef"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRef(type = String.class)");
            }
        });
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertTrue((xmlElementRefAnnotation != null ? 1 : 0) != 0);
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getName());
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getNamespace());
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getType());
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertTrue((xmlElementRefAnnotation != null ? 1 : 0) != 0);
        XmlElementRefAnnotationTests.assertEquals((String)XML_ELEMENT_REF_NAME, (String)xmlElementRefAnnotation.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getName());
        xmlElementRefAnnotation.setName(XML_ELEMENT_REF_NAME);
        XmlElementRefAnnotationTests.assertEquals((String)XML_ELEMENT_REF_NAME, (String)xmlElementRefAnnotation.getName());
        this.assertSourceContains("@XmlElementRef(name = \"elementName\")", cu);
        xmlElementRefAnnotation.setName(null);
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getName());
        this.assertSourceContains("@XmlElementRef", cu);
        this.assertSourceDoesNotContain("@XmlElementRef(name = \"elementName\")", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertTrue((xmlElementRefAnnotation != null ? 1 : 0) != 0);
        XmlElementRefAnnotationTests.assertEquals((String)XML_ELEMENT_REF_NAMESPACE, (String)xmlElementRefAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getNamespace());
        xmlElementRefAnnotation.setNamespace(XML_ELEMENT_REF_NAMESPACE);
        XmlElementRefAnnotationTests.assertEquals((String)XML_ELEMENT_REF_NAMESPACE, (String)xmlElementRefAnnotation.getNamespace());
        this.assertSourceContains("@XmlElementRef(namespace = \"XmlElementRefNamespace\")", cu);
        xmlElementRefAnnotation.setNamespace(null);
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getNamespace());
        this.assertSourceContains("@XmlElementRef", cu);
        this.assertSourceDoesNotContain("@XmlElementRef(namespace = \"XmlElementRefNamespace\")", cu);
    }

    public void testGetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithBooleanElement("required");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementRefAnnotation.getRequired());
    }

    public void testSetRequired() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertNotNull((Object)xmlElementRefAnnotation);
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getRequired());
        xmlElementRefAnnotation.setRequired(Boolean.FALSE);
        XmlElementRefAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlElementRefAnnotation.getRequired());
        this.assertSourceContains("@XmlElementRef(required = false)", cu);
        xmlElementRefAnnotation.setRequired(null);
        this.assertSourceContains("@XmlElementRef", cu);
        this.assertSourceDoesNotContain("required", cu);
    }

    public void testGetType() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertTrue((xmlElementRefAnnotation != null ? 1 : 0) != 0);
        XmlElementRefAnnotationTests.assertEquals((String)XML_ELEMENT_REF_TYPE, (String)xmlElementRefAnnotation.getType());
        XmlElementRefAnnotationTests.assertEquals((String)"java.lang.String", (String)xmlElementRefAnnotation.getFullyQualifiedTypeName());
    }

    public void testSetType() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getType());
        xmlElementRefAnnotation.setType(XML_ELEMENT_REF_TYPE);
        XmlElementRefAnnotationTests.assertEquals((String)XML_ELEMENT_REF_TYPE, (String)xmlElementRefAnnotation.getType());
        this.assertSourceContains("@XmlElementRef(type = String.class", cu);
        xmlElementRefAnnotation.setType(null);
        XmlElementRefAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getType());
        this.assertSourceContains("@XmlElementRef", cu);
        this.assertSourceDoesNotContain("@XmlElementRef(type = String.class", cu);
    }
}

