/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlElementsMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlElementsMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlElementsMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlElements() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElements"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElements");
            }
        });
    }

    protected NormalAnnotation newXmlElementAnnotation(AST ast, String name) {
        NormalAnnotation annotation = this.newNormalAnnotation(ast, "javax.xml.bind.annotation.XmlElement");
        this.addMemberValuePair(annotation, "name", name);
        return annotation;
    }

    protected void addXmlElement(ModifiedDeclaration declaration, int index, String name) {
        NormalAnnotation arrayElement = this.newXmlElementAnnotation(declaration.getAst(), name);
        this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlElements", index, "value", (Expression)arrayElement);
    }

    protected void moveXmlElement(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElements"), "value", targetIndex, sourceIndex);
    }

    protected void removeXmlElement(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElements"), "value", index);
    }

    public void testSyncXmlElements() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaXmlElementsMapping mapping = (JavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ListIterable xmlElements = mapping.getXmlElements();
        GenericJavaXmlElementsMappingTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlElements));
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)mapping.getXmlElementsSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.addXmlElement(declaration, 0, "foo");
                GenericJavaXmlElementsMappingTests.this.addXmlElement(declaration, 1, "bar");
            }
        });
        xmlElements = mapping.getXmlElements();
        GenericJavaXmlElementsMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)mapping.getXmlElements()));
        GenericJavaXmlElementsMappingTests.assertEquals((int)2, (int)mapping.getXmlElementsSize());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"foo", (String)((XmlElement)IterableTools.get((Iterable)xmlElements, (int)0)).getQName().getName());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"bar", (String)((XmlElement)IterableTools.get((Iterable)xmlElements, (int)1)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.moveXmlElement(declaration, 0, 1);
            }
        });
        xmlElements = mapping.getXmlElements();
        GenericJavaXmlElementsMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)mapping.getXmlElements()));
        GenericJavaXmlElementsMappingTests.assertEquals((int)2, (int)mapping.getXmlElementsSize());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"bar", (String)((XmlElement)IterableTools.get((Iterable)xmlElements, (int)0)).getQName().getName());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"foo", (String)((XmlElement)IterableTools.get((Iterable)xmlElements, (int)1)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.removeXmlElement(declaration, 1);
                GenericJavaXmlElementsMappingTests.this.removeXmlElement(declaration, 0);
            }
        });
        xmlElements = mapping.getXmlElements();
        GenericJavaXmlElementsMappingTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlElements));
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)mapping.getXmlElementsSize());
    }

    public void testModifyXmlElements() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaXmlElementsMapping mapping = (JavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementsAnnotation xmlElementsAnnotation = (XmlElementsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElements");
        ListIterable xmlElementAnnotations = xmlElementsAnnotation.getXmlElements();
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)xmlElementsAnnotation.getXmlElementsSize());
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)mapping.getXmlElementsSize());
        mapping.addXmlElement(0).getQName().setSpecifiedName("foo");
        mapping.addXmlElement(1).getQName().setSpecifiedName("baz");
        mapping.addXmlElement(1).getQName().setSpecifiedName("bar");
        xmlElementAnnotations = xmlElementsAnnotation.getXmlElements();
        GenericJavaXmlElementsMappingTests.assertEquals((int)3, (int)xmlElementsAnnotation.getXmlElementsSize());
        GenericJavaXmlElementsMappingTests.assertEquals((int)3, (int)mapping.getXmlElementsSize());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"foo", (String)((XmlElementAnnotation)IterableTools.get((Iterable)xmlElementAnnotations, (int)0)).getName());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"bar", (String)((XmlElementAnnotation)IterableTools.get((Iterable)xmlElementAnnotations, (int)1)).getName());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"baz", (String)((XmlElementAnnotation)IterableTools.get((Iterable)xmlElementAnnotations, (int)2)).getName());
        mapping.moveXmlElement(1, 2);
        xmlElementAnnotations = xmlElementsAnnotation.getXmlElements();
        GenericJavaXmlElementsMappingTests.assertEquals((int)3, (int)xmlElementsAnnotation.getXmlElementsSize());
        GenericJavaXmlElementsMappingTests.assertEquals((int)3, (int)mapping.getXmlElementsSize());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"foo", (String)((XmlElementAnnotation)IterableTools.get((Iterable)xmlElementAnnotations, (int)0)).getName());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"baz", (String)((XmlElementAnnotation)IterableTools.get((Iterable)xmlElementAnnotations, (int)1)).getName());
        GenericJavaXmlElementsMappingTests.assertEquals((String)"bar", (String)((XmlElementAnnotation)IterableTools.get((Iterable)xmlElementAnnotations, (int)2)).getName());
        mapping.removeXmlElement(2);
        mapping.removeXmlElement(0);
        mapping.removeXmlElement(0);
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)xmlElementsAnnotation.getXmlElementsSize());
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)mapping.getXmlElementsSize());
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaXmlElementsMapping mapping = (JavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        mapping.addXmlJavaTypeAdapter();
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        mapping.removeXmlJavaTypeAdapter();
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaXmlElementsMapping mapping = (JavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementsMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testModifyXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaXmlElementsMapping mapping = (JavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementsMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        mapping.addXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        mapping.removeXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementsMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
    }

    public void testUpdateXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaXmlElementsMapping mapping = (JavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementsMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementsMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
    }

    public void testModifyXmlIDREF() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaXmlElementsMapping mapping = (JavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlIDREF());
        GenericJavaXmlElementsMappingTests.assertNull((Object)xmlIDREFAnnotation);
        mapping.addXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)mapping.getXmlIDREF());
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        mapping.removeXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlIDREF());
        GenericJavaXmlElementsMappingTests.assertNull((Object)xmlIDREFAnnotation);
    }

    public void testUpdateXmlIDREF() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaXmlElementsMapping mapping = (JavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlIDREF());
        GenericJavaXmlElementsMappingTests.assertNull((Object)xmlIDREFAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)mapping.getXmlIDREF());
        GenericJavaXmlElementsMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementsMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementsMappingTests.assertNull((Object)mapping.getXmlIDREF());
        GenericJavaXmlElementsMappingTests.assertNull((Object)xmlIDREFAnnotation);
    }
}

