/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.core.resource.java.ManyToOneAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class ManyToOneTests
extends JpaJavaResourceModelTestCase {
    public ManyToOneTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestManyToOne() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToOne", "javax.persistence.FetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(fetch = FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithTargetEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(targetEntity = AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithOptional() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(optional = true)");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(cascade = CascadeType.ALL)");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithMultipleCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(cascade = {CascadeType.MERGE, CascadeType.REMOVE})");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithDuplicateCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.ManyToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(cascade = {CascadeType.MERGE, CascadeType.MERGE})");
            }
        });
    }

    public void testManyToOne() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertNotNull((Object)manyToOne);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((Object)FetchType.EAGER, (Object)manyToOne.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((Object)FetchType.EAGER, (Object)manyToOne.getFetch());
        manyToOne.setFetch(FetchType.LAZY);
        ManyToOneTests.assertEquals((Object)FetchType.LAZY, (Object)manyToOne.getFetch());
        this.assertSourceContains("@ManyToOne(fetch = LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((Object)FetchType.EAGER, (Object)manyToOne.getFetch());
        manyToOne.setFetch(null);
        ManyToOneTests.assertNull((Object)manyToOne.getFetch());
        this.assertSourceContains("@ManyToOne", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((String)"AnnotationTestType", (String)manyToOne.getTargetEntity());
    }

    public void testSetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((String)"AnnotationTestType", (String)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity("Foo");
        this.assertSourceContains("@ManyToOne(targetEntity = Foo.class)", cu);
    }

    public void testSetTargetEntityNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((String)"AnnotationTestType", (String)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity(null);
        this.assertSourceContains("@ManyToOne", cu);
        this.assertSourceDoesNotContain("targetEntity", cu);
    }

    public void testGetFullyQualifiedTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((String)"test.AnnotationTestType", (String)manyToOne.getFullyQualifiedTargetEntityClassName());
        manyToOne.setTargetEntity("Foo");
        this.assertSourceContains("@ManyToOne(targetEntity = Foo.class)", cu);
        ManyToOneTests.assertEquals((String)"Foo", (String)manyToOne.getTargetEntity());
        ManyToOneTests.assertEquals((String)"Foo", (String)manyToOne.getFullyQualifiedTargetEntityClassName());
    }

    public void testGetOptional() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOne.getOptional());
    }

    public void testSetOptional() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOne.getOptional());
        manyToOne.setOptional(Boolean.FALSE);
        ManyToOneTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOne.getOptional());
        this.assertSourceContains("@ManyToOne(optional = false)", cu);
    }

    public void testSetOptionalNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOne.getOptional());
        manyToOne.setOptional(null);
        ManyToOneTests.assertNull((Object)manyToOne.getOptional());
        this.assertSourceContains("@ManyToOne", cu);
        this.assertSourceDoesNotContain("optional", cu);
    }

    public void testSetCascadeAll() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertFalse((boolean)manyToOne.isCascadeAll());
        manyToOne.setCascadeAll(true);
        this.assertSourceContains("@ManyToOne(cascade = ALL)", cu);
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeAll());
    }

    public void testSetCascadeMerge() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertFalse((boolean)manyToOne.isCascadeMerge());
        manyToOne.setCascadeMerge(true);
        this.assertSourceContains("@ManyToOne(cascade = MERGE)", cu);
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeMerge());
    }

    public void testSetCascadePersist() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertFalse((boolean)manyToOne.isCascadePersist());
        manyToOne.setCascadePersist(true);
        this.assertSourceContains("@ManyToOne(cascade = PERSIST)", cu);
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadePersist());
    }

    public void testSetCascadeRemove() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertFalse((boolean)manyToOne.isCascadeRemove());
        manyToOne.setCascadeRemove(true);
        this.assertSourceContains("@ManyToOne(cascade = REMOVE)", cu);
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeRemove());
    }

    public void testSetCascadeRefresh() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertFalse((boolean)manyToOne.isCascadeRefresh());
        manyToOne.setCascadeRefresh(true);
        this.assertSourceContains("@ManyToOne(cascade = REFRESH)", cu);
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeRefresh());
    }

    public void testCascadeMoreThanOnce() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeAll());
        manyToOne.setCascadeAll(true);
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeAll());
        this.assertSourceContains("@ManyToOne(cascade = CascadeType.ALL)", cu);
        manyToOne.setCascadeAll(false);
        ManyToOneTests.assertFalse((boolean)manyToOne.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
        manyToOne.setCascadeAll(false);
        ManyToOneTests.assertFalse((boolean)manyToOne.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testDuplicateCascade() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithDuplicateCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeMerge());
        manyToOne.setCascadeMerge(false);
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeMerge());
        manyToOne.setCascadeMerge(false);
        ManyToOneTests.assertFalse((boolean)manyToOne.isCascadeMerge());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testMultipleCascade() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithMultipleCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)resourceField.getAnnotation("javax.persistence.ManyToOne");
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeMerge());
        ManyToOneTests.assertTrue((boolean)manyToOne.isCascadeRemove());
        manyToOne.setCascadeMerge(false);
        this.assertSourceContains("@ManyToOne(cascade = REMOVE)", cu);
        manyToOne.setCascadeRemove(false);
        this.assertSourceDoesNotContain("cascade", cu);
    }
}

