/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmStructConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @StructConverter");
            }
        });
    }

    public EclipseLinkOrmStructConverterTests(String name) {
        super(name);
    }

    public void testUpdateConverter() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmStructConverter ormConverter = ormBasicMapping.getConverterContainer().addStructConverter("structConverter", 0);
        XmlStructConverter converterResource = (XmlStructConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverters().get(0);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
        converterResource.setConverter("myConvert");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)converterResource.getConverter());
        converterResource.setConverter(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
    }

    public void testModifyConverter() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmStructConverter ormConverter = ormBasicMapping.getConverterContainer().addStructConverter("structConverter", 0);
        XmlStructConverter converterResource = (XmlStructConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverters().get(0);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
        ormConverter.setConverterClass("foo");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)converterResource.getConverter());
        ormConverter.setConverterClass(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmStructConverter ormConverter = ormBasicMapping.getConverterContainer().addStructConverter("structConverter", 0);
        XmlStructConverter converterResource = (XmlStructConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverters().get(0);
        EclipseLinkOrmStructConverterTests.assertEquals((String)"structConverter", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"structConverter", (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmStructConverter ormConverter = ormBasicMapping.getConverterContainer().addStructConverter("structConverter", 0);
        XmlStructConverter converterResource = (XmlStructConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverters().get(0);
        EclipseLinkOrmStructConverterTests.assertEquals((String)"structConverter", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"structConverter", (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
    }
}

