/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmEmbeddableTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkOrmEmbeddableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEmbeddableForCustomizer() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable", "customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable", "change-tracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForCustomConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForTypeConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForObjectTypeConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEmbeddableForStructConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }
        });
    }

    public void testUpdateCustomizerClass() throws Exception {
        this.createTestEmbeddableForCustomizer();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkJavaEmbeddable javaContextEmbeddable = (EclipseLinkJavaEmbeddable)ormPersistentType.getJavaPersistentType().getMapping();
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        resourceEmbeddable.setCustomizer(OrmFactory.eINSTANCE.createXmlClassReference());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer().getClassName());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        resourceEmbeddable.getCustomizer().setClassName("foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)resourceEmbeddable.getCustomizer().getClassName());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        resourceEmbeddable.getCustomizer().setClassName(null);
        javaContextEmbeddable.getCustomizer().setSpecifiedCustomizerClass("bar");
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer().getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEmbeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer().getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEmbeddable.setSpecifiedMetadataComplete(null);
        resourceEmbeddable.getCustomizer().setClassName("foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)resourceEmbeddable.getCustomizer().getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"bar", (String)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        javaContextEmbeddable.getCustomizer().setSpecifiedCustomizerClass(null);
        resourceEmbeddable.setCustomizer(null);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)javaContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
    }

    public void testModifyCustomizerClass() throws Exception {
        this.createTestEmbeddableForCustomizer();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEmbeddable.getCustomizer().setSpecifiedCustomizerClass("foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)resourceEmbeddable.getCustomizer().getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"foo", (String)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
        ormContextEmbeddable.getCustomizer().setSpecifiedCustomizerClass(null);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getCustomizer());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getDefaultCustomizerClass());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getCustomizer().getSpecifiedCustomizerClass());
    }

    public void testUpdateChangeTracking() throws Exception {
        this.createTestEmbeddableForChangeTracking();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkJavaEmbeddable javaContextEmbeddable = (EclipseLinkJavaEmbeddable)ormPersistentType.getJavaPersistentType().getMapping();
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.setChangeTracking(EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.ATTRIBUTE, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.OBJECT);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.DEFERRED);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.DEFERRED, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.AUTO);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.AUTO, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        resourceEmbeddable.setChangeTracking(null);
        javaContextEmbeddable.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.setSpecifiedMetadataComplete(null);
        resourceEmbeddable.setChangeTracking(EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking());
        resourceEmbeddable.getChangeTracking().setType(XmlChangeTrackingType.OBJECT);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)javaContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
    }

    public void testModifyChangeTracking() throws Exception {
        this.createTestEmbeddableForChangeTracking();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.ATTRIBUTE);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.ATTRIBUTE, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.OBJECT);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.OBJECT, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.DEFERRED);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.DEFERRED, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)XmlChangeTrackingType.AUTO, (Object)resourceEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
        ormContextEmbeddable.getChangeTracking().setSpecifiedType(null);
        EclipseLinkOrmEmbeddableTests.assertNull((Object)resourceEmbeddable.getChangeTracking());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getType());
        EclipseLinkOrmEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)ormContextEmbeddable.getChangeTracking().getDefaultType());
        EclipseLinkOrmEmbeddableTests.assertNull((Object)ormContextEmbeddable.getChangeTracking().getSpecifiedType());
    }

    public void testUpdateCustomConverters() throws Exception {
        this.createTestEmbeddableForCustomConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEmbeddable.getConverterContainer();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getCustomConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter resourceConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlConverter();
        resourceEmbeddable.getConverters().add((Object)resourceConverter);
        resourceConverter.setClassName("Foo");
        resourceConverter.setName("myConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getCustomConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        EclipseLinkCustomConverter ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter resourceConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlConverter();
        resourceEmbeddable.getConverters().add(0, (Object)resourceConverter2);
        resourceConverter2.setClassName("Foo2");
        resourceConverter2.setName("myConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getConverters().move(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getConverters().remove(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getConverters().remove((Object)resourceConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getCustomConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.getCustomConverters().iterator().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }

    public void testModifyCustomConverters() throws Exception {
        this.createTestEmbeddableForCustomConverters();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEmbeddable.getConverterContainer();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getCustomConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmCustomConverter contextConverter = ormContextConverterHolder.addCustomConverter("myConverter", 0);
        contextConverter.setConverterClass("Foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEmbeddable.getConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getCustomConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        EclipseLinkCustomConverter ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLinkOrmCustomConverter contextConverter2 = ormContextConverterHolder.addCustomConverter("myConverter2", 0);
        contextConverter2.setConverterClass("Foo2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEmbeddable.getConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEmbeddable.getConverters().get(1)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEmbeddable.getConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverterHolder.moveCustomConverter(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEmbeddable.getConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(1)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEmbeddable.getConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverterHolder.removeCustomConverter(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEmbeddable.getConverters().get(0)).getClassName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEmbeddable.getConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverterHolder.removeCustomConverter((EclipseLinkCustomConverter)contextConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getCustomConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.getCustomConverters().iterator().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getConverters().size());
    }

    public void testUpdateTypeConverters() throws Exception {
        this.createTestEmbeddableForTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEmbeddable.getConverterContainer();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        XmlTypeConverter resourceTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverter();
        resourceEmbeddable.getTypeConverters().add((Object)resourceTypeConverter);
        resourceTypeConverter.setDataType("Foo");
        resourceTypeConverter.setName("myTypeConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getTypeConvertersSize());
        ListIterator ormContextTypeConverters = ormContextConverterHolder.getTypeConverters().iterator();
        EclipseLinkTypeConverter ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        XmlTypeConverter resourceTypeConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverter();
        resourceEmbeddable.getTypeConverters().add(0, (Object)resourceTypeConverter2);
        resourceTypeConverter2.setDataType("Foo2");
        resourceTypeConverter2.setName("myTypeConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getTypeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.getTypeConverters().iterator();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getTypeConverters().move(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getTypeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.getTypeConverters().iterator();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getTypeConverters().remove(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getTypeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.getTypeConverters().iterator();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getTypeConverters().remove((Object)resourceTypeConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.getTypeConverters().iterator().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }

    public void testModifyTypeConverters() throws Exception {
        this.createTestEmbeddableForTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEmbeddable.getConverterContainer();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        EclipseLinkOrmTypeConverter contextTypeConverter = ormContextConverterHolder.addTypeConverter("myTypeConverter", 0);
        contextTypeConverter.setDataType("Foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getTypeConvertersSize());
        ListIterator ormContextTypeConverters = ormContextConverterHolder.getTypeConverters().iterator();
        EclipseLinkTypeConverter ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        EclipseLinkOrmTypeConverter contextTypeConverter2 = ormContextConverterHolder.addTypeConverter("myTypeConverter2", 0);
        contextTypeConverter2.setDataType("Foo2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getTypeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.getTypeConverters().iterator();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.moveTypeConverter(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getTypeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.getTypeConverters().iterator();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter", (String)ormContextTypeConverter.getName());
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.removeTypeConverter(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)((XmlTypeConverter)resourceEmbeddable.getTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getTypeConvertersSize());
        ormContextTypeConverters = ormContextConverterHolder.getTypeConverters().iterator();
        ormContextTypeConverter = (EclipseLinkTypeConverter)ormContextTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myTypeConverter2", (String)ormContextTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.removeTypeConverter((EclipseLinkTypeConverter)contextTypeConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.getTypeConverters().iterator().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }

    public void testUpdateObjectTypeConverters() throws Exception {
        this.createTestEmbeddableForObjectTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEmbeddable.getConverterContainer();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        XmlObjectTypeConverter resourceObjectTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverter();
        resourceEmbeddable.getObjectTypeConverters().add((Object)resourceObjectTypeConverter);
        resourceObjectTypeConverter.setDataType("Foo");
        resourceObjectTypeConverter.setName("myObjectTypeConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        ListIterator ormContextObjectTypeConverters = ormContextConverterHolder.getObjectTypeConverters().iterator();
        EclipseLinkObjectTypeConverter ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        XmlObjectTypeConverter resourceObjectTypeConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverter();
        resourceEmbeddable.getObjectTypeConverters().add(0, (Object)resourceObjectTypeConverter2);
        resourceObjectTypeConverter2.setDataType("Foo2");
        resourceObjectTypeConverter2.setName("myObjectTypeConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.getObjectTypeConverters().iterator();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getObjectTypeConverters().move(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.getObjectTypeConverters().iterator();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getObjectTypeConverters().remove(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.getObjectTypeConverters().iterator();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getObjectTypeConverters().remove((Object)resourceObjectTypeConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.getObjectTypeConverters().iterator().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }

    public void testModifyObjectTypeConverters() throws Exception {
        this.createTestEmbeddableForObjectTypeConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEmbeddable.getConverterContainer();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter = ormContextConverterHolder.addObjectTypeConverter("myObjectTypeConverter", 0);
        contextObjectTypeConverter.setDataType("Foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        ListIterator ormContextObjectTypeConverters = ormContextConverterHolder.getObjectTypeConverters().iterator();
        EclipseLinkObjectTypeConverter ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter2 = ormContextConverterHolder.addObjectTypeConverter("myObjectTypeConverter2", 0);
        contextObjectTypeConverter2.setDataType("Foo2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.getObjectTypeConverters().iterator();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.moveObjectTypeConverter(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(1)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.getObjectTypeConverters().iterator();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter", (String)ormContextObjectTypeConverter.getName());
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.removeObjectTypeConverter(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)((XmlObjectTypeConverter)resourceEmbeddable.getObjectTypeConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        ormContextObjectTypeConverters = ormContextConverterHolder.getObjectTypeConverters().iterator();
        ormContextObjectTypeConverter = (EclipseLinkObjectTypeConverter)ormContextObjectTypeConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextObjectTypeConverter.getDataType());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myObjectTypeConverter2", (String)ormContextObjectTypeConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.removeObjectTypeConverter((EclipseLinkObjectTypeConverter)contextObjectTypeConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getObjectTypeConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.getObjectTypeConverters().iterator().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getObjectTypeConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }

    public void testUpdateStructConverters() throws Exception {
        this.createTestEmbeddableForStructConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEmbeddable.getConverterContainer();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getStructConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        XmlStructConverter resourceStructConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverter();
        resourceEmbeddable.getStructConverters().add((Object)resourceStructConverter);
        resourceStructConverter.setConverter("Foo");
        resourceStructConverter.setName("myStructConverter");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getStructConvertersSize());
        ListIterator ormContextStructConverters = ormContextConverterHolder.getStructConverters().iterator();
        EclipseLinkStructConverter ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        XmlStructConverter resourceStructConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverter();
        resourceEmbeddable.getStructConverters().add(0, (Object)resourceStructConverter2);
        resourceStructConverter2.setConverter("Foo2");
        resourceStructConverter2.setName("myStructConverter2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getStructConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.getStructConverters().iterator();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getStructConverters().move(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getStructConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.getStructConverters().iterator();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getStructConverters().remove(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getStructConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.getStructConverters().iterator();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEmbeddable.getStructConverters().remove((Object)resourceStructConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getStructConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.getStructConverters().iterator().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }

    public void testModifyStructConverters() throws Exception {
        this.createTestEmbeddableForStructConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.AnnotationTestType");
        EclipseLinkOrmEmbeddable ormContextEmbeddable = (EclipseLinkOrmEmbeddable)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEmbeddable.getConverterContainer();
        XmlEmbeddable resourceEmbeddable = (XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getStructConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        EclipseLinkOrmStructConverter contextStructConverter = ormContextConverterHolder.addStructConverter("myStructConverter", 0);
        contextStructConverter.setConverterClass("Foo");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getStructConvertersSize());
        ListIterator ormContextStructConverters = ormContextConverterHolder.getStructConverters().iterator();
        EclipseLinkStructConverter ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        EclipseLinkOrmStructConverter contextStructConverter2 = ormContextConverterHolder.addStructConverter("myStructConverter2", 0);
        contextStructConverter2.setConverterClass("Foo2");
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(1)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getStructConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.getStructConverters().iterator();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.moveStructConverter(0, 1);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(1)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(1)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)ormContextConverterHolder.getStructConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.getStructConverters().iterator();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter", (String)ormContextStructConverter.getName());
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.removeStructConverter(0);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getConverter());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)((XmlStructConverter)resourceEmbeddable.getStructConverters().get(0)).getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)ormContextConverterHolder.getStructConvertersSize());
        ormContextStructConverters = ormContextConverterHolder.getStructConverters().iterator();
        ormContextStructConverter = (EclipseLinkStructConverter)ormContextStructConverters.next();
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"Foo2", (String)ormContextStructConverter.getConverterClass());
        EclipseLinkOrmEmbeddableTests.assertEquals((String)"myStructConverter2", (String)ormContextStructConverter.getName());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.removeStructConverter((EclipseLinkStructConverter)contextStructConverter2);
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)ormContextConverterHolder.getStructConvertersSize());
        EclipseLinkOrmEmbeddableTests.assertFalse((boolean)ormContextConverterHolder.getStructConverters().iterator().hasNext());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)resourceEmbeddable.getStructConverters().size());
        EclipseLinkOrmEmbeddableTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }
}

