/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbContextRoot;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJaxbContextRootTests
extends ELJaxbContextModelTestCase {
    public ELJaxbContextRootTests(String name) {
        super(name);
    }

    protected void addOxmFile(String fileName, String packageName) throws Exception {
        IFile oxmFile = this.getJavaProjectTestHarness().getProject().getFolder("src").getFile(fileName);
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(CR);
        sb.append("<xml-bindings package-name=\"").append(packageName).append("\"").append(CR);
        sb.append("    xmlns=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm\"").append(CR);
        sb.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(CR);
        sb.append("    xsi:schemaLocation=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm http://www.eclipse.org/eclipselink/xsds/eclipselink_oxm_2_4.xsd\"").append(CR);
        sb.append("    version=\"2.4\"/>").append(CR);
        oxmFile.create((InputStream)new ByteArrayInputStream(sb.toString().getBytes()), true, null);
    }

    public void testOxmFiles() throws Exception {
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        ELJaxbContextRootTests.assertEquals((int)0, (int)root.getOxmFilesSize());
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRootTests.assertEquals((int)1, (int)root.getOxmFilesSize());
        ELJaxbContextRootTests.assertNull((Object)root.getOxmFile("fake.pkg"));
        ELJaxbContextRootTests.assertNotNull((Object)root.getOxmFile("test.oxm"));
        this.addOxmFile("oxm2.xml", "test.oxm");
        ELJaxbContextRootTests.assertEquals((int)2, (int)root.getOxmFilesSize());
        ELJaxbContextRootTests.assertNotNull((Object)root.getOxmFile("test.oxm"));
        this.addOxmFile("oxm3.xml", "test.oxm2");
        ELJaxbContextRootTests.assertEquals((int)3, (int)root.getOxmFilesSize());
        ELJaxbContextRootTests.assertNotNull((Object)root.getOxmFile("test.oxm2"));
        this.getJavaProjectTestHarness().getProject().getFolder("src").getFile("oxm.xml").delete(true, null);
        ELJaxbContextRootTests.assertEquals((int)2, (int)root.getOxmFilesSize());
        ELJaxbContextRootTests.assertNotNull((Object)root.getOxmFile("test.oxm"));
        this.getJavaProjectTestHarness().getProject().getFolder("src").getFile("oxm2.xml").delete(true, null);
        ELJaxbContextRootTests.assertEquals((int)1, (int)root.getOxmFilesSize());
        ELJaxbContextRootTests.assertNull((Object)root.getOxmFile("test.oxm"));
        this.getJavaProjectTestHarness().getProject().getFolder("src").getFile("oxm3.xml").delete(true, null);
        ELJaxbContextRootTests.assertEquals((int)0, (int)root.getOxmFilesSize());
    }
}

