/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.tomcat.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.AddServletOperation;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.jst.servlet.tomcat.tests.AllTomcatTests;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.LogUtility;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wst.common.tests.TaskViewUtility;

public class WebProjectCreationTomcatTest
extends TestCase {
    public void createSimpleProject(String projectName) throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
        this.setServerTargetProperty(dataModel);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    public void setServerTargetProperty(IDataModel dataModel) {
        dataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)AllTomcatTests.TOMCAT_RUNTIME.getId());
    }

    public static void createServlet(IDataModel model) throws Exception {
        AddServletOperation op = new AddServletOperation(model);
        op.execute(null, null);
        ProjectUtility.verifyProject((String)op.getTargetProject().getName(), (boolean)true);
        TaskViewUtility.verifyNoErrors();
    }

    public IDataModel setupStandaloneWebProject(String projectName, int j2eeVersion) throws Exception {
        this.createSimpleProject(projectName);
        IDataModel model = this.getWebComponentCreationDataModel(projectName, j2eeVersion);
        WebProjectCreationTomcatTest.createStandaloneWebProject(model);
        this.createServlet(projectName);
        return model;
    }

    public IDataModel setupStandaloneAnnotatedWebProject(String projectName, int j2eeVersion) throws Exception {
        this.createSimpleProject(projectName);
        IDataModel model = this.getWebComponentCreationDataModel(projectName, j2eeVersion);
        WebProjectCreationTomcatTest.createStandaloneWebProject(model);
        this.createAnnotatedServlet(projectName);
        return model;
    }

    public static void createStandaloneWebProject(IDataModel model) throws Exception {
        IDataModelOperation webOp = model.getDefaultOperation();
        webOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
        TaskViewUtility.verifyNoErrors();
    }

    private IDataModel getWebComponentCreationDataModel(String projectName, int j2eeVersion) {
        IProject javaProject = ProjectUtility.getProject((String)projectName);
        String moduleName = String.valueOf(projectName) + "WebModule";
        String cfr_ignored_0 = String.valueOf(moduleName) + ".war";
        IDataModel model = DataModelFactory.createDataModel(IWebFacetInstallDataModelProperties.class);
        model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)javaProject.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel webModel = map.getFacetDataModel("jst.web");
        webModel.setIntProperty("IFacetDataModelPropeties.FACET_VERSION", j2eeVersion);
        return model;
    }

    private void createServlet(String projectName) throws Exception {
        IDataModel servletModel = this.setupServletCreationDataModel(projectName, false);
        WebProjectCreationTomcatTest.createServlet(servletModel);
    }

    private void createAnnotatedServlet(String projectName) throws Exception {
        IDataModel servletModel = this.setupServletCreationDataModel(projectName, true);
        WebProjectCreationTomcatTest.createServlet(servletModel);
    }

    public IDataModel setupServletCreationDataModel(String projectName, boolean isAnnotated) {
        IDataModel servletDataModel = DataModelFactory.createDataModel(NewServletClassDataModelProvider.class);
        servletDataModel.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)projectName);
        servletDataModel.setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", (Object)projectName);
        servletDataModel.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)"FooServlet");
        servletDataModel.setProperty("NewServletClassDataModel.DISPLAY_NAME", (Object)"FooServlet");
        servletDataModel.setBooleanProperty("IAnnotationsDataModel.useAnnotations", isAnnotated);
        return servletDataModel;
    }

    public void createVaildProjectAndServletCreation(String projectName, int j2eeVersion) throws Exception {
        LogUtility.getInstance().resetLogging();
        IDataModel model = null;
        model = this.setupStandaloneWebProject(projectName, j2eeVersion);
        LogUtility.getInstance().verifyNoWarnings();
        this.checkValidDataModel(model);
    }

    public void createVaildAnnotatedProjectAndServletCreation(String projectName, int j2eeVersion) throws Exception {
        LogUtility.getInstance().resetLogging();
        IDataModel model = null;
        model = this.setupStandaloneAnnotatedWebProject(projectName, j2eeVersion);
        LogUtility.getInstance().verifyNoWarnings();
        this.checkValidDataModel(model);
    }

    protected void checkValidDataModel(IDataModel model) {
    }

    public void testVaild12WebProjectNameCreation() throws Exception {
        ProjectUtility.deleteAllProjects();
        this.createVaildProjectAndServletCreation("FooTomcatWebProject12", 22);
    }

    public void testVaild13WebProjectNameCreation() throws Exception {
        ProjectUtility.deleteAllProjects();
        this.createVaildProjectAndServletCreation("Foo1TomcatWebProject13", 23);
    }

    public void testVaild14WebProjectNameCreation() throws Exception {
        ProjectUtility.deleteAllProjects();
        this.createVaildProjectAndServletCreation("Foo1TomcatWebProject14", 24);
    }

    public static Test suite() {
        return new SimpleTestSuite(WebProjectCreationTomcatTest.class);
    }

    public IDataModel getProjectCreationDataModel() {
        return null;
    }
}

