/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import [Ljava.lang.Object;;
import java.awt.Image;
import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.xml.rpc.holders.Holder;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.OctetStream;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.types.Day;
import org.apache.axis.types.Duration;
import org.apache.axis.types.Entities;
import org.apache.axis.types.Entity;
import org.apache.axis.types.HexBinary;
import org.apache.axis.types.IDRef;
import org.apache.axis.types.IDRefs;
import org.apache.axis.types.Id;
import org.apache.axis.types.Language;
import org.apache.axis.types.Month;
import org.apache.axis.types.MonthDay;
import org.apache.axis.types.NCName;
import org.apache.axis.types.NMToken;
import org.apache.axis.types.NMTokens;
import org.apache.axis.types.Name;
import org.apache.axis.types.NegativeInteger;
import org.apache.axis.types.NonNegativeInteger;
import org.apache.axis.types.NonPositiveInteger;
import org.apache.axis.types.NormalizedString;
import org.apache.axis.types.PositiveInteger;
import org.apache.axis.types.Time;
import org.apache.axis.types.Token;
import org.apache.axis.types.URI;
import org.apache.axis.types.UnsignedByte;
import org.apache.axis.types.UnsignedInt;
import org.apache.axis.types.UnsignedLong;
import org.apache.axis.types.UnsignedShort;
import org.apache.axis.types.Year;
import org.apache.axis.types.YearMonth;
import org.apache.axis.utils.ArrayUtil;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class JavaUtils {
    protected static Log log = LogFactory.getLog(JavaUtils.class.getName());
    public static final char NL = '\n';
    public static final char CR = '\r';
    public static final String LS = System.getProperty("line.separator", new Character('\n').toString());
    static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final char keywordPrefix = '_';
    private static WeakHashMap enumMap = new WeakHashMap();
    private static boolean checkForAttachmentSupport = true;
    private static boolean attachmentSupportEnabled = false;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    private JavaUtils() {
    }

    public static Class getWrapperClass(Class primitive) {
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static String getWrapper(String primitive) {
        if (primitive.equals("int")) {
            return "Integer";
        }
        if (primitive.equals("short")) {
            return "Short";
        }
        if (primitive.equals("boolean")) {
            return "Boolean";
        }
        if (primitive.equals("byte")) {
            return "Byte";
        }
        if (primitive.equals("long")) {
            return "Long";
        }
        if (primitive.equals("double")) {
            return "Double";
        }
        if (primitive.equals("float")) {
            return "Float";
        }
        if (primitive.equals("char")) {
            return "Character";
        }
        return null;
    }

    public static Class getPrimitiveClass(Class wrapper) {
        if (wrapper == Integer.class) {
            return Integer.TYPE;
        }
        if (wrapper == Short.class) {
            return Short.TYPE;
        }
        if (wrapper == Boolean.class) {
            return Boolean.TYPE;
        }
        if (wrapper == Byte.class) {
            return Byte.TYPE;
        }
        if (wrapper == Long.class) {
            return Long.TYPE;
        }
        if (wrapper == Double.class) {
            return Double.TYPE;
        }
        if (wrapper == Float.class) {
            return Float.TYPE;
        }
        if (wrapper == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    public static Class getPrimitiveClassFromName(String primitive) {
        if (primitive.equals("int")) {
            return Integer.TYPE;
        }
        if (primitive.equals("short")) {
            return Short.TYPE;
        }
        if (primitive.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (primitive.equals("byte")) {
            return Byte.TYPE;
        }
        if (primitive.equals("long")) {
            return Long.TYPE;
        }
        if (primitive.equals("double")) {
            return Double.TYPE;
        }
        if (primitive.equals("float")) {
            return Float.TYPE;
        }
        if (primitive.equals("char")) {
            return Character.TYPE;
        }
        return null;
    }

    public static boolean isBasic(Class javaType) {
        return javaType.isPrimitive() || javaType == String.class || javaType == Boolean.class || javaType == Float.class || javaType == Double.class || Number.class.isAssignableFrom(javaType) || javaType == Day.class || javaType == Duration.class || javaType == Entities.class || javaType == Entity.class || javaType == HexBinary.class || javaType == Id.class || javaType == IDRef.class || javaType == IDRefs.class || javaType == Language.class || javaType == Month.class || javaType == MonthDay.class || javaType == Name.class || javaType == NCName.class || javaType == NegativeInteger.class || javaType == NMToken.class || javaType == NMTokens.class || javaType == NonNegativeInteger.class || javaType == NonPositiveInteger.class || javaType == NormalizedString.class || javaType == PositiveInteger.class || javaType == Time.class || javaType == Token.class || javaType == UnsignedByte.class || javaType == UnsignedInt.class || javaType == UnsignedLong.class || javaType == UnsignedShort.class || javaType == URI.class || javaType == Year.class || javaType == YearMonth.class;
    }

    public static Object convert(Object arg, Class destClass) {
        Class hintClass;
        Object newArg;
        if (destClass == null) {
            return arg;
        }
        Class argHeldType = null;
        if (arg != null) {
            argHeldType = JavaUtils.getHolderValueType(arg.getClass());
        }
        if (arg != null && argHeldType == null && destClass.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        if (log.isDebugEnabled()) {
            String clsName = "null";
            if (arg != null) {
                clsName = arg.getClass().getName();
            }
            log.debug((Object)Messages.getMessage("convert00", clsName, destClass.getName()));
        }
        Object destValue = null;
        if (arg instanceof ConvertCache && (destValue = ((ConvertCache)arg).getConvertedValue(destClass)) != null) {
            return destValue;
        }
        Class destHeldType = JavaUtils.getHolderValueType(destClass);
        if (arg instanceof HexBinary && destClass == [B.class) {
            return ((HexBinary)arg).getBytes();
        }
        if (arg instanceof byte[] && destClass == HexBinary.class) {
            return new HexBinary((byte[])arg);
        }
        if (arg instanceof Calendar && destClass == java.util.Date.class) {
            return ((Calendar)arg).getTime();
        }
        if (arg instanceof java.util.Date && destClass == Calendar.class) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((java.util.Date)arg);
            return calendar;
        }
        if (arg instanceof Calendar && destClass == Date.class) {
            return new Date(((Calendar)arg).getTime().getTime());
        }
        if (arg instanceof HashMap && destClass == Hashtable.class) {
            return new Hashtable((HashMap)arg);
        }
        if (JavaUtils.isAttachmentSupported() && (arg instanceof InputStream || arg instanceof AttachmentPart || arg instanceof DataHandler)) {
            try {
                String destName = destClass.getName();
                if (destClass == String.class || destClass == OctetStream.class || destClass == [B.class || destClass == Image.class || destClass == Source.class || destClass == DataHandler.class || destName.equals("javax.mail.internet.MimeMultipart")) {
                    DataHandler handler = null;
                    if (arg instanceof AttachmentPart) {
                        handler = ((AttachmentPart)arg).getDataHandler();
                    } else if (arg instanceof DataHandler) {
                        handler = (DataHandler)arg;
                    }
                    if (destClass == Image.class) {
                        InputStream is = handler.getInputStream();
                        if (is.available() == 0) {
                            return null;
                        }
                        return ImageIO.read(is);
                    }
                    if (destClass == Source.class) {
                        return new StreamSource(handler.getInputStream());
                    }
                    if (destClass == OctetStream.class || destClass == [B.class) {
                        InputStream in = null;
                        in = arg instanceof InputStream ? (InputStream)arg : handler.getInputStream();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int byte1 = -1;
                        while ((byte1 = in.read()) != -1) {
                            baos.write(byte1);
                        }
                        return new OctetStream(baos.toByteArray());
                    }
                    if (destClass == DataHandler.class) {
                        return handler;
                    }
                    return handler.getContent();
                }
            }
            catch (IOException destName) {
            }
            catch (SOAPException destName) {
                // empty catch block
            }
        }
        if (arg != null && destClass.isArray() && !destClass.getComponentType().equals(Object.class) && destClass.getComponentType().isAssignableFrom(arg.getClass())) {
            Object array = Array.newInstance(destClass.getComponentType(), 1);
            Array.set(array, 0, arg);
            return array;
        }
        if (arg != null && destClass.isArray() && ((newArg = ArrayUtil.convertObjectToArray(arg, destClass)) == null || newArg != ArrayUtil.NON_CONVERTABLE && newArg != arg)) {
            return newArg;
        }
        if (arg != null && arg.getClass().isArray() && (newArg = ArrayUtil.convertArrayToObject(arg, destClass)) != null) {
            return newArg;
        }
        if (!(arg instanceof Collection) && (arg == null || !arg.getClass().isArray()) && (destHeldType == null && argHeldType == null || destHeldType != null && argHeldType != null)) {
            return arg;
        }
        if (destHeldType != null) {
            newArg = JavaUtils.convert(arg, destHeldType);
            Object argHolder = null;
            try {
                argHolder = destClass.newInstance();
                JavaUtils.setHolderValue(argHolder, newArg);
                return argHolder;
            }
            catch (Exception e) {
                return arg;
            }
        }
        if (argHeldType != null) {
            try {
                newArg = JavaUtils.getHolderValue(arg);
                return JavaUtils.convert(newArg, destClass);
            }
            catch (HolderException e) {
                return arg;
            }
        }
        if (arg instanceof ConvertCache && ((ConvertCache)arg).getDestClass() != destClass && (hintClass = ((ConvertCache)arg).getDestClass()) != null && hintClass.isArray() && destClass.isArray() && destClass.isAssignableFrom(hintClass) && (destValue = ((ConvertCache)arg).getConvertedValue(destClass = hintClass)) != null) {
            return destValue;
        }
        if (arg == null) {
            return arg;
        }
        int length = 0;
        length = arg.getClass().isArray() ? Array.getLength(arg) : ((Collection)arg).size();
        if (destClass.isArray()) {
            if (destClass.getComponentType().isPrimitive()) {
                Object array = Array.newInstance(destClass.getComponentType(), length);
                if (arg.getClass().isArray()) {
                    for (int i = 0; i < length; ++i) {
                        Array.set(array, i, Array.get(arg, i));
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        Array.set(array, idx++, i.next());
                    }
                }
                destValue = array;
            } else {
                Object[] array;
                try {
                    array = (Object[])Array.newInstance(destClass.getComponentType(), length);
                }
                catch (Exception e) {
                    return arg;
                }
                if (arg.getClass().isArray()) {
                    for (int i = 0; i < length; ++i) {
                        array[i] = JavaUtils.convert(Array.get(arg, i), destClass.getComponentType());
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        array[idx++] = JavaUtils.convert(i.next(), destClass.getComponentType());
                    }
                }
                destValue = array;
            }
        } else if (Collection.class.isAssignableFrom(destClass)) {
            Collection newList = null;
            try {
                newList = destClass == Collection.class || destClass == List.class ? new ArrayList() : (destClass == Set.class ? new HashSet() : (Collection)destClass.newInstance());
            }
            catch (Exception e) {
                return arg;
            }
            if (arg.getClass().isArray()) {
                for (int j = 0; j < length; ++j) {
                    newList.add(Array.get(arg, j));
                }
            } else {
                Iterator j = ((Collection)arg).iterator();
                while (j.hasNext()) {
                    newList.add(j.next());
                }
            }
            destValue = newList;
        } else {
            destValue = arg;
        }
        if (arg instanceof ConvertCache) {
            ((ConvertCache)arg).setConvertedValue(destClass, destValue);
        }
        return destValue;
    }

    public static boolean isConvertable(Object obj, Class dest) {
        return JavaUtils.isConvertable(obj, dest, false);
    }

    public static boolean isConvertable(Object obj, Class dest, boolean isEncoded) {
        Class<?> src = null;
        if (obj != null) {
            src = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        } else if (!dest.isPrimitive()) {
            return true;
        }
        if (dest == null) {
            return false;
        }
        if (src != null) {
            if (dest.isAssignableFrom(src)) {
                return true;
            }
            if (Map.class.isAssignableFrom(dest) && Map.class.isAssignableFrom(src)) {
                return true;
            }
            if (JavaUtils.getWrapperClass(src) == dest) {
                return true;
            }
            if (JavaUtils.getWrapperClass(dest) == src) {
                return true;
            }
            if ((Collection.class.isAssignableFrom(src) || src.isArray()) && (Collection.class.isAssignableFrom(dest) || dest.isArray()) && (src.getComponentType() == Object.class || src.getComponentType() == null || dest.getComponentType() == Object.class || dest.getComponentType() == null || JavaUtils.isConvertable(src.getComponentType(), dest.getComponentType()))) {
                return true;
            }
            if (!isEncoded && dest.isArray() && dest.getComponentType().isAssignableFrom(src)) {
                return true;
            }
            if (src == HexBinary.class && dest == [B.class || src == [B.class && dest == HexBinary.class) {
                return true;
            }
            if (Calendar.class.isAssignableFrom(src) && dest == java.util.Date.class) {
                return true;
            }
            if (java.util.Date.class.isAssignableFrom(src) && dest == Calendar.class) {
                return true;
            }
            if (Calendar.class.isAssignableFrom(src) && dest == Date.class) {
                return true;
            }
        }
        Class destHeld = JavaUtils.getHolderValueType(dest);
        if (src == null) {
            return destHeld != null;
        }
        if (destHeld != null && (destHeld.isAssignableFrom(src) || JavaUtils.isConvertable(src, destHeld))) {
            return true;
        }
        Class srcHeld = JavaUtils.getHolderValueType(src);
        if (srcHeld != null && (dest.isAssignableFrom(srcHeld) || JavaUtils.isConvertable(srcHeld, dest))) {
            return true;
        }
        if (dest.getName().equals("javax.activation.DataHandler")) {
            String name = src.getName();
            if (src == String.class || src == Image.class || src == OctetStream.class || name.equals("javax.mail.internet.MimeMultipart") || name.equals("javax.xml.transform.Source")) {
                return true;
            }
        }
        if (src.getName().equals("javax.activation.DataHandler")) {
            if (dest == [B.class) {
                return true;
            }
            if (dest.isArray() && dest.getComponentType() == [B.class) {
                return true;
            }
        }
        if (dest.getName().equals("javax.activation.DataHandler")) {
            if (src == Object;.class) {
                return true;
            }
            if (src.isArray() && src.getComponentType() == Object;.class) {
                return true;
            }
        }
        if (obj instanceof InputStream && dest == OctetStream.class) {
            return true;
        }
        if (src.isPrimitive()) {
            return JavaUtils.isConvertable(JavaUtils.getWrapperClass(src), dest);
        }
        if (dest.isArray() && ArrayUtil.isConvertable(src, dest)) {
            return true;
        }
        return src.isArray() && ArrayUtil.isConvertable(src, dest);
    }

    public static Image getImageFromStream(InputStream is) {
        try {
            return ImageIO.read(is);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isJavaId(String id) {
        if (id == null || id.equals("") || JavaUtils.isJavaKeyword(id)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public static String makeNonJavaKeyword(String keyword) {
        return '_' + keyword;
    }

    public static String getLoadableClassName(String text) {
        if (text == null || text.indexOf("[") < 0 || text.charAt(0) == '[') {
            return text;
        }
        String className = text.substring(0, text.indexOf("["));
        className = className.equals("byte") ? "B" : (className.equals("char") ? "C" : (className.equals("double") ? "D" : (className.equals("float") ? "F" : (className.equals("int") ? "I" : (className.equals("long") ? "J" : (className.equals("short") ? "S" : (className.equals("boolean") ? "Z" : "L" + className + ";")))))));
        int i = text.indexOf("]");
        while (i > 0) {
            className = "[" + className;
            i = text.indexOf("]", i + 1);
        }
        return className;
    }

    public static String getTextClassName(String text) {
        int index;
        if (text == null || text.indexOf("[") != 0) {
            return text;
        }
        String className = "";
        for (index = 0; index < text.length() && text.charAt(index) == '['; ++index) {
            className = className + "[]";
        }
        if (index < text.length()) {
            className = text.charAt(index) == 'B' ? "byte" + className : (text.charAt(index) == 'C' ? "char" + className : (text.charAt(index) == 'D' ? "double" + className : (text.charAt(index) == 'F' ? "float" + className : (text.charAt(index) == 'I' ? "int" + className : (text.charAt(index) == 'J' ? "long" + className : (text.charAt(index) == 'S' ? "short" + className : (text.charAt(index) == 'Z' ? "boolean" + className : text.substring(index + 1, text.indexOf(";")) + className)))))));
        }
        return className;
    }

    public static String xmlNameToJava(String name) {
        int i;
        if (name == null || name.equals("")) {
            return name;
        }
        char[] nameArray = name.toCharArray();
        int nameLen = name.length();
        StringBuffer result = new StringBuffer(nameLen);
        boolean wordStart = false;
        for (i = 0; i < nameLen && (JavaUtils.isPunctuation(nameArray[i]) || !Character.isJavaIdentifierStart(nameArray[i])); ++i) {
        }
        if (i < nameLen) {
            result.append(nameArray[i]);
            wordStart = !Character.isLetter(nameArray[i]) && nameArray[i] != "_".charAt(0);
        } else if (Character.isJavaIdentifierPart(nameArray[0])) {
            result.append("_" + nameArray[0]);
        } else {
            result.append("_" + nameArray.length);
        }
        ++i;
        while (i < nameLen) {
            char c = nameArray[i];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                wordStart = true;
            } else {
                if (wordStart && Character.isLowerCase(c)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                wordStart = !Character.isLetter(c) && c != "_".charAt(0);
            }
            ++i;
        }
        String newName = result.toString();
        if (Character.isUpperCase(newName.charAt(0))) {
            newName = Introspector.decapitalize(newName);
        }
        if (JavaUtils.isJavaKeyword(newName)) {
            newName = JavaUtils.makeNonJavaKeyword(newName);
        }
        return newName;
    }

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new String(sb);
    }

    public static Class getHolderValueType(Class type) {
        if (type != null) {
            Field field;
            Class<?>[] intf = type.getInterfaces();
            boolean isHolder = false;
            for (int i = 0; i < intf.length && !isHolder; ++i) {
                if (intf[i] != (class$javax$xml$rpc$holders$Holder == null ? JavaUtils.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder)) continue;
                isHolder = true;
            }
            if (!isHolder) {
                return null;
            }
            try {
                field = type.getField("value");
            }
            catch (Exception e) {
                field = null;
            }
            if (field != null) {
                return field.getType();
            }
        }
        return null;
    }

    public static Object getHolderValue(Object holder) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00"));
        }
        try {
            Field valueField = holder.getClass().getField("value");
            return valueField.get(holder);
        }
        catch (Exception e) {
            throw new HolderException(Messages.getMessage("exception01", e.getMessage()));
        }
    }

    public static void setHolderValue(Object holder, Object value) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00"));
        }
        try {
            Field valueField = holder.getClass().getField("value");
            if (valueField.getType().isPrimitive()) {
                if (value != null) {
                    valueField.set(holder, value);
                }
            } else {
                valueField.set(holder, value);
            }
        }
        catch (Exception e) {
            throw new HolderException(Messages.getMessage("exception01", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnumClass(Class cls) {
        Boolean b = (Boolean)enumMap.get(cls);
        if (b == null) {
            b = JavaUtils.isEnumClassSub(cls) ? Boolean.TRUE : Boolean.FALSE;
            WeakHashMap weakHashMap = enumMap;
            synchronized (weakHashMap) {
                enumMap.put(cls, b);
            }
        }
        return b;
    }

    private static boolean isEnumClassSub(Class cls) {
        try {
            Method[] methods = cls.getMethods();
            Method getValueMethod = null;
            Method fromValueMethod = null;
            Method setValueMethod = null;
            Method fromStringMethod = null;
            for (int i = 0; i < methods.length; ++i) {
                String name = methods[i].getName();
                if (name.equals("getValue") && methods[i].getParameterTypes().length == 0) {
                    getValueMethod = methods[i];
                    continue;
                }
                if (name.equals("fromString")) {
                    Class<?>[] params = methods[i].getParameterTypes();
                    if (params.length != 1 || params[0] != (class$java$lang$String == null ? JavaUtils.class$("java.lang.String") : class$java$lang$String)) continue;
                    fromStringMethod = methods[i];
                    continue;
                }
                if (name.equals("fromValue") && methods[i].getParameterTypes().length == 1) {
                    fromValueMethod = methods[i];
                    continue;
                }
                if (!name.equals("setValue") || methods[i].getParameterTypes().length != 1) continue;
                setValueMethod = methods[i];
            }
            if (null != getValueMethod && null != fromStringMethod) {
                return null == setValueMethod || setValueMethod.getParameterTypes().length != 1 || getValueMethod.getReturnType() != setValueMethod.getParameterTypes()[0];
            }
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static final boolean isTrue(String value) {
        return !JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isTrueExplicitly(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes"));
    }

    public static final boolean isTrueExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof String) {
            return JavaUtils.isTrueExplicitly((String)value);
        }
        return true;
    }

    public static final boolean isTrueExplicitly(Object value) {
        return JavaUtils.isTrueExplicitly(value, false);
    }

    public static final boolean isTrue(Object value, boolean defaultVal) {
        return !JavaUtils.isFalseExplicitly(value, !defaultVal);
    }

    public static final boolean isTrue(Object value) {
        return JavaUtils.isTrue(value, false);
    }

    public static final boolean isFalse(String value) {
        return JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isFalseExplicitly(String value) {
        return value == null || value.equalsIgnoreCase("false") || value.equals("0") || value.equalsIgnoreCase("no");
    }

    public static final boolean isFalseExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Integer) {
            return (Integer)value == 0;
        }
        if (value instanceof String) {
            return JavaUtils.isFalseExplicitly((String)value);
        }
        return false;
    }

    public static final boolean isFalseExplicitly(Object value) {
        return JavaUtils.isFalseExplicitly(value, true);
    }

    public static final boolean isFalse(Object value, boolean defaultVal) {
        return JavaUtils.isFalseExplicitly(value, defaultVal);
    }

    public static final boolean isFalse(Object value) {
        return JavaUtils.isFalse(value, true);
    }

    public static String mimeToJava(String mime) {
        if ("image/gif".equals(mime) || "image/jpeg".equals(mime)) {
            return "java.awt.Image";
        }
        if ("text/plain".equals(mime)) {
            return "java.lang.String";
        }
        if ("text/xml".equals(mime) || "application/xml".equals(mime)) {
            return "javax.xml.transform.Source";
        }
        if ("application/octet-stream".equals(mime) || "application/octetstream".equals(mime)) {
            return "org.apache.axis.attachments.OctetStream";
        }
        if (mime != null && mime.startsWith("multipart/")) {
            return "javax.mail.internet.MimeMultipart";
        }
        return "javax.activation.DataHandler";
    }

    public static synchronized boolean isAttachmentSupported() {
        if (checkForAttachmentSupport) {
            checkForAttachmentSupport = false;
            try {
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachmentSupportEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.debug((Object)(Messages.getMessage("attachEnabled") + "  " + attachmentSupportEnabled));
            if (!attachmentSupportEnabled) {
                log.warn((Object)Messages.getMessage("attachDisabled"));
            }
        }
        return attachmentSupportEnabled;
    }

    public static String getUniqueValue(Collection values, String initValue) {
        int end;
        if (!values.contains(initValue)) {
            return initValue;
        }
        StringBuffer unqVal = new StringBuffer(initValue);
        int beg = unqVal.length();
        while (Character.isDigit(unqVal.charAt(beg - 1))) {
            --beg;
        }
        if (beg == unqVal.length()) {
            unqVal.append('1');
        }
        int cur = end = unqVal.length() - 1;
        while (values.contains(unqVal.toString())) {
            if (unqVal.charAt(cur) < '9') {
                unqVal.setCharAt(cur, (char)(unqVal.charAt(cur) + '\u0001'));
                continue;
            }
            while (cur-- > beg) {
                if (unqVal.charAt(cur) >= '9') continue;
                unqVal.setCharAt(cur, (char)(unqVal.charAt(cur) + '\u0001'));
                break;
            }
            if (cur < beg) {
                unqVal.insert(++cur, '1');
                ++end;
            }
            while (cur < end) {
                unqVal.setCharAt(++cur, '0');
            }
        }
        return unqVal.toString();
    }

    public static class HolderException
    extends Exception {
        public HolderException(String msg) {
            super(msg);
        }
    }

    public static interface ConvertCache {
        public void setConvertedValue(Class var1, Object var2);

        public Object getConvertedValue(Class var1);

        public Class getDestClass();
    }
}

