/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.GeneratorContainer;
import org.eclipse.jpt.jpa.core.context.IdClassReference;
import org.eclipse.jpt.jpa.core.context.QueryContainer;
import org.eclipse.jpt.jpa.core.context.SpecifiedAccessReference;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.EntityNameCombo;
import org.eclipse.jpt.jpa.ui.internal.details.EntityOverridesComposite;
import org.eclipse.jpt.jpa.ui.internal.details.GenerationComposite;
import org.eclipse.jpt.jpa.ui.internal.details.IdClassChooser;
import org.eclipse.jpt.jpa.ui.internal.details.QueriesComposite;
import org.eclipse.jpt.jpa.ui.internal.details.TableComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractEntityComposite<T extends Entity>
extends Pane<T>
implements JpaComposite {
    protected AbstractEntityComposite(PropertyValueModel<? extends T> entityModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(entityModel, parentComposite, widgetFactory, resourceManager);
    }

    protected void initializeLayout(Composite container) {
        this.initializeEntityCollapsibleSection(container);
        this.initializeQueriesCollapsibleSection(container);
        this.initializeInheritanceCollapsibleSection(container);
        this.initializeAttributeOverridesCollapsibleSection(container);
        this.initializeGeneratorsCollapsibleSection(container);
        this.initializeSecondaryTablesCollapsibleSection(container);
    }

    protected void initializeEntityCollapsibleSection(Composite container) {
        Section section = this.getWidgetFactory().createSection(container, 322);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.ENTITY_SECTION_TITLE);
        section.setClient(this.initializeEntitySection((Composite)section));
    }

    protected Control initializeEntitySection(Composite container) {
        container = this.addSubPane(container, 2, 0, 0, 0, 0);
        TableComposite tableComposite = new TableComposite(this, container);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        tableComposite.getControl().setLayoutData((Object)gridData);
        this.addLabel(container, JptJpaUiDetailsMessages.ENTITY_NAME_COMPOSITE_NAME);
        new EntityNameCombo(this, container);
        Hyperlink hyperlink = this.addHyperlink(container, JptJpaUiDetailsMessages.ID_CLASS_COMPOSITE_LABEL);
        new IdClassChooser(this, this.buildIdClassReferenceModel(), container, hyperlink);
        return container;
    }

    protected PropertyValueModel<IdClassReference> buildIdClassReferenceModel() {
        return new PropertyAspectAdapter<T, IdClassReference>(this.getSubjectHolder()){

            protected IdClassReference buildValue_() {
                return ((Entity)this.subject).getIdClassReference();
            }
        };
    }

    protected void initializeQueriesCollapsibleSection(Composite container) {
        final Section section = this.getWidgetFactory().createSection(container, 258);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.ENTITY_COMPOSITE_QUERIES);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && section.getClient() == null) {
                    section.setClient(AbstractEntityComposite.this.initializeQueriesSection((Composite)section));
                }
            }
        });
    }

    protected Control initializeQueriesSection(Composite container) {
        return new QueriesComposite(this, this.buildQueryContainerModel(), container).getControl();
    }

    protected PropertyValueModel<QueryContainer> buildQueryContainerModel() {
        return new PropertyAspectAdapter<T, QueryContainer>(this.getSubjectHolder()){

            protected QueryContainer buildValue_() {
                return ((Entity)this.subject).getQueryContainer();
            }
        };
    }

    protected void initializeAttributeOverridesCollapsibleSection(Composite container) {
        final Section section = this.getWidgetFactory().createSection(container, 258);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.OVERRIDES_COMPOSITE_ATTRIBUTE_OVERRIDES_SECTION);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && section.getClient() == null) {
                    section.setClient(AbstractEntityComposite.this.initializeAttributeOverridesSection((Composite)section));
                }
            }
        });
    }

    protected Control initializeAttributeOverridesSection(Composite container) {
        return new EntityOverridesComposite(this, container).getControl();
    }

    protected void initializeInheritanceCollapsibleSection(Composite container) {
        final Section section = this.getWidgetFactory().createSection(container, 258);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.ENTITY_COMPOSITE_INHERITANCE);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && section.getClient() == null) {
                    section.setClient(AbstractEntityComposite.this.initializeInheritanceSection((Composite)section));
                }
            }
        });
    }

    protected abstract Control initializeInheritanceSection(Composite var1);

    protected void initializeGeneratorsCollapsibleSection(Composite container) {
        final Section section = this.getWidgetFactory().createSection(container, 258);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.ID_MAPPING_COMPOSITE_PRIMARY_KEY_GENERATION_SECTION);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && section.getClient() == null) {
                    section.setClient(AbstractEntityComposite.this.initializeGeneratorsSection((Composite)section));
                }
            }
        });
    }

    protected Control initializeGeneratorsSection(Composite container) {
        return new GenerationComposite(this, this.buildGeneratorContainerModel(), container).getControl();
    }

    protected PropertyValueModel<GeneratorContainer> buildGeneratorContainerModel() {
        return new PropertyAspectAdapter<T, GeneratorContainer>(this.getSubjectHolder()){

            protected GeneratorContainer buildValue_() {
                return ((Entity)this.subject).getGeneratorContainer();
            }
        };
    }

    protected void initializeSecondaryTablesCollapsibleSection(Composite container) {
        final Section section = this.getWidgetFactory().createSection(container, 258);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaUiDetailsMessages.SECONDARY_TABLES_COMPOSITE_SECONDARY_TABLES);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && section.getClient() == null) {
                    section.setClient(AbstractEntityComposite.this.initializeSecondaryTablesSection((Composite)section));
                }
            }
        });
    }

    protected abstract Control initializeSecondaryTablesSection(Composite var1);

    protected PropertyValueModel<SpecifiedAccessReference> buildAccessReferenceModel() {
        return new PropertyAspectAdapter<T, SpecifiedAccessReference>(this.getSubjectHolder()){

            protected SpecifiedAccessReference buildValue_() {
                return ((Entity)this.subject).getPersistentType();
            }
        };
    }
}

