/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.reference.AbstractObjectReference;

public final class LazyObjectReference<V>
extends AbstractObjectReference<V>
implements Cloneable,
Serializable {
    private volatile V value = null;
    private final Factory<V> factory;
    private static final long serialVersionUID = 1L;

    public LazyObjectReference(Factory<V> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValue() {
        V result = this.value;
        if (result == null) {
            LazyObjectReference lazyObjectReference = this;
            synchronized (lazyObjectReference) {
                result = this.value;
                if (result == null) {
                    result = this.value = this.factory.create();
                }
            }
        }
        return result;
    }

    public LazyObjectReference<V> clone() {
        try {
            LazyObjectReference clone = (LazyObjectReference)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

