/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import org.apache.wsil.Description;
import org.apache.wsil.Link;
import org.apache.wsil.QName;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionRegistry;
import org.apache.wsil.extension.uddi.BusinessDescription;
import org.apache.wsil.extension.uddi.ServiceDescription;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.extension.wsdl.ReferencedService;
import org.apache.wsil.impl.extension.uddi.UDDIExtensionBuilder;
import org.apache.wsil.impl.extension.wsdl.WSDLExtensionBuilder;
import org.apache.wsil.util.FileListBuilder;
import org.apache.wsil.util.Util;
import org.apache.wsil.util.WSDLDocument;
import org.apache.wsil.util.WSILProperties;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceList;
import org.uddi4j.util.BusinessKey;
import org.uddi4j.util.DiscoveryURL;
import org.uddi4j.util.DiscoveryURLs;
import org.uddi4j.util.ServiceKey;

public class WSILDocBuilder {
    protected static final int MAX_ROWS = 100;
    protected WSILDocument wsilDocument = null;

    public WSILDocBuilder() throws WSILException {
        this.wsilDocument = WSILDocument.newInstance();
    }

    public WSILDocBuilder(String root) throws WSILException, WSDLException, IOException {
        this.initWSDL(root);
    }

    public WSILDocBuilder(URL registryURL) throws WSILException {
        this.initUDDI(registryURL, null);
    }

    public WSILDocBuilder(URL registryURL, String businessKey) throws WSILException {
        this.initUDDI(registryURL, businessKey);
    }

    private void initWSDL(String root) throws WSILException, WSDLException, IOException {
        this.wsilDocument = WSILDocument.newInstance();
        this.wsilDocument.setDocumentURL(Util.formatURL(WSILProperties.WSIL_HOSTNAME, WSILProperties.WSIL_PORT, ""));
        ExtensionRegistry extensionRegistry = this.wsilDocument.getExtensionRegistry();
        WSDLExtensionBuilder wsdlExtensionBuilder = (WSDLExtensionBuilder)extensionRegistry.getBuilder("http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/");
        FileListBuilder fileListBuilder = new FileListBuilder(root, "wsdl");
        File[] filesList = fileListBuilder.getFiles();
        int i = 0;
        while (i < filesList.length) {
            try {
                WSDLDocument wsdlDocument = new WSDLDocument(filesList[i].getPath());
                String wsdlDocLocation = null;
                QName qName = null;
                javax.wsdl.Service[] serviceList = null;
                if (wsdlDocument.isServiceImplementation()) {
                    String originalPath = filesList[i].getPath();
                    int index = (originalPath = originalPath.replace('\\', '/')).indexOf(root = root.replace('\\', '/')) != -1 ? originalPath.indexOf(root) + root.length() + 1 : 0;
                    String filteredPath = originalPath.substring(index);
                    wsdlDocLocation = filteredPath.replace('\\', '/');
                    serviceList = wsdlDocument.getServices();
                    Description description = this.wsilDocument.createDescription();
                    description.setReferencedNamespace("http://schemas.xmlsoap.org/wsdl/");
                    description.setLocation(wsdlDocLocation);
                    Reference reference = (Reference)wsdlExtensionBuilder.createElement(Reference.QNAME);
                    int j = 0;
                    while (j < serviceList.length) {
                        Object[] portsArray = serviceList[j].getPorts().values().toArray();
                        QName currentQName = null;
                        int k = 0;
                        while (k < portsArray.length) {
                            qName = new QName(((Port)portsArray[k]).getBinding().getQName().getNamespaceURI(), ((Port)portsArray[k]).getBinding().getQName().getLocalPart());
                            if (currentQName == null || !currentQName.equals(qName)) {
                                currentQName = qName;
                                ImplementedBinding implementedBinding = (ImplementedBinding)wsdlExtensionBuilder.createElement(ImplementedBinding.QNAME);
                                implementedBinding.setBindingName(qName);
                                reference.setEndpointPresent(Boolean.valueOf("true"));
                                if (serviceList.length > 1) {
                                    ReferencedService referencedService = (ReferencedService)wsdlExtensionBuilder.createElement(ReferencedService.QNAME);
                                    QName refServQName = new QName(wsdlDocument.getDefinitions().getTargetNamespace(), serviceList[j].getQName().getLocalPart());
                                    referencedService.setReferencedServiceName(refServQName);
                                    reference.setReferencedService(referencedService);
                                }
                                reference.addImplementedBinding(implementedBinding);
                            }
                            ++k;
                        }
                        description.setExtensionElement(reference);
                        Service service = this.wsilDocument.createService();
                        ServiceName serviceName = this.wsilDocument.createServiceName();
                        serviceName.setText(serviceList[j].getQName().getLocalPart());
                        service.addServiceName(serviceName);
                        service.addDescription(description);
                        this.wsilDocument.getInspection().addService(service);
                        ++j;
                    }
                }
            }
            catch (WSDLException e) {
                System.err.println("WSDL Exception occurred for:\"" + filesList[i].getPath() + "\" error is: " + e.getMessage());
            }
            catch (WSILException e) {
                System.err.println("WSILExceptione occurred for:\"" + filesList[i].getPath() + "\" error is: " + e.getMessage());
            }
            ++i;
        }
    }

    private void initUDDI(URL registryURL, String businessKey) throws WSILException {
        this.wsilDocument = WSILDocument.newInstance();
        ExtensionRegistry extensionRegistry = this.wsilDocument.getExtensionRegistry();
        UDDIExtensionBuilder uddiExtensionBuilder = (UDDIExtensionBuilder)extensionRegistry.getBuilder("http://schemas.xmlsoap.org/ws/2001/10/inspection/uddi/");
        try {
            Properties p = new Properties();
            p.setProperty("org.uddi4j.TransportClassName", WSILProperties.TRANSPORT_CLASS);
            p.setProperty("org.uddi4j.inquiryURL", registryURL.toString());
            UDDIProxy up = new UDDIProxy(p);
            ServiceList serviceList = null;
            if (businessKey == null) {
                serviceList = up.find_service("", "%", null, 100);
            } else {
                BusinessDetail businessDetail = up.get_businessDetail(businessKey);
                Vector businessEntityVector = businessDetail.getBusinessEntityVector();
                BusinessEntity businessEntity = null;
                if (businessEntityVector.size() > 0) {
                    businessEntity = (BusinessEntity)businessEntityVector.firstElement();
                }
                serviceList = up.find_service("", businessEntity.getDefaultNameString(), null, 100);
            }
            BusinessService[] businessServiceArray = this.findServices(serviceList, up);
            int i = 0;
            while (i < businessServiceArray.length) {
                String serviceNameString = businessServiceArray[i].getDefaultNameString();
                String serviceKeyUUID = businessServiceArray[i].getServiceKey();
                Description description = this.wsilDocument.createDescription();
                description.setReferencedNamespace("urn:uddi-org:api");
                ServiceDescription serviceDescription = (ServiceDescription)uddiExtensionBuilder.createElement(ServiceDescription.QNAME);
                serviceDescription.setLocation(registryURL.toString());
                ServiceKey serviceKey = serviceDescription.createServiceKey();
                serviceKey.setText(serviceKeyUUID);
                serviceDescription.setServiceKey(serviceKey);
                BusinessDetail businessDetail = up.get_businessDetail(businessServiceArray[i].getBusinessKey());
                Vector businessEntityVector = businessDetail.getBusinessEntityVector();
                BusinessEntity businessEntity = null;
                if (businessEntityVector.size() > 0) {
                    businessEntity = (BusinessEntity)businessEntityVector.firstElement();
                    DiscoveryURLs discoveryURLs = businessEntity.getDiscoveryURLs();
                    Vector discoveryURLsVector = discoveryURLs.getDiscoveryURLVector();
                    int j = 0;
                    while (j < discoveryURLsVector.size()) {
                        serviceDescription.setDiscoveryURL((DiscoveryURL)discoveryURLsVector.elementAt(j));
                        ++j;
                    }
                }
                description.setExtensionElement(serviceDescription);
                Service service = this.wsilDocument.createService();
                ServiceName serviceName = this.wsilDocument.createServiceName();
                serviceName.setText(serviceNameString);
                service.addServiceName(serviceName);
                service.addDescription(description);
                this.wsilDocument.getInspection().addService(service);
                ++i;
            }
        }
        catch (Exception e) {
            throw new WSILException("Unable to create WSILDocBuilder", e);
        }
    }

    public WSILDocument getWSILDocument() {
        return this.wsilDocument;
    }

    public void addLink(String referencedNamespace, String location) {
        Link link = this.wsilDocument.createLink();
        link.setReferencedNamespace(referencedNamespace);
        link.setLocation(location);
        this.wsilDocument.getInspection().addLink(link);
    }

    public void addLink(URL registryURL) throws WSILException {
        ExtensionRegistry extensionRegistry = this.wsilDocument.getExtensionRegistry();
        UDDIExtensionBuilder uddiExtensionBuilder = (UDDIExtensionBuilder)extensionRegistry.getBuilder("http://schemas.xmlsoap.org/ws/2001/10/inspection/uddi/");
        try {
            Properties p = new Properties();
            p.setProperty("org.uddi4j.TransportClassName", WSILProperties.TRANSPORT_CLASS);
            p.setProperty("org.uddi4j.inquiryURL", registryURL.toString());
            UDDIProxy up = new UDDIProxy(p);
            BusinessList businessList = up.find_business("%", null, 100);
            BusinessEntity[] businessEntityArray = null;
            businessEntityArray = this.findBusinessEntities(businessList.getBusinessInfos(), up);
            int i = 0;
            while (i < businessEntityArray.length) {
                Link link = this.wsilDocument.createLink();
                link.setReferencedNamespace("urn:uddi-org:api");
                String businessKeyUUID = businessEntityArray[i].getBusinessKey();
                BusinessDescription businessDescription = (BusinessDescription)uddiExtensionBuilder.createElement(BusinessDescription.QNAME);
                businessDescription.setLocation(registryURL.toString());
                BusinessKey businessKey = businessDescription.createBusinessKey();
                businessKey.setText(businessKeyUUID);
                businessDescription.setBusinessKey(businessKey);
                DiscoveryURLs discoveryURLs = businessEntityArray[i].getDiscoveryURLs();
                Vector discoveryURLsVector = discoveryURLs.getDiscoveryURLVector();
                int j = 0;
                while (j < discoveryURLsVector.size()) {
                    businessDescription.setDiscoveryURL((DiscoveryURL)discoveryURLsVector.elementAt(j));
                    ++j;
                }
                link.setExtensionElement(businessDescription);
                this.wsilDocument.getInspection().addLink(link);
                ++i;
            }
        }
        catch (Exception e) {
            throw new WSILException("Unable to create WSILDocBuilder", e);
        }
    }

    public void addService(String root) throws WSILException, WSDLException, IOException {
        this.initWSDL(root);
    }

    public void addService(URL registryURL) throws WSILException {
        this.initUDDI(registryURL, null);
    }

    protected BusinessService[] findServices(ServiceList serviceList, UDDIProxy up) throws WSILException {
        Object[] businessServiceList = null;
        Vector<String> skList = new Vector<String>();
        try {
            Vector siList = serviceList.getServiceInfos().getServiceInfoVector();
            int i = 0;
            while (i < siList.size()) {
                skList.addElement(((ServiceInfo)siList.elementAt(i)).getServiceKey());
                ++i;
            }
            ServiceDetail serviceDetail = up.get_serviceDetail(skList);
            Vector bsList = serviceDetail.getBusinessServiceVector();
            if (bsList.size() > 0) {
                businessServiceList = new BusinessService[bsList.size()];
                bsList.copyInto(businessServiceList);
            }
        }
        catch (Exception e) {
            throw new WSILException("Find services exception: " + e.toString(), e);
        }
        return businessServiceList;
    }

    protected BusinessEntity[] findBusinessEntities(BusinessInfos businessInfos, UDDIProxy up) throws WSILException {
        Object[] businessEntityList = null;
        try {
            BusinessDetail businessDetail;
            Vector beList;
            Vector keyList = WSILDocBuilder.getBusinessKeyVector(businessInfos);
            if (keyList.size() > 0 && (beList = (businessDetail = up.get_businessDetail(keyList)).getBusinessEntityVector()).size() > 0) {
                businessEntityList = new BusinessEntity[beList.size()];
                beList.copyInto(businessEntityList);
            }
        }
        catch (Exception e) {
            throw new WSILException("Could not list all business entities.", e);
        }
        return businessEntityList;
    }

    public static Vector getBusinessKeyVector(BusinessInfos businessInfos) {
        Vector<String> keyList = new Vector<String>();
        Vector biList = businessInfos.getBusinessInfoVector();
        int i = 0;
        while (i < biList.size()) {
            keyList.add(((BusinessInfo)biList.elementAt(i)).getBusinessKey());
            ++i;
        }
        return keyList;
    }
}

