/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.wst.xsd.ui.internal.actions.IXSDToolbarAction;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.design.figures.IExtendedFigureFactory;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorExtensionProperties;

public class XSDEditorConfiguration {
    public static final String XSDEDITORCONFIGURATIONEXTENSIONID = "org.eclipse.wst.xsd.ui.XSDEditorExtensionConfiguration";
    public static final String INTERNALEDITORCONFIGURATION_EXTENSIONID = "org.eclipse.wst.xsd.ui.internalEditorConfiguration";
    public static final String CLASSNAME = "class";
    public static final String ADAPTERFACTORY = "adapterFactory";
    public static final String TOOLBARACTION = "toolbarAction";
    public static final String FIGUREFACTORY = "figureFactory";
    public static final String EDITPARTFACTORY = "editPartFactory";
    List definedExtensionsList = null;

    public XSDAdapterFactory getAdapterFactory() {
        if (this.definedExtensionsList == null) {
            this.readXSDConfigurationRegistry();
        }
        if (!this.definedExtensionsList.isEmpty()) {
            return ((XSDEditorExtensionProperties)this.definedExtensionsList.get(0)).getAdapterFactory();
        }
        return null;
    }

    public EditPartFactory getEditPartFactory() {
        if (this.definedExtensionsList == null) {
            this.readXSDConfigurationRegistry();
        }
        if (!this.definedExtensionsList.isEmpty()) {
            return ((XSDEditorExtensionProperties)this.definedExtensionsList.get(0)).getEditPartFactory();
        }
        return null;
    }

    public IExtendedFigureFactory getFigureFactory() {
        if (this.definedExtensionsList == null) {
            this.readXSDConfigurationRegistry();
        }
        if (!this.definedExtensionsList.isEmpty()) {
            return ((XSDEditorExtensionProperties)this.definedExtensionsList.get(0)).getFigureFactory();
        }
        return null;
    }

    public List getToolbarActions() {
        if (this.definedExtensionsList == null) {
            this.readXSDConfigurationRegistry();
        }
        if (!this.definedExtensionsList.isEmpty()) {
            return ((XSDEditorExtensionProperties)this.definedExtensionsList.get(0)).getActionList();
        }
        return Collections.EMPTY_LIST;
    }

    protected Object loadClass(IConfigurationElement element, String classString) {
        String pluginId = element.getDeclaringExtension().getContributor().getName();
        try {
            Class theClass = Platform.getBundle((String)pluginId).loadClass(classString);
            Object instance = theClass.newInstance();
            return instance;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void readXSDConfigurationRegistry() {
        this.definedExtensionsList = new ArrayList();
        this.updateList(INTERNALEDITORCONFIGURATION_EXTENSIONID);
        this.updateList(XSDEDITORCONFIGURATIONEXTENSIONID);
    }

    private void updateList(String ID) {
        boolean definedExtensionsExist;
        IConfigurationElement[] xsdEditorExtensionList = Platform.getExtensionRegistry().getConfigurationElementsFor(ID);
        boolean bl = definedExtensionsExist = xsdEditorExtensionList != null && xsdEditorExtensionList.length > 0;
        if (definedExtensionsExist) {
            int i = 0;
            while (i < xsdEditorExtensionList.length) {
                String figureFactoryClass;
                XSDEditorExtensionProperties properties = new XSDEditorExtensionProperties();
                this.definedExtensionsList.add(properties);
                IConfigurationElement element = xsdEditorExtensionList[i];
                String adapterFactoryClass = element.getAttribute(ADAPTERFACTORY);
                if (adapterFactoryClass != null) {
                    Object object = this.loadClass(element, adapterFactoryClass);
                    XSDAdapterFactory adapterFactory = null;
                    if (object instanceof XSDAdapterFactory) {
                        adapterFactory = (XSDAdapterFactory)((Object)object);
                        properties.setAdapterFactory(adapterFactory);
                    }
                }
                if ((figureFactoryClass = element.getAttribute(FIGUREFACTORY)) != null) {
                    Object object = this.loadClass(element, figureFactoryClass);
                    IExtendedFigureFactory figureFactory = null;
                    if (object instanceof IExtendedFigureFactory) {
                        figureFactory = (IExtendedFigureFactory)object;
                        properties.setFigureFactoryList(figureFactory);
                    }
                }
                IConfigurationElement[] toolbarActions = element.getChildren(TOOLBARACTION);
                ArrayList<IXSDToolbarAction> actionList = new ArrayList<IXSDToolbarAction>();
                if (toolbarActions != null) {
                    int j = 0;
                    while (j < toolbarActions.length) {
                        Object object;
                        IConfigurationElement actionElement = toolbarActions[j];
                        String actionClass = actionElement.getAttribute(CLASSNAME);
                        IXSDToolbarAction action = null;
                        if (actionClass != null && (object = this.loadClass(actionElement, actionClass)) instanceof IXSDToolbarAction) {
                            action = (IXSDToolbarAction)object;
                            actionList.add(action);
                        }
                        ++j;
                    }
                }
                properties.setActionList(actionList);
                String editPartFactoryClass = element.getAttribute(EDITPARTFACTORY);
                if (editPartFactoryClass != null) {
                    Object object = this.loadClass(element, editPartFactoryClass);
                    EditPartFactory editPartFactory = null;
                    if (object instanceof EditPartFactory) {
                        editPartFactory = (EditPartFactory)object;
                        properties.setEditPartFactoryList(editPartFactory);
                    }
                }
                ++i;
            }
        }
    }
}

