/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SimpleRegion;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SourceFile
implements StaticSourceFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UTF8_BOM = "\ufeff";
    private static final int SOURCE_EXCERPT_REGION_LENGTH = 5;
    private final String fileName;
    private boolean isExternFile = false;
    private String originalPath = null;
    private int[] lineOffsets = null;
    private String code = null;
    static final DiagnosticType DUPLICATE_ZIP_CONTENTS = DiagnosticType.warning("JSC_DUPLICATE_ZIP_CONTENTS", "Two zip entries containing the same relative path.\nEntry 1: {0}\nEntry 2: {1}");

    public SourceFile(String fileName) {
        if (Strings.isNullOrEmpty((String)fileName)) {
            throw new IllegalArgumentException("a source must have a name");
        }
        this.fileName = !"/".equals(File.separator) ? fileName.replace(File.separator, "/") : fileName;
    }

    @Override
    public int getLineOffset(int lineno) {
        this.findLineOffsets();
        if (lineno < 1 || lineno > this.lineOffsets.length) {
            throw new IllegalArgumentException("Expected line number between 1 and " + this.lineOffsets.length + "\nActual: " + lineno);
        }
        return this.lineOffsets[lineno - 1];
    }

    int getNumLines() {
        this.findLineOffsets();
        return this.lineOffsets.length;
    }

    private void findLineOffsets() {
        if (this.lineOffsets != null) {
            return;
        }
        try {
            String[] sourceLines = this.getCode().split("\n", -1);
            this.lineOffsets = new int[sourceLines.length];
            for (int ii = 1; ii < sourceLines.length; ++ii) {
                this.lineOffsets[ii] = this.lineOffsets[ii - 1] + sourceLines[ii - 1].length() + 1;
            }
        }
        catch (IOException e) {
            this.lineOffsets = new int[1];
            this.lineOffsets[0] = 0;
        }
    }

    private void resetLineOffsets() {
        this.lineOffsets = null;
    }

    public String getCode() throws IOException {
        return this.code;
    }

    @GwtIncompatible(value="com.google.common.io.CharSource")
    public CharSource getCodeCharSource() {
        return CharSource.wrap((CharSequence)this.code);
    }

    @GwtIncompatible(value="java.io.Reader")
    public Reader getCodeReader() throws IOException {
        return new StringReader(this.getCode());
    }

    @VisibleForTesting
    String getCodeNoCache() {
        return this.code;
    }

    void setCode(String sourceCode) {
        this.setCode(sourceCode, false);
    }

    void setCode(String sourceCode, boolean removeUtf8Bom) {
        this.code = removeUtf8Bom && sourceCode != null && sourceCode.startsWith(UTF8_BOM) ? sourceCode.substring(UTF8_BOM.length()) : sourceCode;
        this.resetLineOffsets();
    }

    public String getOriginalPath() {
        return this.originalPath != null ? this.originalPath : this.fileName;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public void clearCachedSource() {
    }

    boolean hasSourceInMemory() {
        return this.code != null;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public boolean isExtern() {
        return this.isExternFile;
    }

    void setIsExtern(boolean newVal) {
        this.isExternFile = newVal;
    }

    @Override
    public int getLineOfOffset(int offset) {
        this.findLineOffsets();
        int search = Arrays.binarySearch(this.lineOffsets, offset);
        if (search >= 0) {
            return search + 1;
        }
        int insertionPoint = -1 * (search + 1);
        return Math.min(insertionPoint - 1, this.lineOffsets.length - 1) + 1;
    }

    @Override
    public int getColumnOfOffset(int offset) {
        int line = this.getLineOfOffset(offset);
        return offset - this.lineOffsets[line - 1];
    }

    public String getLine(int lineNumber) {
        this.findLineOffsets();
        if (lineNumber > this.lineOffsets.length) {
            return null;
        }
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        int pos = this.lineOffsets[lineNumber - 1];
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        if (js.indexOf(10, pos) == -1) {
            if (pos >= js.length()) {
                return null;
            }
            return js.substring(pos, js.length());
        }
        return js.substring(pos, js.indexOf(10, pos));
    }

    public Region getRegion(int lineNumber) {
        int nextpos;
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = 0;
        int startLine = Math.max(1, lineNumber - 3 + 1);
        for (int n = 1; n < startLine && (nextpos = js.indexOf(10, pos)) != -1; ++n) {
            pos = nextpos + 1;
        }
        int end = pos;
        int endLine = startLine;
        int n = 0;
        while (n < 5 && (end = js.indexOf(10, end)) != -1) {
            ++end;
            ++n;
            ++endLine;
        }
        if (lineNumber >= endLine) {
            return null;
        }
        if (end == -1) {
            int last = js.length() - 1;
            if (js.charAt(last) == '\n') {
                return new SimpleRegion(startLine, endLine, js.substring(pos, last));
            }
            return new SimpleRegion(startLine, endLine, js.substring(pos));
        }
        return new SimpleRegion(startLine, endLine, js.substring(pos, end));
    }

    public String toString() {
        return this.fileName;
    }

    @GwtIncompatible(value="java.util.zip.ZipFile")
    public static List<SourceFile> fromZipFile(String zipName, Charset inputCharset) throws IOException {
        String absoluteZipPath = new File(zipName).getAbsolutePath();
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        try (ZipFile zipFile = new ZipFile(absoluteZipPath);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String entryName = zipEntry.getName();
                if (!entryName.endsWith(".js")) continue;
                URL zipEntryUrl = new URL("jar:file:" + absoluteZipPath + "!/" + entryName);
                sourceFiles.add(SourceFile.builder().withCharset(inputCharset).withOriginalPath(zipName + "!/" + zipEntry.getName()).buildFromUrl(zipEntryUrl));
            }
        }
        return sourceFiles;
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(String fileName, Charset c) {
        return SourceFile.builder().withCharset(c).buildFromFile(fileName);
    }

    public static SourceFile fromFile(String fileName) {
        return SourceFile.builder().buildFromFile(fileName);
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(File file, Charset c) {
        return SourceFile.builder().withCharset(c).buildFromFile(file);
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(File file) {
        return SourceFile.builder().buildFromFile(file);
    }

    public static SourceFile fromCode(String fileName, String code) {
        return SourceFile.builder().buildFromCode(fileName, code);
    }

    @Deprecated
    @GwtIncompatible(value="java.io.InputStream")
    public static SourceFile fromInputStream(String fileName, InputStream s) throws IOException {
        return SourceFile.builder().buildFromInputStream(fileName, s);
    }

    @GwtIncompatible(value="java.io.InputStream")
    public static SourceFile fromInputStream(String fileName, InputStream s, Charset charset) throws IOException {
        return SourceFile.builder().withCharset(charset).buildFromInputStream(fileName, s);
    }

    @GwtIncompatible(value="java.io.Reader")
    public static SourceFile fromReader(String fileName, Reader r) throws IOException {
        return SourceFile.builder().buildFromReader(fileName, r);
    }

    public static SourceFile fromGenerator(String fileName, Generator generator) {
        return SourceFile.builder().buildFromGenerator(fileName, generator);
    }

    public static Builder builder() {
        return new Builder();
    }

    @GwtIncompatible(value="java.net.URL")
    static class AtUrl
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private final URL url;
        private String inputCharset = StandardCharsets.UTF_8.name();

        AtUrl(URL url, String originalPath, Charset c) {
            super(originalPath);
            this.url = url;
            super.setOriginalPath(originalPath);
            if (c != null) {
                this.setCharset(c);
            }
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = Resources.toString((URL)this.url, (Charset)this.getCharset());
                super.setCode(cachedCode, this.getCharset() == StandardCharsets.UTF_8);
                cachedCode = super.getCode();
            }
            return cachedCode;
        }

        @Override
        public CharSource getCodeCharSource() {
            if (this.hasSourceInMemory()) {
                return super.getCodeCharSource();
            }
            return Resources.asCharSource((URL)this.url, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        public Reader getCodeReader() throws IOException {
            if (this.hasSourceInMemory()) {
                return super.getCodeReader();
            }
            return this.getCodeCharSource().openStream();
        }

        @Override
        public void clearCachedSource() {
            super.setCode(null);
        }

        public void setCharset(Charset c) {
            this.inputCharset = c.name();
        }

        public Charset getCharset() {
            return Charset.forName(this.inputCharset);
        }
    }

    public static class Builder {
        private Charset charset = StandardCharsets.UTF_8;
        private String originalPath = null;

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withOriginalPath(String originalPath) {
            this.originalPath = originalPath;
            return this;
        }

        public SourceFile buildFromFile(String fileName) {
            return this.buildFromFile(new File(fileName));
        }

        public SourceFile buildFromFile(File file) {
            return new OnDisk(file, this.originalPath, this.charset);
        }

        @GwtIncompatible(value="java.net.URL")
        public SourceFile buildFromUrl(URL url) {
            return new AtUrl(url, this.originalPath, this.charset);
        }

        public SourceFile buildFromCode(String fileName, String code) {
            return new Preloaded(fileName, this.originalPath, code);
        }

        @GwtIncompatible(value="java.io.InputStream")
        public SourceFile buildFromInputStream(String fileName, InputStream s) throws IOException {
            return this.buildFromCode(fileName, CharStreams.toString((Readable)new InputStreamReader(s, this.charset)));
        }

        @GwtIncompatible(value="java.io.Reader")
        public SourceFile buildFromReader(String fileName, Reader r) throws IOException {
            return this.buildFromCode(fileName, CharStreams.toString((Readable)r));
        }

        public SourceFile buildFromGenerator(String fileName, Generator generator) {
            return new Generated(fileName, this.originalPath, generator);
        }
    }

    static class Generated
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private final Generator generator;

        Generated(String fileName, String originalPath, Generator generator) {
            super(fileName);
            super.setOriginalPath(originalPath);
            this.generator = generator;
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = this.generator.getCode();
                super.setCode(cachedCode);
            }
            return cachedCode;
        }

        @Override
        public void clearCachedSource() {
            super.setCode(null);
        }
    }

    public static interface Generator {
        public String getCode();
    }

    static class OnDisk
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private final File file;
        private String inputCharset = StandardCharsets.UTF_8.name();

        OnDisk(File file, String originalPath, Charset c) {
            super(file.getPath());
            this.file = file;
            super.setOriginalPath(originalPath);
            if (c != null) {
                this.setCharset(c);
            }
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = Files.toString((File)this.file, (Charset)this.getCharset());
                super.setCode(cachedCode, this.getCharset() == StandardCharsets.UTF_8);
                cachedCode = super.getCode();
            }
            return cachedCode;
        }

        @Override
        @GwtIncompatible(value="Files.asCharSource()")
        public CharSource getCodeCharSource() {
            if (this.hasSourceInMemory()) {
                return super.getCodeCharSource();
            }
            return Files.asCharSource((File)this.file, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        @GwtIncompatible(value="java.io.Reader")
        public Reader getCodeReader() throws IOException {
            if (this.hasSourceInMemory()) {
                return super.getCodeReader();
            }
            return Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        public void clearCachedSource() {
            super.setCode(null);
        }

        public void setCharset(Charset c) {
            this.inputCharset = c.name();
        }

        public Charset getCharset() {
            return Charset.forName(this.inputCharset);
        }
    }

    static class Preloaded
    extends SourceFile {
        private static final long serialVersionUID = 1L;

        Preloaded(String fileName, String originalPath, String code) {
            super(fileName);
            super.setOriginalPath(originalPath);
            super.setCode(code);
        }
    }
}

