/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.cleanup;

import java.io.IOException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupProcessorImpl;
import org.eclipse.wst.html.core.tests.ProjectUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class TestHTMLCleanupProcessor
extends TestCase {
    private static final String PROJECT_NAME = "TestHTMLCleanupProcessor";
    private static final String PROJECT_FILES = "/testresources/HTMLCleanupProcessor";
    private static IProject fProject;

    public TestHTMLCleanupProcessor() {
        super("Test HTML Cleanup Processor");
    }

    public TestHTMLCleanupProcessor(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(TestHTMLCleanupProcessor.class);
        return new TestHTMLCleanupProcessorSetup((Test)ts);
    }

    public void testCollapseEmptyTagsHTML() throws Exception {
        HTMLCleanupProcessorImpl cleanupProcessor = TestHTMLCleanupProcessor.getProcessorForForEmptyTagsTest();
        this.runTest("test1.html", "test1-expected.html", (AbstractStructuredCleanupProcessor)cleanupProcessor);
    }

    public void testCollapseEmptyTagsXHTML() throws Exception {
        HTMLCleanupProcessorImpl cleanupProcessor = TestHTMLCleanupProcessor.getProcessorForForEmptyTagsTest();
        this.runTest("test2.html", "test2-expected.html", (AbstractStructuredCleanupProcessor)cleanupProcessor);
    }

    private static HTMLCleanupProcessorImpl getProcessorForForEmptyTagsTest() {
        HTMLCleanupProcessorImpl cleanupProcessor = new HTMLCleanupProcessorImpl();
        cleanupProcessor.getCleanupPreferences().setCompressEmptyElementTags(true);
        cleanupProcessor.getCleanupPreferences().setInsertRequiredAttrs(false);
        cleanupProcessor.getCleanupPreferences().setInsertMissingTags(true);
        cleanupProcessor.getCleanupPreferences().setQuoteAttrValues(false);
        cleanupProcessor.getCleanupPreferences().setFormatSource(false);
        cleanupProcessor.getCleanupPreferences().setConvertEOLCodes(false);
        return cleanupProcessor;
    }

    private void runTest(String originalFile, String expectedResultsFile, AbstractStructuredCleanupProcessor configuredCleanupProcessor) throws Exception {
        IStructuredModel model = null;
        IStructuredModel expectedModel = null;
        try {
            model = this.getModelForEdit(originalFile);
            expectedModel = this.getModelForEdit(expectedResultsFile);
            configuredCleanupProcessor.refreshCleanupPreferences = false;
            configuredCleanupProcessor.cleanupModel(model);
            configuredCleanupProcessor.refreshCleanupPreferences = true;
            model.save();
            this.standardizeLineEndings((IDocument)model.getStructuredDocument());
            this.standardizeLineEndings((IDocument)expectedModel.getStructuredDocument());
            TestHTMLCleanupProcessor.assertEquals((String)"Clean up results did not match expected results", (String)expectedModel.getStructuredDocument().get(), (String)model.getStructuredDocument().get());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
            if (expectedModel != null) {
                expectedModel.releaseFromEdit();
            }
        }
    }

    private IStructuredModel getModelForEdit(String filename) throws IOException, CoreException {
        IFile file = fProject.getFile(filename);
        TestHTMLCleanupProcessor.assertTrue((String)("Test file " + String.valueOf(file) + " can not be found"), (boolean)file.exists());
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
        TestHTMLCleanupProcessor.assertNotNull((String)("Could not get model for " + String.valueOf(file)), (Object)model);
        return model;
    }

    private void standardizeLineEndings(IDocument doc) {
        String contents = doc.get();
        contents = StringUtils.replace((String)contents, (String)"\r\n", (String)"\n");
        contents = StringUtils.replace((String)contents, (String)"\r", (String)"\n");
        doc.set(contents);
    }

    private static class TestHTMLCleanupProcessorSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public TestHTMLCleanupProcessorSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            fProject = ProjectUtil.createProject(TestHTMLCleanupProcessor.PROJECT_NAME, null, null);
            ProjectUtil.copyBundleEntriesIntoWorkspace(TestHTMLCleanupProcessor.PROJECT_FILES, TestHTMLCleanupProcessor.PROJECT_NAME);
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

