/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views.model.jsp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.TLDRegistryManager;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.BaseTestClass;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.VerifyRegistryUtil;

public class TestTLDTagRegistry
extends BaseTestClass {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetRegistry() throws TagRegistryFactory.TagRegistryFactoryException {
        ITagRegistry registry = new TLDRegistryManager.MyRegistryFactory().createTagRegistry(this._webProjectTestEnv.getTestProject());
        TestTLDTagRegistry.assertNotNull((Object)registry);
    }

    public void testGetAllTagLibraries() throws TagRegistryFactory.TagRegistryFactoryException {
        ITagRegistry registry = new TLDRegistryManager.MyRegistryFactory().createTagRegistry(this._webProjectTestEnv.getTestProject());
        TestTLDTagRegistry.assertNotNull((Object)registry);
        Collection libraries = registry.getAllTagLibraries();
        HashMap<String, HashMap<String, ITagElement>> elements = new HashMap<String, HashMap<String, ITagElement>>();
        for (Namespace ns : libraries) {
            for (ITagElement tagElement : ns.getViewElements()) {
                TestTLDTagRegistry.assertNotNull((String)("Tag element shouldn't be null: " + ns.getNSUri()), (Object)tagElement);
                HashMap<String, ITagElement> elementMap = (HashMap<String, ITagElement>)elements.get(ns.getNSUri());
                if (elementMap == null) {
                    elementMap = new HashMap<String, ITagElement>();
                    elements.put(ns.getNSUri(), elementMap);
                }
                elementMap.put(tagElement.getName(), tagElement);
            }
        }
        TestTLDTagRegistry.assertTrue((boolean)elements.containsKey("http://java.sun.com/jsf/core"));
        TestTLDTagRegistry.assertTrue((boolean)elements.containsKey("http://java.sun.com/jsf/html"));
        this.verifyCore((Map)elements.get("http://java.sun.com/jsf/core"));
        this.verifyHtml((Map)elements.get("http://java.sun.com/jsf/html"));
    }

    private void verifyCore(Map<String, ITagElement> tagElements) {
        VerifyRegistryUtil.CompositeVerifier compVerifier = null;
        switch (this._jsfVersion) {
            case V1_0: 
            case V1_1: {
                compVerifier = new VerifyRegistryUtil.CompositeVerifier(VerifyRegistryUtil.CORE_VERIFIERS_11, 18, 18);
                break;
            }
            case V1_2: {
                compVerifier = new VerifyRegistryUtil.CompositeVerifier(VerifyRegistryUtil.CORE_VERIFIERS_12, 20, 20);
            }
        }
        TestTLDTagRegistry.assertNotNull(compVerifier);
        compVerifier.verify(tagElements);
    }

    private void verifyHtml(Map<String, ITagElement> tagElements) {
        VerifyRegistryUtil.CompositeVerifier compVerifier = new VerifyRegistryUtil.CompositeVerifier(VerifyRegistryUtil.HTML_VERIFIERS, 25, 25);
        compVerifier.verify(tagElements);
    }
}

