/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodel.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMDescriptor;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMProperty;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMMTypeCollector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.w3c.dom.css.CSSFontFaceRule;

public class CSSMetaModelUtil {
    private CSSMetaModel fMetaModel = null;
    private Map fTypeMap = null;

    public CSSMetaModelUtil(CSSMetaModel metamodel) {
        this.fMetaModel = metamodel;
    }

    public Iterator getProperties() {
        return this.collectNodesByType("CSSMM.Property");
    }

    public Iterator getDescriptors() {
        return this.collectNodesByType("CSSMM.Descriptor");
    }

    public Iterator collectNodesByType(String type) {
        CSSMMTypeCollector collector = new CSSMMTypeCollector();
        collector.apply(this.fMetaModel, type);
        return collector.getNodes();
    }

    public CSSMMProperty getProperty(String propertyName) {
        Iterator iProperty = this.getProperties();
        while (iProperty.hasNext()) {
            CSSMMNode node = (CSSMMNode)iProperty.next();
            if (!node.getName().equalsIgnoreCase(propertyName)) continue;
            return (CSSMMProperty)node;
        }
        return null;
    }

    public CSSMMDescriptor getDescriptor(String descriptorName) {
        Iterator iDescriptor = this.getDescriptors();
        while (iDescriptor.hasNext()) {
            CSSMMNode node = (CSSMMNode)iDescriptor.next();
            if (!node.getName().equalsIgnoreCase(descriptorName)) continue;
            return (CSSMMDescriptor)node;
        }
        return null;
    }

    public CSSMMNode getMetaModelNodeFor(ICSSNode node) {
        String nodeType;
        if (node instanceof ICSSStyleDeclaration) {
            node = node.getParentNode();
        }
        if (node instanceof ICSSStyleDeclItem) {
            ICSSNode parent = node.getParentNode();
            if (parent != null) {
                parent = parent.getParentNode();
            }
            if (parent instanceof ICSSStyleRule) {
                return this.getProperty(((ICSSStyleDeclItem)node).getPropertyName());
            }
            if (parent instanceof CSSFontFaceRule) {
                return this.getDescriptor(((ICSSStyleDeclItem)node).getPropertyName());
            }
        }
        if (node == null) {
            return null;
        }
        if (this.fTypeMap == null) {
            this.fTypeMap = new HashMap();
            this.fTypeMap.put(new Short(1), "CSSMM.StyleRule");
            this.fTypeMap.put(new Short(5), "CSSMM.FontFaceRule");
            this.fTypeMap.put(new Short(6), "CSSMM.PageRule");
        }
        if ((nodeType = (String)this.fTypeMap.get(new Short(node.getNodeType()))) == null) {
            return null;
        }
        Iterator iNodes = this.collectNodesByType(nodeType);
        if (iNodes.hasNext()) {
            CSSMMNode targetNode = (CSSMMNode)iNodes.next();
            if (!iNodes.hasNext()) {
                return targetNode;
            }
        }
        return null;
    }

    public CSSMetaModel getMetaModel() {
        return this.fMetaModel;
    }
}

