/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

class NodeIterators {
    private NodeIterators() {
    }

    static class FunctionlessLocalScope
    implements Iterator<Node> {
        private final Stack<Node> ancestors = new Stack();

        FunctionlessLocalScope(Node ... ancestors) {
            Preconditions.checkArgument((ancestors.length > 0 ? 1 : 0) != 0);
            for (Node n : ancestors) {
                if (n.isFunction()) break;
                this.ancestors.add(0, n);
            }
        }

        @Override
        public boolean hasNext() {
            return this.ancestors.size() != 1 || this.ancestors.peek().getNext() != null;
        }

        @Override
        public Node next() {
            Node current = this.ancestors.pop();
            if (current.getNext() == null) {
                current = this.ancestors.peek();
                if (current.isFunction()) {
                    return this.next();
                }
            } else {
                current = current.getNext();
                this.ancestors.push(current);
                if (current.isFunction()) {
                    return this.next();
                }
                while (current.hasChildren()) {
                    current = current.getFirstChild();
                    this.ancestors.push(current);
                    if (!current.isFunction()) continue;
                    return this.next();
                }
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        protected Node current() {
            return this.ancestors.peek();
        }

        protected Node currentParent() {
            return this.ancestors.size() >= 2 ? (Node)this.ancestors.get(this.ancestors.size() - 2) : null;
        }

        List<Node> currentAncestors() {
            ArrayList<Node> list = new ArrayList<Node>(this.ancestors);
            Collections.reverse(list);
            return list;
        }
    }

    static class LocalVarMotion
    implements Iterator<Node> {
        private final boolean valueHasSideEffects;
        private final FunctionlessLocalScope iterator;
        private final String varName;
        private Node lookAhead;

        static LocalVarMotion forVar(Node name, Node var, Node block) {
            Preconditions.checkArgument((boolean)var.isVar());
            Preconditions.checkArgument((boolean)NodeUtil.isStatement(var));
            return new LocalVarMotion(name, new FunctionlessLocalScope(name, var, block));
        }

        static LocalVarMotion forAssign(Node name, Node assign, Node expr, Node block) {
            Preconditions.checkArgument((boolean)assign.isAssign());
            Preconditions.checkArgument((boolean)expr.isExprResult());
            return new LocalVarMotion(name, new FunctionlessLocalScope(assign, expr, block));
        }

        private LocalVarMotion(Node nameNode, FunctionlessLocalScope iterator) {
            Preconditions.checkArgument((boolean)nameNode.isName());
            Node valueNode = NodeUtil.getAssignedValue(nameNode);
            this.varName = nameNode.getString();
            this.valueHasSideEffects = valueNode != null && NodeUtil.mayHaveSideEffects(valueNode);
            this.iterator = iterator;
            this.advanceLookAhead(true);
        }

        @Override
        public boolean hasNext() {
            return this.lookAhead != null;
        }

        @Override
        public Node next() {
            Node next = this.lookAhead;
            this.advanceLookAhead(false);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        private void advanceLookAhead(boolean atStart) {
            if (!atStart) {
                if (this.lookAhead == null) {
                    return;
                }
                Node curNode = this.iterator.current();
                if (curNode.isName() && this.varName.equals(curNode.getString())) {
                    this.lookAhead = null;
                    return;
                }
            }
            if (!this.iterator.hasNext()) {
                this.lookAhead = null;
                return;
            }
            Node nextNode = this.iterator.next();
            Node nextParent = this.iterator.currentParent();
            int type = nextNode.getType();
            if (this.valueHasSideEffects) {
                boolean readsState = false;
                if (nextNode.isName() && !this.varName.equals(nextNode.getString()) || nextNode.isGetProp() || nextNode.isGetElem()) {
                    if (nextParent == null || !NodeUtil.isVarOrSimpleAssignLhs(nextNode, nextParent)) {
                        readsState = true;
                    }
                } else if (nextNode.isCall() || nextNode.isNew()) {
                    readsState = true;
                }
                if (readsState) {
                    this.lookAhead = null;
                    return;
                }
            }
            if (NodeUtil.nodeTypeMayHaveSideEffects(nextNode) && type != 38 || type == 38 && nextParent.isCatch()) {
                this.lookAhead = null;
                return;
            }
            this.lookAhead = nextNode;
        }
    }
}

