/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.internal;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.pagedesigner.dtmanager.DTManager;
import org.eclipse.jst.pagedesigner.dtmanager.IDTInfo;
import org.eclipse.jst.pagedesigner.dtmanager.converter.IOutputRenderer;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITagConverterContext;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformer;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.DefaultTransformer;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.eclipse.jst.pagedesigner.dtmanager.dtinfo.Operation;
import org.eclipse.jst.pagedesigner.dtmanager.dtinfo.Parameter;
import org.eclipse.jst.pagedesigner.dtmanager.dtinfo.TagConvertInfo;
import org.w3c.dom.Element;

public class DTHTMLOutputRenderer
implements IOutputRenderer {
    private ITagConverterContext tagConverterContext;

    @Override
    public Element render(ITagConverterContext newTagConverterContext) {
        ITransformer transformer;
        this.tagConverterContext = newTagConverterContext;
        Element srcElement = newTagConverterContext.getHostElement();
        Element resultElement = null;
        if (srcElement != null && (transformer = this.createTransformerFromDTInfo(srcElement)) != null) {
            resultElement = transformer.transform(srcElement);
        }
        return resultElement;
    }

    protected ITransformer createTransformerFromDTInfo(Element element) {
        EList operations;
        TagConvertInfo tcInfo;
        DefaultTransformer transformer = null;
        DTManager dtManager = DTManager.getInstance();
        IDTInfo dtInfo = dtManager.getDTInfo(element);
        if (dtInfo != null && (tcInfo = dtInfo.getTagConvertInfo()) != null && !this.appendOperationsToTransformer(transformer = new DefaultTransformer(this.tagConverterContext), operations = tcInfo.getOperations(), dtInfo)) {
            transformer = null;
        }
        return transformer;
    }

    private boolean appendOperationsToTransformer(ITransformer transformer, EList operations, IDTInfo dtInfo) {
        for (Operation operation : operations) {
            ITransformOperation currentTransformOperation = null;
            String opID = operation.getId();
            String[] params = this.getParamsArray(operation);
            currentTransformOperation = TransformOperationFactory.getInstance().getTransformOperation(opID, params);
            if (currentTransformOperation != null) {
                transformer.appendTransformOperation(currentTransformOperation);
                EList childOperations = operation.getOperations();
                if (childOperations == null || childOperations.size() <= 0 || this.appendChildOperations(currentTransformOperation, childOperations, dtInfo)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean appendChildOperations(ITransformOperation parentOperation, EList operations, IDTInfo dtInfo) {
        for (Operation operation : operations) {
            ITransformOperation currentTransformOperation = null;
            String opID = operation.getId();
            String[] params = this.getParamsArray(operation);
            currentTransformOperation = TransformOperationFactory.getInstance().getTransformOperation(opID, params);
            if (currentTransformOperation != null) {
                parentOperation.appendChildOperation(currentTransformOperation);
                EList childOperations = operation.getOperations();
                if (childOperations == null || childOperations.size() <= 0 || this.appendChildOperations(currentTransformOperation, childOperations, dtInfo)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private String[] getParamsArray(Operation operation) {
        EList paramsList = operation.getParameters();
        if (paramsList != null) {
            Iterator itParamsList = paramsList.iterator();
            String[] paramsArray = new String[paramsList.size()];
            int index = 0;
            while (itParamsList.hasNext()) {
                Parameter param = (Parameter)itParamsList.next();
                paramsArray[index++] = param.getValue();
            }
            return paramsArray;
        }
        return new String[0];
    }
}

