/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.debug.core.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.ToggleBreakpointAction;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.wst.debug.core.tests.AbstractDebugTest;
import org.eclipse.wst.debug.core.tests.VerticalRulerInfoStub;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;

public abstract class AbstractBreakpointTest
extends AbstractDebugTest {
    protected static final String BP_PROJECT = "BpProject";
    private ArrayList breakpoints = new ArrayList();

    public AbstractBreakpointTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        try {
            if (this.breakpoints.size() > 0) {
                this.getBreakpointManager().removeBreakpoints(this.breakpoints.toArray(new IBreakpoint[this.breakpoints.size()]), true);
                this.breakpoints.clear();
            }
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.assertTestProject(BP_PROJECT);
    }

    protected IJavaScriptLineBreakpoint createLineBreakpoint(String scriptpath, int line, String condition) throws Exception {
        AbstractBreakpointTest.assertNotNull((String)"script path cannot be null creating a line breakpoint", (Object)scriptpath);
        AbstractBreakpointTest.assertTrue((String)"the line number must be greater than -1 to create a line breakpoint", (line > -1 ? 1 : 0) != 0);
        IResource res = this.getBreakpointResource(scriptpath);
        AbstractBreakpointTest.assertNotNull((String)("failed creating line breakpoint: the breakpoint resource could not be found for [" + scriptpath + "]"), (Object)res);
        IJavaScriptUnit element = (IJavaScriptUnit)JavaScriptCore.create((IResource)res);
        AbstractBreakpointTest.assertNotNull((String)("failed creating line breakpoint: the javascript element could not be computed for [" + scriptpath + "]"), (Object)element);
        Document doc = new Document(element.getSource());
        IRegion region = doc.getLineInformation(line);
        HashMap attr = new HashMap();
        int offset = region.getOffset();
        IJavaScriptLineBreakpoint bp = JavaScriptDebugModel.createLineBreakpoint((IResource)res, (int)line, (int)offset, (int)(offset + region.getLength()), attr, (boolean)true);
        bp.setCondition(condition);
        this.breakpoints.add(bp);
        this.forceDeltas(res.getProject());
        return bp;
    }

    protected List createLineBreakpoints(String path, int[] lines) throws Exception {
        ArrayList<IJavaScriptLineBreakpoint> bps = new ArrayList<IJavaScriptLineBreakpoint>(lines.length);
        int i = 0;
        while (i < lines.length) {
            IJavaScriptLineBreakpoint bp = this.createLineBreakpoint(path, lines[i], null);
            bps.add(bp);
            this.breakpoints.add(bp);
            ++i;
        }
        return bps;
    }

    protected IJavaScriptFunctionBreakpoint createFunctionBreakpoint(String scriptpath, String fname, String sig, String condition, boolean entry, boolean exit) throws Exception {
        AbstractBreakpointTest.assertNotNull((String)"script path cannot be null creating a function breakpoint", (Object)scriptpath);
        AbstractBreakpointTest.assertNotNull((String)"function name cannot be null creating a function breakpoint", (Object)fname);
        AbstractBreakpointTest.assertNotNull((String)"function signature cannot be null creating a function breakpoint", (Object)sig);
        IResource res = this.getBreakpointResource(scriptpath);
        AbstractBreakpointTest.assertNotNull((String)("failed creating function breakpoint: the breakpoint resource could not be found for [" + scriptpath + "]"), (Object)res);
        IJavaScriptElement element = JavaScriptCore.create((IResource)res);
        AbstractBreakpointTest.assertNotNull((String)("failed creating line breakpoint: the javascript element could not be computed for [" + scriptpath + "]"), (Object)element);
        HashMap attr = new HashMap();
        IJavaScriptFunctionBreakpoint bp = JavaScriptDebugModel.createFunctionBreakpoint((IResource)res, (String)fname, (String)sig, (int)-1, (int)-1, attr, (boolean)false);
        bp.setEntry(entry);
        bp.setExit(exit);
        bp.setCondition(condition);
        this.breakpoints.add(bp);
        this.forceDeltas(res.getProject());
        return bp;
    }

    protected IJavaScriptLoadBreakpoint createScriptloadBreakpoint(String scriptpath) throws Exception {
        AbstractBreakpointTest.assertNotNull((String)"script path cannot be null creating a script load breakpoint", (Object)scriptpath);
        IResource res = this.getBreakpointResource(scriptpath);
        AbstractBreakpointTest.assertNotNull((String)("failed creating script load breakpoint: the breakpoint resource could not be found for [" + scriptpath + "]"), (Object)res);
        IJavaScriptElement element = JavaScriptCore.create((IResource)res);
        AbstractBreakpointTest.assertNotNull((String)("failed creating line breakpoint: the javascript element could not be computed for [" + scriptpath + "]"), (Object)element);
        HashMap attr = new HashMap();
        IJavaScriptLoadBreakpoint bp = JavaScriptDebugModel.createScriptLoadBreakpoint((IResource)res, (int)-1, (int)-1, attr, (boolean)false);
        this.breakpoints.add(bp);
        this.forceDeltas(res.getProject());
        return bp;
    }

    protected IResource getBreakpointResource(String scriptpath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(scriptpath));
    }

    protected void removeAllBreakpoints() throws Exception {
        IBreakpoint[] bps = this.getBreakpointManager().getBreakpoints();
        if (bps.length > 0) {
            this.getBreakpointManager().removeBreakpoints(bps, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IBreakpoint toggleBreakpoint(final IEditorPart editor, int lineNumber) throws InterruptedException {
        final VerticalRulerInfoStub info = new VerticalRulerInfoStub(lineNumber - 1);
        WorkbenchJob job = new WorkbenchJob("toggle javascript breakpoint"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ToggleBreakpointAction action = new ToggleBreakpointAction((IWorkbenchPart)editor, null, info);
                action.run();
                return Status.OK_STATUS;
            }
        };
        final Object lock = new Object();
        final IBreakpoint[] bps = new IBreakpoint[1];
        IBreakpointListener listener = new IBreakpointListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }

            public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void breakpointAdded(IBreakpoint breakpoint) {
                Object object = lock;
                synchronized (object) {
                    bps[0] = breakpoint;
                    lock.notifyAll();
                }
            }
        };
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.addBreakpointListener(listener);
        Object object = lock;
        synchronized (object) {
            job.setPriority(10);
            job.schedule();
            lock.wait(10000L);
        }
        manager.removeBreakpointListener(listener);
        if (bps[0] != null) {
            this.breakpoints.add(bps[0]);
        }
        return bps[0];
    }
}

