/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.tests.translation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapterFactory;
import org.eclipse.wst.jsdt.web.core.tests.Activator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TestHtmlTranslation
extends TestCase {
    private IModelManager fModelManager = StructuredModelManager.getModelManager();
    private static final String testFilesDirectory = "testFiles";

    public void testHTMLFormat() {
        IStructuredModel structuredModel = this.getModel("test1.html");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        structuredModel.getStructuredDocument().get();
        String expectedFileName = "test1.html";
        this.getFile(expectedFileName);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        TestHtmlTranslation.assertTrue((String)"expected function definition is missing", (translation.getJsText().indexOf("function blah()") >= 0 ? 1 : 0) != 0);
        structuredModel.releaseFromRead();
    }

    private String readFile(String fileName) {
        String inputString = null;
        InputStream fileInputStream = null;
        try {
            URL url = Activator.getDefault().getBundle().getEntry(fileName);
            fileInputStream = url.openStream();
            byte[] inputBuffer = new byte[1024];
            inputString = new String();
            int bytesRead = -1;
            while ((bytesRead = fileInputStream.read(inputBuffer)) != -1) {
                String bufferString = new String(inputBuffer);
                bufferString = bufferString.substring(0, bytesRead);
                inputString = inputString.concat(bufferString);
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException exception) {
            StringWriter s = new StringWriter();
            exception.printStackTrace(new PrintWriter(s));
            TestHtmlTranslation.fail((String)s.toString());
        }
        return inputString;
    }

    private static void printException(Exception exception) {
        exception.printStackTrace();
    }

    private IStructuredModel getModel(String fileName) {
        IStructuredModel structuredModel;
        block11: {
            structuredModel = null;
            InputStream inputStream = null;
            try {
                try {
                    String input = this.getFile(fileName);
                    inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
                    String id = inputStream.toString().concat(fileName);
                    structuredModel = this.fModelManager.getModelForRead(id, inputStream, null);
                }
                catch (Exception exception) {
                    StringWriter s = new StringWriter();
                    exception.printStackTrace(new PrintWriter(s));
                    TestHtmlTranslation.fail((String)s.toString());
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return structuredModel;
    }

    private IStructuredModel getSharedModel(String id, String contents) {
        IStructuredModel structuredModel;
        block11: {
            structuredModel = null;
            InputStream inputStream = null;
            try {
                try {
                    inputStream = new ByteArrayInputStream(contents.getBytes("UTF8"));
                    structuredModel = this.fModelManager.getModelForRead(id, inputStream, null);
                }
                catch (Exception exception) {
                    StringWriter s = new StringWriter();
                    exception.printStackTrace(new PrintWriter(s));
                    TestHtmlTranslation.fail((String)s.toString());
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return structuredModel;
    }

    private String getFile(String fileName) {
        return this.readFile("/testFiles/".concat(fileName));
    }

    public void testMangleTagInJS() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var a = <custom:tag/>5; if(a < 4) {} ; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"tag included", (translated.indexOf("<custom") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"tag included", (translated.indexOf("/>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleServerSideAndClientTagInJS() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var a = <custom:tag/>5;\nif(a < <%= 4 %>) {} ; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("tag included\n" + translated), (translated.indexOf("custom") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("tag included\n" + translated), (translated.indexOf("/>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("var dropped\n" + translated), (translated.indexOf("var a = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("if dropped\n" + translated), (translated.indexOf("5;\nif(a <") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("block dropped\n" + translated), (translated.indexOf(") {} ; ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleTagAndServerSideInJS() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var a = <%= 4 %>5;\nif(a < <custom:tag/>) {} ; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("tag included\n" + translated), (translated.indexOf("custom") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("tag included\n" + translated), (translated.indexOf("/>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("var dropped\n" + translated), (translated.indexOf("var a = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("if dropped\n" + translated), (translated.indexOf("5;\nif(a < ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("block dropped\n" + translated), (translated.indexOf(") {} ; ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleServerSide1InJSCheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <%= javaObject.getText() %>; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleServerSide2InJSCheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>; </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleServerSide1InJSCheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <%= javaObject.getText() %>;  <%= javaObject.getText() %></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleServerSide2InJSCheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>;  <? serverObject.getText() ?></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideInJS_and_CheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated contents not as expected", (String)"         var text = _$tag_______________________; _$tag___ _$tag___ _$tag________________________$tag___ ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideInJSwithXMLcomment_and_CheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> <!-- \nvar text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated contents not as expected", (String)"              \nvar text = _$tag_______________________; _$tag___ _$tag___ _$tag________________________$tag___ ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var declaration not found ", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"Problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideInJSwithXMLcommentOnSameLine() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> <!-- var text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"script with leading comment but no new line should be blank", (String)"                                                                                                              ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideAndClientTagInJS_and_CheckProblems() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <server:tag/> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated contents not as expected", (String)"         var text = _$tag_______________________; _$tag___ _$tag___ _$tag________ _$tag________________________$tag___ ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testMangleMultipleMixedServerSideAndClientTagInJS_and_CheckProblems2() {
        String fileName = String.valueOf(this.getName()) + ".jsp";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <? serverObject.getText() ?>; <%=\"a\"%> <%=\"b\"%> <server:tag/> <? serverObject.getText() ?><%=\"c\"%> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated contents not as expected", (String)"         var text = _$tag_______________________; _$tag___ _$tag___ _$tag________ _$tag________________________$tag___ ", (String)translated);
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"server-side script block included", (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"var dropped", (translated.indexOf("var text = ") > -1 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testJustClientTagInJS() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script><custom:tag /></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation too short", (translated.length() > 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("/>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("content not included\n" + translated), (translated.length() != 0 ? 1 : 0) != 0);
        structuredModel.releaseFromRead();
    }

    public void testJustServer1SideInJS() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script><%= %></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<%") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("%>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("content not included\n" + translated), (translated.length() != 0 ? 1 : 0) != 0);
        structuredModel.releaseFromRead();
    }

    public void testJustServer2SideInJS() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script><? !!!!!!!!!!!!!! ?></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("<?") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("server-side script block included\n" + translated), (translated.indexOf("?>") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)("content not included\n" + translated), (translated.length() != 0 ? 1 : 0) != 0);
        structuredModel.releaseFromRead();
    }

    public void testLeadingXMLComment() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "0<script> <!--12</script>3");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"script with leading comment but no new line should be empty", (String)"                ", (String)translated);
        structuredModel.releaseFromRead();
    }

    public void testXMLComment() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> if(a) <!-- --> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated content differs", (String)"         if(a) _$ta _$t ", (String)translated);
        structuredModel.releaseFromRead();
    }

    public void testCDATAInJS() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> var text = <![CDATA[ serverObject.getText() ;\n//]]> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("CDATA") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("[") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA end found", (translated.indexOf("]") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testEmptyEventHandlerValueCausesStringIndexOutOfBounds() throws Exception {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<html><body><span onclick=\"\"></body></html>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        try {
            try {
                JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
                IJsTranslation translation = translationAdapter.getJsTranslation(false);
                translation.getJsText();
            }
            catch (StringIndexOutOfBoundsException e) {
                TestHtmlTranslation.fail((String)e.getMessage());
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }

    public void testFunctionReturnInEventHandler() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<div                                     onClick=\"return myMethod();\">");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"translated content differs", (String)"                                      (function(){return myMethod();;})();", (String)translated);
        StringBuffer problems = new StringBuffer();
        translation.reconcileCompilationUnit();
        List problemList = translation.getProblems();
        int i = 0;
        while (i < problemList.size()) {
            problems.append(((IProblem)problemList.get(i)).getMessage());
            problems.append('\n');
            ++i;
        }
        TestHtmlTranslation.assertEquals((String)"problems were found", (String)"", (String)problems.toString());
        structuredModel.releaseFromRead();
    }

    public void testTwoFunctionReturnsInEventHandlers() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<div                                     onClick=\"return myMethod();\"  onblur=\"return myMethod2();\">\n<script >\ndojo.xhr(\"x\"); \n</script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"dojo.xhr() invocation moved but not properly mapped", (int)structuredModel.getStructuredDocument().get().indexOf("dojo.xhr(\"x\");"), (int)((JsTranslation)translation).getWebPageOffset(translated.indexOf("dojo.xhr(\"x\");")));
        TestHtmlTranslation.assertEquals((String)"translated content differs", (String)"                                      (function(){return myMethod();;})();(function(){return myMethod2();;})(); \n         \ndojo.xhr(\"x\"); \n", (String)translated);
        StringBuffer problems = new StringBuffer();
        translation.reconcileCompilationUnit();
        List problemList = translation.getProblems();
        int i = 0;
        while (i < problemList.size()) {
            problems.append(((IProblem)problemList.get(i)).getMessage());
            problems.append('\n');
            ++i;
        }
        TestHtmlTranslation.assertEquals((String)"problems were found", (String)"", (String)problems.toString());
        TestHtmlTranslation.assertEquals((String)"offsets didn't match", (int)structuredModel.getStructuredDocument().get().indexOf("dojo. \n"), (int)translated.indexOf("dojo. \n"));
        structuredModel.releaseFromRead();
    }

    public void testScriptLocationsWereRecorded() {
        String fileName = String.valueOf(this.getName()) + ".html";
        String dojoCall = "\ndojo.xhr(\"x\"); \n";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<div                                   onClick=\"return myMethod();\"  onblur=\"return myMethod2();\">\n<script >" + dojoCall + "</script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertEquals((String)"dojo.xhr() invocation moved but not properly mapped", (int)structuredModel.getStructuredDocument().get().indexOf("dojo.xhr(\"x\");"), (int)((JsTranslation)translation).getWebPageOffset(translated.indexOf("dojo.xhr(\"x\");")));
        TestHtmlTranslation.assertEquals((String)"translated content differs", (String)"                                    (function(){return myMethod();;})();(function(){return myMethod2();;})(); \n         \ndojo.xhr(\"x\"); \n", (String)translated);
        StringBuffer problems = new StringBuffer();
        translation.reconcileCompilationUnit();
        List problemList = translation.getProblems();
        int i = 0;
        while (i < problemList.size()) {
            problems.append(((IProblem)problemList.get(i)).getMessage());
            problems.append('\n');
            ++i;
        }
        TestHtmlTranslation.assertEquals((String)"problems were found", (String)"", (String)problems.toString());
        TestHtmlTranslation.assertEquals((String)"offsets didn't match", (int)structuredModel.getStructuredDocument().get().indexOf("dojo. \n"), (int)translated.indexOf("dojo. \n"));
        TestHtmlTranslation.assertNotSame((String)"script locations not returned by translation", null, (Object)translation.getScriptPositions());
        int expectedOffset = structuredModel.getStructuredDocument().get().indexOf(dojoCall);
        TestHtmlTranslation.assertEquals((String)"script location not returned by translation", (int)expectedOffset, (int)translation.getScriptPositions()[0].getOffset());
        TestHtmlTranslation.assertEquals((String)"script location length incorrect in translation", (int)dojoCall.length(), (int)translation.getScriptPositions()[0].getLength());
        structuredModel.releaseFromRead();
    }

    public void testCDATAAroundJS1() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script> <![CDATA[ var text =  serverObject.getText() ]]> </script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("CDATA") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("[") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA end found", (translated.indexOf("]") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testCDATAAroundJS2() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script><![CDATA[ var text =  serverObject.getText() ]]></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("CDATA") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("[") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA end found", (translated.indexOf("]") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }

    public void testCDATAAroundJS3() {
        String fileName = String.valueOf(this.getName()) + ".html";
        IStructuredModel structuredModel = this.getSharedModel(fileName, "<script>//<![CDATA[\n var text =  serverObject.getText(); ]]></script>");
        TestHtmlTranslation.assertNotNull((String)"missing test model", (Object)structuredModel);
        JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)structuredModel);
        JsTranslationAdapter translationAdapter = (JsTranslationAdapter)((IDOMModel)structuredModel).getDocument().getAdapterFor(IJsTranslation.class);
        IJsTranslation translation = translationAdapter.getJsTranslation(false);
        String translated = translation.getJsText();
        TestHtmlTranslation.assertTrue((String)"translation empty", (translated.length() > 5 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("CDATA") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA start found", (translated.indexOf("[") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"CDATA end found", (translated.indexOf("]") < 0 ? 1 : 0) != 0);
        TestHtmlTranslation.assertTrue((String)"problems found in translation ", (boolean)translation.getProblems().isEmpty());
        structuredModel.releaseFromRead();
    }
}

