/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.swt.bindings;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CheckBoxModelBindingUITest
extends ApplicationWindow {
    private final TestModel testModel = new TestModel(true, true);
    private final ModifiablePropertyValueModel<TestModel> testModelModel = new SimplePropertyValueModel((Object)this.testModel);
    private final ModifiablePropertyValueModel<Boolean> flag1Model = this.buildFlag1Model((PropertyValueModel<TestModel>)this.testModelModel);
    private final ModifiablePropertyValueModel<Boolean> flag2Model = this.buildFlag2Model((PropertyValueModel<TestModel>)this.testModelModel);
    private final ModifiablePropertyValueModel<Boolean> notFlag2Model = this.buildNotFlag2Model((PropertyValueModel<TestModel>)this.testModelModel);

    public static void main(String[] args) throws Exception {
        CheckBoxModelBindingUITest window = new CheckBoxModelBindingUITest(args);
        window.setBlockOnOpen(true);
        window.open();
        Display.getCurrent().dispose();
        System.exit(0);
    }

    private CheckBoxModelBindingUITest(String[] args) {
        super(null);
    }

    private ModifiablePropertyValueModel<Boolean> buildFlag1Model(PropertyValueModel<TestModel> subjectModel) {
        return new PropertyAspectAdapter<TestModel, Boolean>(subjectModel, new String[]{"flag1"}){

            protected Boolean buildValue_() {
                return ((TestModel)((Object)this.subject)).isFlag1();
            }

            protected void setValue_(Boolean value) {
                ((TestModel)((Object)this.subject)).setFlag1(value);
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildFlag2Model(PropertyValueModel<TestModel> subjectModel) {
        return new PropertyAspectAdapter<TestModel, Boolean>(subjectModel, new String[]{"flag2"}){

            protected Boolean buildValue_() {
                return ((TestModel)((Object)this.subject)).isFlag2();
            }

            protected void setValue_(Boolean value) {
                ((TestModel)((Object)this.subject)).setFlag2(value);
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildNotFlag2Model(PropertyValueModel<TestModel> subjectModel) {
        return new PropertyAspectAdapter<TestModel, Boolean>(subjectModel, new String[]{"notFlag2"}){

            protected Boolean buildValue_() {
                return ((TestModel)((Object)this.subject)).isNotFlag2();
            }

            protected void setValue_(Boolean value) {
                ((TestModel)((Object)this.subject)).setNotFlag2(value);
            }
        };
    }

    protected Control createContents(Composite parent) {
        ((Shell)parent).setText(((Object)((Object)this)).getClass().getSimpleName());
        parent.setSize(400, 100);
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new FormLayout());
        Control checkBoxPanel = this.buildCheckBoxPanel(mainPanel);
        this.buildControlPanel(mainPanel, checkBoxPanel);
        return mainPanel;
    }

    private Control buildCheckBoxPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100, -35);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout());
        this.buildFlag1CheckBox(panel);
        this.buildFlag2CheckBox(panel);
        this.buildNotFlag2CheckBox(panel);
        this.buildUnattachedCheckBox(panel);
        return panel;
    }

    private void buildFlag1CheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText("flag 1");
        SWTBindingTools.bind(this.flag1Model, (Button)checkBox);
    }

    private void buildFlag2CheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText("flag 2");
        SWTBindingTools.bind(this.flag2Model, (Button)checkBox);
    }

    private void buildNotFlag2CheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText("not flag 2");
        SWTBindingTools.bind(this.notFlag2Model, (Button)checkBox);
    }

    private void buildUnattachedCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText("unattached");
        checkBox.addSelectionListener(this.buildUnattachedSelectionListener());
    }

    private SelectionListener buildUnattachedSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                System.out.println("unattached default selected: " + e);
            }

            public void widgetSelected(SelectionEvent e) {
                System.out.println("unattached selected: " + e);
            }
        };
    }

    private void buildControlPanel(Composite parent, Control checkBoxPanel) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(checkBoxPanel);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout());
        this.buildFlipFlag1Button(panel);
        this.buildNotFlag2ToggleButton(panel);
        this.buildClearModelButton(panel);
        this.buildRestoreModelButton(panel);
        this.buildPrintModelButton(panel);
    }

    private void buildFlipFlag1Button(Composite parent) {
        this.buildFlipFlag1ACI().fill(parent);
    }

    private ActionContributionItem buildFlipFlag1ACI() {
        Action action = new Action("flip flag 1", 1){

            public void run() {
                CheckBoxModelBindingUITest.this.flipFlag1();
            }
        };
        action.setToolTipText("flip flag 1");
        return new ActionContributionItem((IAction)action);
    }

    void flipFlag1() {
        this.testModel.setFlag1(!this.testModel.isFlag1());
    }

    private void buildNotFlag2ToggleButton(Composite parent) {
        Button checkBox = new Button(parent, 2);
        checkBox.setText("not flag 2");
        SWTBindingTools.bind(this.notFlag2Model, (Button)checkBox);
    }

    private void buildClearModelButton(Composite parent) {
        this.buildClearModelACI().fill(parent);
    }

    private ActionContributionItem buildClearModelACI() {
        Action action = new Action("clear model", 1){

            public void run() {
                CheckBoxModelBindingUITest.this.clearModel();
            }
        };
        action.setToolTipText("clear model");
        return new ActionContributionItem((IAction)action);
    }

    void clearModel() {
        this.testModelModel.setValue(null);
    }

    private void buildRestoreModelButton(Composite parent) {
        this.buildRestoreModelACI().fill(parent);
    }

    private ActionContributionItem buildRestoreModelACI() {
        Action action = new Action("restore model", 1){

            public void run() {
                CheckBoxModelBindingUITest.this.restoreModel();
            }
        };
        action.setToolTipText("restore model");
        return new ActionContributionItem((IAction)action);
    }

    void restoreModel() {
        this.testModelModel.setValue((Object)this.testModel);
    }

    private void buildPrintModelButton(Composite parent) {
        this.buildPrintModelACI().fill(parent);
    }

    private ActionContributionItem buildPrintModelACI() {
        Action action = new Action("print model", 1){

            public void run() {
                CheckBoxModelBindingUITest.this.printModel();
            }
        };
        action.setToolTipText("print model");
        return new ActionContributionItem((IAction)action);
    }

    void printModel() {
        System.out.println("flag 1: " + this.testModel.isFlag1());
        System.out.println("flag 2: " + this.testModel.isFlag2());
        System.out.println("not flag 2: " + this.testModel.isNotFlag2());
        System.out.println("***");
    }

    public static class TestModel
    extends AbstractModel {
        private boolean flag1;
        public static final String FLAG1_PROPERTY = "flag1";
        private boolean flag2;
        public static final String FLAG2_PROPERTY = "flag2";
        private boolean notFlag2;
        public static final String NOT_FLAG2_PROPERTY = "notFlag2";

        public TestModel(boolean flag1, boolean flag2) {
            this.flag1 = flag1;
            this.flag2 = flag2;
            this.notFlag2 = !flag2;
        }

        public boolean isFlag1() {
            return this.flag1;
        }

        public void setFlag1(boolean flag1) {
            boolean old = this.flag1;
            this.flag1 = flag1;
            this.firePropertyChanged(FLAG1_PROPERTY, old, flag1);
        }

        public boolean isFlag2() {
            return this.flag2;
        }

        public void setFlag2(boolean flag2) {
            boolean old = this.flag2;
            this.flag2 = flag2;
            this.firePropertyChanged(FLAG2_PROPERTY, old, flag2);
            old = this.notFlag2;
            this.notFlag2 = !flag2;
            this.firePropertyChanged(NOT_FLAG2_PROPERTY, old, this.notFlag2);
        }

        public boolean isNotFlag2() {
            return this.notFlag2;
        }

        public void setNotFlag2(boolean notFlag2) {
            this.setFlag2(!notFlag2);
        }

        public String toString() {
            return "TestModel(" + this.isFlag1() + " - " + this.isFlag2() + ")";
        }
    }
}

