/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.eclipse.wst.sse.core.internal.encoding.util.BufferedLimitedStream;

public class Utilities {
    public static int calculateLengthDifference(String changes, int lengthToReplace) {
        int lengthDifference = 0;
        lengthDifference = changes == null ? 0 - lengthToReplace : changes.length() - lengthToReplace;
        return lengthDifference;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        boolean result = false;
        if (objectArray != null && object != null) {
            int i = 0;
            while (i < objectArray.length) {
                if (objectArray[i] == object) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean containsString(String[] objectArray, String object) {
        boolean result = false;
        if (objectArray != null && object != null) {
            int i = 0;
            while (i < objectArray.length) {
                if (objectArray[i].equals(object)) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static InputStream getLimitedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original instanceof BufferedLimitedStream) {
            return original;
        }
        return new BufferedLimitedStream(original, 8192);
    }

    public static InputStream getMarkSupportedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original.markSupported()) {
            return original;
        }
        BufferedInputStream buffered = new BufferedInputStream(original, 8192);
        ((InputStream)buffered).mark(8192);
        return buffered;
    }

    public static String makeShortId(Object id) {
        if (id == null) {
            id = "NOID";
        }
        String whole = id.toString();
        String part = whole.substring(whole.lastIndexOf("/") + 1);
        return "..." + part;
    }
}

