/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.properties;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.internal.encoding.CommonCharsetNames;

public class TestCommonNames
extends TestCase {
    private static final boolean DEBUG = false;

    public void testCommonNames() {
        String[] names = CommonCharsetNames.getCommonCharsetNames();
        TestCommonNames.assertTrue((String)"common charset names could not be loaded", (names != null && names.length > 0 ? 1 : 0) != 0);
    }

    public void doTestDefaultIanaNames(String stringToCheck, String defaultName, String expected) {
        String actual = CommonCharsetNames.getPreferredDefaultIanaName((String)stringToCheck, (String)defaultName);
        TestCommonNames.assertEquals((String)("default IANA name test failed for " + stringToCheck), (String)expected, (String)actual);
    }

    public void testASCII() {
        this.doTestDefaultIanaNames("ASCII", "UTF-8", "US-ASCII");
    }

    public void testCp1252() {
        this.doTestDefaultIanaNames("Cp1252", "UTF-8", "ISO-8859-1");
    }

    public void testMS950() {
        this.doTestDefaultIanaNames("MS950", "UTF-8", "BIG5");
    }

    public void testCp1256() {
        this.doTestDefaultIanaNames("Cp1256", "UTF-8", "windows-1256");
    }

    public void testMS949() {
        this.doTestDefaultIanaNames("MS949", "UTF-8", "EUC-KR");
    }

    public void testEUC_JP() {
        this.doTestDefaultIanaNames("EUC-JP", "UTF-8", "EUC-JP");
    }

    public void testTotallyFake() {
        this.doTestDefaultIanaNames("totallyFake", "UTF-8", "UTF-8");
    }

    public void testSystemEncoding() {
        String systemEnc = System.getProperty("file.encoding");
        if (systemEnc != null) {
            String actual = CommonCharsetNames.getPreferredDefaultIanaName((String)systemEnc, (String)"UTF-8");
            TestCommonNames.assertNotNull((String)("default IANA name test failed for system encoding " + systemEnc), (Object)actual);
        }
    }
}

