/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import javax.jws.soap.SOAPBinding;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractDocumentBareValidationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class DocBareOneNonHeaderINParameterRuleTest
extends AbstractDocumentBareValidationTest {
    @Override
    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebParam;\n\n");
        classContents.append("public class MyClass {\n\n\t");
        classContents.append("public String oneMore(@WebParam(name=\"inOne\", mode=WebParam.Mode.IN) String ");
        classContents.append("inOne, @WebParam(name=\"inTwo\", mode=WebParam.Mode.IN)String inTwo) {\n\t\t");
        classContents.append("return \"txt\";\n\t}\n\n\tpublic String onlyOneIN(String inOne, String inTwo) {");
        classContents.append("\n\t\treturn \"txt\";\n\t}\n}");
        return classContents.toString();
    }

    public void testOnlyOneNonHeaderINParameterRule() {
        try {
            DocBareOneNonHeaderINParameterRuleTest.assertNotNull((Object)this.annotation);
            DocBareOneNonHeaderINParameterRuleTest.assertEquals((String)SOAPBinding.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("onlyOneIN", new String[]{"QString;", "QString;"});
            DocBareOneNonHeaderINParameterRuleTest.assertNotNull((Object)method);
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)method, (String)SOAPBinding.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (Annotation)this.annotation));
            DocBareOneNonHeaderINParameterRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            DocBareOneNonHeaderINParameterRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            DocBareOneNonHeaderINParameterRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            DocBareOneNonHeaderINParameterRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            DocBareOneNonHeaderINParameterRuleTest.assertEquals((Object)JAXWSCoreMessages.DOC_BARE_ONLY_ONE_NON_HEADER_IN_PARAMETER, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            DocBareOneNonHeaderINParameterRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            DocBareOneNonHeaderINParameterRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            DocBareOneNonHeaderINParameterRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }

    public void testOnlyOneNonHeaderINParameterWithWebParamsRule() {
        try {
            DocBareOneNonHeaderINParameterRuleTest.assertNotNull((Object)this.annotation);
            DocBareOneNonHeaderINParameterRuleTest.assertEquals((String)SOAPBinding.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("oneMore", new String[]{"QString;", "QString;"});
            DocBareOneNonHeaderINParameterRuleTest.assertNotNull((Object)method);
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)method, (String)SOAPBinding.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (Annotation)this.annotation));
            DocBareOneNonHeaderINParameterRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            DocBareOneNonHeaderINParameterRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            DocBareOneNonHeaderINParameterRuleTest.assertTrue((boolean)this.source.getImport(SOAPBinding.class.getCanonicalName()).exists());
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            DocBareOneNonHeaderINParameterRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            DocBareOneNonHeaderINParameterRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            DocBareOneNonHeaderINParameterRuleTest.assertEquals((Object)JAXWSCoreMessages.DOC_BARE_ONLY_ONE_NON_HEADER_IN_PARAMETER, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            DocBareOneNonHeaderINParameterRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            DocBareOneNonHeaderINParameterRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            DocBareOneNonHeaderINParameterRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

