/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xml.core.tests.document.UnzippedProjectTester;

public class TestModelsFromFiles
extends UnzippedProjectTester {
    private static final String NONEXISTENT_FILENAME1 = "testfiles/xml/testnonexistent1.xml";
    private static final String NONEXISTENT_FILENAME2 = "testfiles/xml/testnonexistent2.xml";
    private static final String NONEXISTENT_FILENAME3 = "testfiles/xml/testnonexistent3.xml";
    private static final String EXISTENT_FILENAME1 = "testfiles/xml/testNormalCase.xml";
    private static final boolean DEBUG = false;

    public void testNonExistentFileWithBuffer() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.doTestCreateBuffer(NONEXISTENT_FILENAME1, BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testNonExistentXML() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.doTestCreate(NONEXISTENT_FILENAME2, BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testNonExistentXMLIDs() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.doTestCreateIDs(NONEXISTENT_FILENAME3, BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testSimpleCase() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.doTestCreate(EXISTENT_FILENAME1, BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    private void addContentsAndCreateFile(IFile file) throws CoreException {
        StringBufferInputStream stringStream = new StringBufferInputStream("testing testing testing");
        file.create((InputStream)stringStream, false, null);
    }

    private void doTestCreate(String filePath, Class class1, Class class2) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IFile file = (IFile)fTestProject.findMember(filePath);
        if (file == null) {
            file = fTestProject.getFile(filePath);
        }
        IStructuredModel model = modelManager.getNewModelForEdit(file, true);
        try {
            TestModelsFromFiles.assertTrue((boolean)true);
            String fileLocation = model.getBaseLocation();
            String string = model.getId();
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private void doTestCreateBuffer(String filePath, Class class1, Class class2) throws CoreException {
        IFile file = (IFile)fTestProject.findMember(filePath);
        if (file == null) {
            file = fTestProject.getFile(filePath);
        }
        ITextFileBuffer fileBufferBeforeExists = this.getTextBuffer(file);
        this.addContentsAndCreateFile(file);
        ITextFileBuffer fileBufferAfterExists = this.getTextBuffer(file);
        boolean buffersIdentical = fileBufferBeforeExists == fileBufferAfterExists;
        TestModelsFromFiles.assertTrue((boolean)buffersIdentical);
    }

    private void doTestCreateIDs(String filePath, Class class1, Class class2) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IFile file = (IFile)fTestProject.findMember(filePath);
        if (file == null) {
            file = fTestProject.getFile(filePath);
        }
        IStructuredModel model = modelManager.getNewModelForEdit(file, true);
        try {
            TestModelsFromFiles.assertNotNull((Object)model);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private ITextFileBuffer getTextBuffer(IFile file) throws CoreException {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        IPath fileIPath = file.getFullPath();
        IPath normalizedPath = FileBuffers.normalizeLocation((IPath)fileIPath);
        fileBufferManager.connect(normalizedPath, null);
        ITextFileBuffer buffer = fileBufferManager.getTextFileBuffer(normalizedPath);
        return buffer;
    }
}

