/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class DialogUtils {
    public static final Message NULL_MESSAGE = new Message(null, MessagePriority.NONE);
    private static final Comparator<Message> messageComparatorBySeverity = new Comparator<Message>(){

        @Override
        public int compare(Message o1, Message o2) {
            int ordinal2;
            int ordinal1 = o1.getPriority().ordinal();
            if (ordinal1 < (ordinal2 = o2.getPriority().ordinal())) {
                return 1;
            }
            if (ordinal1 == ordinal2) {
                return 0;
            }
            return -1;
        }
    };
    private static NormalExpressionWrapper NORMAL_EXPRESSION_WRAPPER = new NormalExpressionWrapper();
    private static final ScopeMerger VARIABLE_MERGER_CACHE = new ScopeMerger();
    private static final OptionalScopeMerger OPTIONAL_VARIABLE_MERGER_CACHE = new OptionalScopeMerger();

    public static <T> ValueSource<T> createConstant(final T constnant, Updater updater) {
        ValueSource source = new ValueSource<T>(){

            @Override
            public T getValue() {
                return constnant;
            }
        };
        updater.addSource(updater.rootScope(), source);
        return source;
    }

    public static <V> Optional<V> createOptional(final V value) {
        return new Optional<V>(){

            @Override
            public Set<Message> errorMessages() {
                return Collections.emptySet();
            }

            @Override
            public V getNormal() {
                return value;
            }

            @Override
            public boolean isNormal() {
                return true;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (!obj.getClass().equals(this.getClass())) {
                    return false;
                }
                Optional other = (Optional)obj;
                if (value == null) {
                    return other.getNormal() == null;
                }
                return value.equals(other.getNormal());
            }

            public int hashCode() {
                return value == null ? 0 : value.hashCode();
            }
        };
    }

    public static <V> Optional<V> createErrorOptional(Message message) {
        return DialogUtils.createErrorOptional(Collections.singleton(message));
    }

    public static <V> Optional<V> createErrorOptional(final Set<? extends Message> messages) {
        return new Optional<V>(){

            @Override
            public Set<? extends Message> errorMessages() {
                return messages;
            }

            @Override
            public V getNormal() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isNormal() {
                return false;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (!obj.getClass().equals(this.getClass())) {
                    return false;
                }
                Optional other = (Optional)obj;
                if (messages == null) {
                    return other.errorMessages() == null;
                }
                return messages.equals(other.errorMessages());
            }

            public int hashCode() {
                return messages.hashCode();
            }
        };
    }

    public static <RES> Gettable<Optional<? extends RES>> handleErrors(NormalExpression<RES> expression) {
        return NORMAL_EXPRESSION_WRAPPER.handleErrors(expression);
    }

    public static ValueSource<? extends Optional<?>>[] dependencies(ValueSource<? extends Optional<?>> ... sources) {
        return sources;
    }

    public static <VARIABLES> VARIABLES mergeBranchVariables(Class<VARIABLES> variablesType, Switcher<?> switcher, VARIABLES ... branches) {
        return VARIABLE_MERGER_CACHE.mergeBranches(variablesType, switcher, branches);
    }

    public static <VARIABLES> VARIABLES mergeBranchVariables(Class<VARIABLES> variablesType, OptionalSwitcher<?> switcher, VARIABLES ... branches) {
        return OPTIONAL_VARIABLE_MERGER_CACHE.mergeBranches(variablesType, switcher, branches);
    }

    public static Message chooseImportantMessage(Collection<? extends Message> messages) {
        if (messages.isEmpty()) {
            return NULL_MESSAGE;
        }
        return Collections.max(messages, messageComparatorBySeverity);
    }

    public static <T> ValueProcessor<T> createProcessor(final Gettable<T> expression) {
        return new ValueProcessor<T>(){

            @Override
            public void update(Updater updater) {
                Object newValue = expression.getValue();
                Object oldValue = this.getValue();
                boolean same = newValue == null ? oldValue == null : newValue.equals(oldValue);
                this.setCurrentValue(newValue);
                if (!same) {
                    updater.reportChanged(this);
                }
            }
        };
    }

    public static void addModifyListener(Text textElement, final ValueSource<?> valueSource, final Updater updater) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                updater.reportChanged(valueSource);
                updater.update();
            }
        };
        textElement.addModifyListener(listener);
    }

    public static void addModifyListener(Button button, final ValueSource<?> valueSource, final Updater updater) {
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                updater.reportChanged(valueSource);
                updater.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                updater.reportChanged(valueSource);
                updater.update();
            }
        };
        button.addSelectionListener(listener);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BranchVariableGetter {
    }

    public static abstract class ComboWrapper<E> {
        private final Combo combo;

        public ComboWrapper(Combo combo) {
            this.combo = combo;
        }

        public Combo getCombo() {
            return this.combo;
        }

        public void addSelectionListener(SelectionListener listener) {
            this.combo.addSelectionListener(listener);
        }

        public abstract E getSelected();

        public abstract void setSelected(E var1);
    }

    public static abstract class ExpressionProcessor<T>
    extends ValueProcessor<Optional<T>> {
        private final List<ValueSource<? extends Optional<?>>> optionalSources;

        public ExpressionProcessor(List<ValueSource<? extends Optional<?>>> optionalSources) {
            this.optionalSources = optionalSources;
        }

        protected abstract Optional<T> calculateNormal();

        private Optional<T> calculateNewValue() {
            LinkedHashSet<Message> errors = new LinkedHashSet<Message>(0);
            for (ValueSource<Optional<?>> source : this.optionalSources) {
                if (source.getValue().isNormal()) continue;
                errors.addAll(source.getValue().errorMessages());
            }
            if (errors.isEmpty()) {
                return this.calculateNormal();
            }
            return DialogUtils.createErrorOptional(errors);
        }

        @Override
        public void update(Updater updater) {
            Optional<T> result = this.calculateNewValue();
            Optional oldValue = (Optional)this.getValue();
            this.setCurrentValue(result);
            if (!result.equals(oldValue)) {
                updater.reportChanged(this);
            }
        }
    }

    public static interface Gettable<RES> {
        public RES getValue();
    }

    public static class Message {
        private final String text;
        private final MessagePriority priority;

        public Message(String text, MessagePriority priority) {
            this.text = text;
            this.priority = priority;
        }

        public String getText() {
            return this.text;
        }

        public MessagePriority getPriority() {
            return this.priority;
        }
    }

    public static enum MessagePriority {
        BLOCKING_PROBLEM(3),
        BLOCKING_INFO(0),
        WARNING(2),
        NONE(0);

        private final int messageProviderType;

        private MessagePriority(int messageProviderType) {
            this.messageProviderType = messageProviderType;
        }

        public int getMessageProviderType() {
            return this.messageProviderType;
        }
    }

    public static interface NormalExpression<T> {

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface Calculate {
        }

        @Target(value={ElementType.METHOD})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface DependencyGetter {
        }
    }

    private static class NormalExpressionWrapper {
        private final Map<Class<?>, GettableFactory<?>> classToFactoryMap = new HashMap();

        private NormalExpressionWrapper() {
        }

        <RES> Gettable<Optional<? extends RES>> handleErrors(NormalExpression<RES> expression) {
            return this.getFactoryForExpression(expression).create(expression);
        }

        private <RES> GettableFactory<RES> getFactoryForExpression(NormalExpression<RES> expression) {
            Class<?> expressionClass = expression.getClass();
            GettableFactory<Object> factory = this.classToFactoryMap.get(expressionClass);
            if (factory == null) {
                factory = NormalExpressionWrapper.createFactory(expressionClass);
                this.classToFactoryMap.put(expressionClass, factory);
            }
            return factory;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static <RES> GettableFactory<RES> createFactory(Class<? extends NormalExpression> expressionClass) {
            void var5_11;
            void var5_8;
            Method[] parameterizedType;
            ParameterizedType normalExpressionType = null;
            Type[] typeArray = expressionClass.getGenericInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type inter = typeArray[n2];
                if (inter instanceof ParameterizedType && (parameterizedType = (Method[])inter).getRawType().equals(NormalExpression.class)) {
                    normalExpressionType = parameterizedType;
                }
                ++n2;
            }
            if (normalExpressionType == null) {
                throw new IllegalArgumentException("Expression does not directly implement " + NormalExpression.class.getName());
            }
            Type expressionType = normalExpressionType.getActualTypeArguments()[0];
            Method calculateMethod = null;
            ArrayList<Method> dependencyMethods = new ArrayList<Method>(2);
            parameterizedType = expressionClass.getMethods();
            int n3 = parameterizedType.length;
            boolean bl = false;
            while (var5_8 < n3) {
                Method m = parameterizedType[var5_8];
                if (m.getAnnotation(NormalExpression.Calculate.class) != null) {
                    if (calculateMethod != null) {
                        throw new IllegalArgumentException("Class " + expressionClass.getName() + " has more than one method with " + NormalExpression.Calculate.class.getName() + " annotation");
                    }
                    calculateMethod = m;
                }
                if (m.getAnnotation(NormalExpression.DependencyGetter.class) != null) {
                    dependencyMethods.add(m);
                }
                ++var5_8;
            }
            if (calculateMethod == null) {
                throw new IllegalArgumentException("Failed to found Class method with " + NormalExpression.Calculate.class.getName() + " annotation in " + expressionClass.getName());
            }
            Type methodReturnType = calculateMethod.getGenericReturnType();
            calculateMethod.setAccessible(true);
            if (methodReturnType.equals(expressionType)) {
                ReturnValueHandler returnValueHandler = new ReturnValueHandler<RES>(){

                    @Override
                    Optional<? extends RES> castResult(Object resultObject) {
                        return DialogUtils.createOptional(resultObject);
                    }
                };
            } else {
                ParameterizedType parameterizedType2;
                if (!(methodReturnType instanceof ParameterizedType) || (parameterizedType2 = (ParameterizedType)methodReturnType).getRawType() != Optional.class) throw new IllegalArgumentException("Wrong return type " + methodReturnType + ", expected: " + expressionType);
                Type optionalParam = parameterizedType2.getActualTypeArguments()[0];
                boolean okToCast = false;
                if (optionalParam instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)optionalParam;
                    if (wildcardType.getUpperBounds()[0].equals(expressionType)) {
                        okToCast = true;
                    }
                } else if (optionalParam.equals(expressionType)) {
                    okToCast = true;
                }
                if (!okToCast) throw new IllegalArgumentException("Wrong return type " + methodReturnType + ", expected: " + expressionType);
                ReturnValueHandler returnValueHandler = new ReturnValueHandler<RES>(){

                    @Override
                    Optional<? extends RES> castResult(Object resultObject) {
                        return (Optional)resultObject;
                    }
                };
            }
            Type[] methodParamTypes = calculateMethod.getGenericParameterTypes();
            if (methodParamTypes.length != dependencyMethods.size()) {
                throw new IllegalArgumentException("Wrong number of agruments in calculate method " + calculateMethod);
            }
            int i = 0;
            while (i < methodParamTypes.length) {
                Method depMethod = (Method)dependencyMethods.get(i);
                try {
                    if (depMethod.getParameterTypes().length != 0) {
                        throw new IllegalArgumentException("Dependency method should not have arguments");
                    }
                    Type depType = depMethod.getGenericReturnType();
                    if (!(depType instanceof ParameterizedType)) {
                        throw new IllegalArgumentException("Dependency has wrong return type: " + depType);
                    }
                    ParameterizedType depParameterizedType = (ParameterizedType)depType;
                    if (depParameterizedType.getRawType() != ValueSource.class) {
                        throw new IllegalArgumentException("Dependency has wrong return type: " + depType);
                    }
                    depMethod.setAccessible(true);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Failed to process method " + depMethod, e);
                }
                ++i;
            }
            return new GettableFactory((List<Method>)dependencyMethods, var5_11, calculateMethod);
        }

        private static class GettableFactory<RES> {
            private final List<Method> dependencyMethods;
            private final ReturnValueHandler<RES> returnValueHandler;
            private final Method calculateMethod;

            GettableFactory(List<Method> dependencyMethods, ReturnValueHandler<RES> returnValueHandler, Method calculateMethod) {
                this.dependencyMethods = dependencyMethods;
                this.returnValueHandler = returnValueHandler;
                this.calculateMethod = calculateMethod;
            }

            Gettable<Optional<? extends RES>> create(final NormalExpression<RES> expression) {
                return new Gettable<Optional<? extends RES>>(){

                    @Override
                    public Optional<? extends RES> getValue() {
                        Object[] params = new Object[dependencyMethods.size()];
                        LinkedHashSet<Message> errors = null;
                        int i = 0;
                        while (i < params.length) {
                            Object sourceObject;
                            try {
                                sourceObject = ((Method)dependencyMethods.get(i)).invoke((Object)expression, new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                            ValueSource source = (ValueSource)sourceObject;
                            Optional optionalValue = (Optional)source.getValue();
                            if (optionalValue.isNormal()) {
                                params[i] = optionalValue.getNormal();
                            } else {
                                if (errors == null) {
                                    errors = new LinkedHashSet<Message>(0);
                                }
                                errors.addAll(optionalValue.errorMessages());
                            }
                            ++i;
                        }
                        if (errors == null) {
                            Object result;
                            try {
                                result = calculateMethod.invoke((Object)expression, params);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                            return returnValueHandler.castResult(result);
                        }
                        return DialogUtils.createErrorOptional(errors);
                    }
                };
            }
        }

        private static abstract class ReturnValueHandler<T> {
            private ReturnValueHandler() {
            }

            abstract Optional<? extends T> castResult(Object var1);
        }
    }

    public static class OkButtonControl<T>
    implements ValueConsumer {
        private final ValueSource<? extends Optional<? extends T>> resultSource;
        private final List<? extends ValueSource<String>> warningSources;
        private final OkButtonElements dialogElements;

        public OkButtonControl(ValueSource<? extends Optional<? extends T>> resultSource, List<? extends ValueSource<String>> warningSources, OkButtonElements dialogElements) {
            this.resultSource = resultSource;
            this.warningSources = warningSources;
            this.dialogElements = dialogElements;
        }

        public List<? extends ValueSource<?>> getDependencies() {
            ArrayList<ValueSource<Object>> result = new ArrayList<ValueSource<Object>>();
            result.add(this.resultSource);
            result.addAll(this.warningSources);
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(Updater updater) {
            void var4_8;
            Optional<T> result = this.resultSource.getValue();
            ArrayList<Message> messages = new ArrayList<Message>();
            for (ValueSource<String> valueSource : this.warningSources) {
                String warningValue = valueSource.getValue();
                if (warningValue == null) continue;
                messages.add(new Message(warningValue, MessagePriority.WARNING));
            }
            if (result.isNormal()) {
                boolean bl = true;
            } else {
                boolean bl = false;
                messages.addAll(result.errorMessages());
            }
            this.dialogElements.getOkButton().setEnabled((boolean)var4_8);
            Message visibleMessage = DialogUtils.chooseImportantMessage(messages);
            this.dialogElements.setMessage(visibleMessage.getText(), visibleMessage.getPriority().getMessageProviderType());
        }

        public T getNormalValue() {
            Optional<T> optional = this.resultSource.getValue();
            if (optional.isNormal()) {
                return optional.getNormal();
            }
            return null;
        }
    }

    public static interface OkButtonElements {
        public Button getOkButton();

        public void setMessage(String var1, int var2);
    }

    public static interface Optional<V> {
        public V getNormal();

        public boolean isNormal();

        public Set<? extends Message> errorMessages();
    }

    private static class OptionalScopeMerger
    extends ScopeMergerBase<OptionalSwitcher<?>> {
        private OptionalScopeMerger() {
        }

        @Override
        protected ValueSource<?> createValueMerger(OptionalSwitcher<?> switcher, ValueSource<?>[] allCasesSources) {
            ValueSource<?>[] castedSources = allCasesSources;
            return switcher.createOptionalMerge(castedSources);
        }

        @Override
        protected void checkGetterType(Type valueSourceParamType) {
            Type innerParameterRawType;
            Type innerParameter;
            if (valueSourceParamType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)valueSourceParamType;
                innerParameter = wildcardType.getUpperBounds()[0];
                if (innerParameter == null) {
                    throw new IllegalArgumentException("Method should return parameterized type " + ValueSource.class + " with Optional parameter type");
                }
            } else {
                innerParameter = valueSourceParamType;
            }
            if (innerParameter instanceof ParameterizedType) {
                ParameterizedType innerParameterParameterizedType = (ParameterizedType)innerParameter;
                innerParameterRawType = innerParameterParameterizedType.getRawType();
            } else {
                innerParameterRawType = innerParameter;
            }
            if (!innerParameterRawType.equals(Optional.class)) {
                throw new IllegalArgumentException("Method should return parameterized type " + ValueSource.class + " with Optional parameter type");
            }
        }
    }

    public static interface OptionalSwitcher<T>
    extends SwitchBase<T> {
        public <P> ValueSource<? extends Optional<? extends P>> createOptionalMerge(ValueSource<? extends Optional<? extends P>> ... var1);
    }

    private static class OptionalSwitcherImpl<T>
    extends SwitcherBaseImpl<T>
    implements OptionalSwitcher<T> {
        private final Gettable<? extends Optional<? extends T>> expression;
        private final ValueSource<Optional<? extends T>> sourceForMerge = new ValueSource<Optional<? extends T>>(){

            @Override
            public Optional<? extends T> getValue() {
                return (Optional)expression.getValue();
            }
        };

        OptionalSwitcherImpl(ScopeImpl outerScope, Gettable<? extends Optional<? extends T>> expression) {
            super(outerScope);
            this.expression = expression;
        }

        @Override
        ValueSource<?> getSourceForMerge() {
            return this.sourceForMerge;
        }

        @Override
        void updateScopes() {
            ScopeImpl newScope;
            Optional<T> control = this.expression.getValue();
            if (control.isNormal()) {
                T tag = control.getNormal();
                newScope = this.getScopeForTag(tag);
            } else {
                newScope = null;
            }
            this.setCurrentScope(newScope);
        }

        @Override
        public <P> ValueSource<? extends Optional<? extends P>> createOptionalMerge(ValueSource<? extends Optional<? extends P>> ... sources) {
            final Map map = this.sortSources(Arrays.asList(sources));
            ValueProcessor result = new ValueProcessor<Optional<? extends P>>(){

                @Override
                public void update(Updater updater) {
                    this.setCurrentValue(this.calculate());
                    updater.reportChanged(this);
                }

                private Optional<? extends P> calculate() {
                    Optional control = (Optional)sourceForMerge.getValue();
                    if (control.isNormal()) {
                        ValueSource oneSource = (ValueSource)map.get(control.getNormal());
                        return (Optional)oneSource.getValue();
                    }
                    return DialogUtils.createErrorOptional(control.errorMessages());
                }
            };
            ScopeImpl outerScope = this.getOuterScope();
            Updater updater = outerScope.getUpdater();
            updater.addConsumer(outerScope, result);
            updater.addDependency((ValueConsumer)result, this.getSourceForMerge());
            ValueSource<? extends Optional<? extends P>>[] valueSourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                ValueSource<? extends Optional<? extends P>> source = valueSourceArray[n2];
                updater.addDependencyNoCheck(result, source);
                ++n2;
            }
            outerScope.getUpdater().addSource(outerScope, result);
            return result;
        }
    }

    public static interface Scope {
        public Scope getOuterScope();

        public <T> OptionalSwitcher<T> addOptionalSwitch(Gettable<? extends Optional<? extends T>> var1);

        public <T> Switcher<T> addSwitch(Gettable<T> var1);
    }

    public static interface ScopeEnabler {
        public void setEnabled(boolean var1, boolean var2);
    }

    private static class ScopeImpl
    implements Scope {
        private final Updater updater;
        private final SwitcherBaseImpl<?> switcher;
        private final ScopeEnabler scopeEnabler;
        private final Set<ValueConsumer> delayedConsumers = new HashSet<ValueConsumer>(0);
        private final List<SwitcherBaseImpl<?>> nestedSwitchers = new ArrayList(1);

        ScopeImpl(Updater updater) {
            this(null, null, updater);
        }

        public boolean isActive() {
            if (this.switcher == null) {
                return true;
            }
            return this.switcher.getOuterScope().isActive() && this.switcher.getCurrentScope() == this;
        }

        public void addDelayedConsumer(ValueConsumer consumer) {
            this.delayedConsumers.add(consumer);
        }

        public void setEnabled(boolean enabled) {
            if (enabled) {
                for (ValueConsumer consumer : this.delayedConsumers) {
                    this.updater.addConsumerToUpdate(consumer);
                }
                this.delayedConsumers.clear();
            }
            if (this.scopeEnabler != null) {
                this.scopeEnabler.setEnabled(enabled, false);
            }
        }

        Updater getUpdater() {
            return this.updater;
        }

        ScopeImpl(SwitcherBaseImpl<?> switcher, ScopeEnabler scopeEnabler, Updater updater) {
            this.switcher = switcher;
            this.scopeEnabler = scopeEnabler;
            this.updater = updater;
        }

        public <P> OptionalSwitcher<P> addOptionalSwitch(Gettable<? extends Optional<? extends P>> expression) {
            OptionalSwitcherImpl switcher = new OptionalSwitcherImpl(this, expression);
            this.updater.addConsumer(this, switcher.getValueConsumer());
            this.updater.addSource(this, switcher.getSourceForMerge());
            this.updater.addDependency(switcher.getValueConsumer(), switcher.getSourceForMerge());
            return switcher;
        }

        public <P> Switcher<P> addSwitch(Gettable<P> expression) {
            SwitcherImpl<P> switcher = new SwitcherImpl<P>(this, expression);
            this.updater.addConsumer(this, switcher.getValueConsumer());
            this.updater.addSource(this, switcher.getSourceForMerge());
            this.updater.addDependency(switcher.getValueConsumer(), switcher.getSourceForMerge());
            return switcher;
        }

        @Override
        public Scope getOuterScope() {
            if (this.switcher == null) {
                return null;
            }
            return this.switcher.getOuterScope();
        }

        void processDisabledNested() {
            for (SwitcherBaseImpl<?> switcher : this.nestedSwitchers) {
                switcher.processDisabledScopes();
            }
        }
    }

    private static class ScopeMerger
    extends ScopeMergerBase<Switcher<?>> {
        private ScopeMerger() {
        }

        @Override
        protected ValueSource<?> createValueMerger(Switcher<?> switcher, ValueSource<?>[] allCasesSources) {
            return switcher.createMerge(allCasesSources);
        }

        @Override
        protected void checkGetterType(Type valueSourceParamType) {
        }
    }

    private static abstract class ScopeMergerBase<SW extends SwitchBase<?>> {
        private final Map<Class<?>, Factory<SW, ?>> cache = new HashMap();
        private static final Set<Method> OBJECT_METHODS = new HashSet<Method>();

        static {
            try {
                OBJECT_METHODS.add(Object.class.getMethod("toString", new Class[0]));
                OBJECT_METHODS.add(Object.class.getMethod("equals", Object.class));
                OBJECT_METHODS.add(Object.class.getMethod("hashCode", new Class[0]));
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private ScopeMergerBase() {
        }

        <VARIABLES> VARIABLES mergeBranches(Class<VARIABLES> variablesType, SW switcher, VARIABLES ... branches) {
            Factory<SW, Object> factory = this.cache.get(variablesType);
            if (factory == null) {
                factory = this.createFactory(variablesType);
                this.cache.put(variablesType, factory);
            }
            try {
                return (VARIABLES)factory.create(switcher, branches);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private <VARIABLES> Factory<SW, VARIABLES> createFactory(final Class<VARIABLES> variablesType) {
            Constructor<?> constructor;
            if (variablesType.getTypeParameters().length != 0) {
                throw new IllegalArgumentException("Type should not be parameterized");
            }
            final ArrayList<Method> getterMethods = new ArrayList<Method>();
            final HashMap<Method, Integer> methodToPosition = new HashMap<Method, Integer>();
            Method[] methodArray = variablesType.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getAnnotation(BranchVariableGetter.class) == null) {
                    throw new IllegalArgumentException("Method " + m + " should have " + BranchVariableGetter.class.getName() + " annotation");
                }
                if (m.getParameterTypes().length != 0) {
                    throw new IllegalArgumentException("Method " + m + " should have no parameters");
                }
                Type returnType = m.getGenericReturnType();
                try {
                    if (!(returnType instanceof ParameterizedType)) {
                        throw new IllegalArgumentException("Method should return parameterized type " + ValueSource.class);
                    }
                    ParameterizedType parameterizedType = (ParameterizedType)returnType;
                    if (parameterizedType.getRawType() != ValueSource.class) {
                        throw new IllegalArgumentException("Method should return parameterized type " + ValueSource.class);
                    }
                    this.checkGetterType(parameterizedType.getActualTypeArguments()[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Method " + m + " has wrong return type", e);
                }
                int position = getterMethods.size();
                getterMethods.add(m);
                methodToPosition.put(m, position);
                ++n2;
            }
            Class<?> proxyClass = Proxy.getProxyClass(this.getClass().getClassLoader(), variablesType);
            try {
                constructor = proxyClass.getConstructor(InvocationHandler.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            return new Factory<SW, VARIABLES>(){

                @Override
                public VARIABLES create(SW switcher, VARIABLES ... branches) throws IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
                    Object resultInstance;
                    final ValueSource[] dataArray = new ValueSource[getterMethods.size()];
                    int i = 0;
                    while (i < dataArray.length) {
                        ValueSource[] allBranchesSources = new ValueSource[branches.length];
                        Method interfaceGetter = (Method)getterMethods.get(i);
                        int j = 0;
                        while (j < allBranchesSources.length) {
                            if (branches[j] == null) {
                                allBranchesSources[j] = DialogUtils.createConstant(null, switcher.getUpdater());
                            } else {
                                Method classGetter = branches[j].getClass().getMethod(interfaceGetter.getName(), interfaceGetter.getParameterTypes());
                                classGetter.setAccessible(true);
                                allBranchesSources[j] = (ValueSource)classGetter.invoke(branches[j], new Object[0]);
                            }
                            ++j;
                        }
                        dataArray[i] = this.createValueMerger(switcher, allBranchesSources);
                        ++i;
                    }
                    InvocationHandler invocationHandler = new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            if (OBJECT_METHODS.contains(method)) {
                                return method.invoke((Object)this, args);
                            }
                            Integer position = (Integer)methodToPosition.get(method);
                            if (position == null) {
                                throw new RuntimeException("Unknown method: " + method);
                            }
                            return dataArray[position];
                        }

                        public String toString() {
                            return "*Merged:" + variablesType;
                        }
                    };
                    try {
                        resultInstance = constructor.newInstance(invocationHandler);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    return resultInstance;
                }
            };
        }

        protected abstract ValueSource<?> createValueMerger(SW var1, ValueSource<?>[] var2);

        protected abstract void checkGetterType(Type var1);

        private static interface Factory<S, V> {
            public V create(S var1, V ... var2) throws IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException;
        }
    }

    public static interface SwitchBase<T> {
        public Scope addScope(T var1, ScopeEnabler var2);

        public ValueConsumer getValueConsumer();

        public Updater getUpdater();

        public Scope getOuterScope();
    }

    public static interface Switcher<T>
    extends SwitchBase<T> {
        public <P> ValueSource<P> createMerge(ValueSource<? extends P> ... var1);
    }

    private static abstract class SwitcherBaseImpl<T>
    implements SwitchBase<T> {
        private final ScopeImpl outerScope;
        private final Map<T, ScopeImpl> innerScopes = new LinkedHashMap<T, ScopeImpl>(2);
        private ScopeImpl currentScope = null;
        private final ValueConsumer consumer = new ValueConsumer(){

            @Override
            public void update(Updater updater) {
                this.updateScopes();
                updater.reportChanged(this.getSourceForMerge());
            }
        };

        ScopeImpl getScopeForTag(T tag) {
            return this.innerScopes.get(tag);
        }

        abstract void updateScopes();

        abstract ValueSource<?> getSourceForMerge();

        void setCurrentScope(ScopeImpl newScope) {
            if (newScope == this.currentScope) {
                return;
            }
            if (this.currentScope != null) {
                this.currentScope.setEnabled(false);
            }
            this.currentScope = newScope;
            if (this.currentScope != null) {
                this.currentScope.setEnabled(true);
            }
        }

        ScopeImpl getCurrentScope() {
            return this.currentScope;
        }

        @Override
        public Updater getUpdater() {
            return this.outerScope.getUpdater();
        }

        SwitcherBaseImpl(ScopeImpl outerScope) {
            this.outerScope = outerScope;
            this.outerScope.nestedSwitchers.add(this);
        }

        @Override
        public Scope addScope(T tag, ScopeEnabler scopeEnabler) {
            ScopeImpl scope = new ScopeImpl(this, scopeEnabler, this.outerScope.getUpdater());
            ScopeImpl conflict = this.innerScopes.put(tag, scope);
            if (conflict != null) {
                throw new IllegalStateException();
            }
            return scope;
        }

        @Override
        public ValueConsumer getValueConsumer() {
            return this.consumer;
        }

        @Override
        public ScopeImpl getOuterScope() {
            return this.outerScope;
        }

        <V extends ValueSource<?>> Map<T, V> sortSources(List<V> sources) {
            if (this.innerScopes.size() != sources.size()) {
                throw new IllegalArgumentException();
            }
            HashMap<T, ValueSource> result = new HashMap<T, ValueSource>();
            Updater updater = this.outerScope.getUpdater();
            int i = 0;
            for (Map.Entry<T, ScopeImpl> en : this.innerScopes.entrySet()) {
                ValueSource source = (ValueSource)sources.get(i);
                updater.checkSourceVisibleInScope(source, en.getValue());
                result.put(en.getKey(), source);
                ++i;
            }
            return result;
        }

        void processDisabledScopes() {
            for (ScopeImpl scope : this.innerScopes.values()) {
                if (scope != this.currentScope && scope.scopeEnabler != null) {
                    scope.scopeEnabler.setEnabled(false, false);
                }
                scope.processDisabledNested();
            }
        }
    }

    private static class SwitcherImpl<T>
    extends SwitcherBaseImpl<T>
    implements Switcher<T> {
        private final Gettable<? extends T> expression;
        private final ValueSource<T> sourceForMerge = new ValueSource<T>(){

            @Override
            public T getValue() {
                return expression.getValue();
            }
        };

        SwitcherImpl(ScopeImpl outerScope, Gettable<T> expression) {
            super(outerScope);
            this.expression = expression;
        }

        @Override
        ValueSource<?> getSourceForMerge() {
            return this.sourceForMerge;
        }

        @Override
        void updateScopes() {
            T tag = this.expression.getValue();
            ScopeImpl newScope = this.getScopeForTag(tag);
            this.setCurrentScope(newScope);
        }

        @Override
        public <P> ValueSource<P> createMerge(ValueSource<? extends P> ... sources) {
            final Map map = this.sortSources(Arrays.asList(sources));
            ValueProcessor result = new ValueProcessor<P>(){

                @Override
                public void update(Updater updater) {
                    this.setCurrentValue(this.calculate());
                    updater.reportChanged(this);
                }

                private P calculate() {
                    Object tag = sourceForMerge.getValue();
                    ValueSource oneSource = (ValueSource)map.get(tag);
                    return oneSource.getValue();
                }
            };
            ScopeImpl outerScope = this.getOuterScope();
            Updater updater = outerScope.getUpdater();
            updater.addConsumer(outerScope, result);
            updater.addDependency((ValueConsumer)result, this.getSourceForMerge());
            ValueSource<? extends P>[] valueSourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                ValueSource<? extends P> source = valueSourceArray[n2];
                updater.addDependencyNoCheck(result, source);
                ++n2;
            }
            outerScope.getUpdater().addSource(outerScope, result);
            return result;
        }
    }

    public static class Updater {
        private final LinkedHashMap<ValueConsumer, Boolean> needsUpdateMap = new LinkedHashMap();
        private final Map<ValueSource<?>, List<ValueConsumer>> reversedDependenciesMap = new HashMap();
        private final Map<ValueConsumer, ScopeImpl> consumer2Scope = new HashMap<ValueConsumer, ScopeImpl>();
        private final Map<ValueSource<?>, ScopeImpl> source2Scope = new HashMap();
        private boolean alreadyUpdating = false;
        private volatile boolean asyncStopped = false;
        private final ScopeImpl rootScope = new ScopeImpl(this);

        public void addConsumer(ValueConsumer value, ValueSource<?> ... dependencies) {
            this.addConsumer(value, Arrays.asList(dependencies));
        }

        public void addConsumer(ValueConsumer value, List<? extends ValueSource<?>> dependencies) {
            this.addConsumer(this.rootScope, value);
            for (ValueSource<?> dep : dependencies) {
                this.addDependency(value, dep);
            }
        }

        public void addConsumer(Scope scope, ValueConsumer consumer) {
            Boolean res = this.needsUpdateMap.put(consumer, Boolean.FALSE);
            if (res != null) {
                throw new IllegalArgumentException("Already added");
            }
            this.consumer2Scope.put(consumer, (ScopeImpl)scope);
        }

        public void addSource(Scope scope, ValueSource<?> source) {
            ScopeImpl scopeImpl = (ScopeImpl)scope;
            ScopeImpl conflict = this.source2Scope.put(source, scopeImpl);
            if (conflict != null) {
                throw new IllegalArgumentException("Already added");
            }
        }

        public void addDependency(ValueConsumer consumer, ValueSource<?> source) {
            Scope consumerScope = this.consumer2Scope.get(consumer);
            if (consumerScope == null) {
                throw new IllegalArgumentException("Unregistered consumer");
            }
            this.checkSourceVisibleInScope(source, consumerScope);
            this.addDependencyNoCheck(consumer, source);
        }

        public void addDependency(ValueConsumer consumer, List<? extends ValueSource<?>> sourceList) {
            for (ValueSource<?> source : sourceList) {
                this.addDependency(consumer, source);
            }
        }

        public synchronized void reportChanged(ValueSource<?> source) {
            List<ValueConsumer> reversedDeps = this.reversedDependenciesMap.get(source);
            if (reversedDeps != null) {
                for (ValueConsumer consumer : reversedDeps) {
                    this.addConsumerToUpdate(consumer);
                }
            }
        }

        public void update() {
            if (this.alreadyUpdating) {
                return;
            }
            this.alreadyUpdating = true;
            try {
                this.updateImpl();
            }
            finally {
                this.alreadyUpdating = false;
            }
        }

        public void updateAll() {
            for (Map.Entry<ValueConsumer, Boolean> en : this.needsUpdateMap.entrySet()) {
                en.setValue(Boolean.TRUE);
            }
            this.update();
            this.rootScope.processDisabledNested();
        }

        public Scope rootScope() {
            return this.rootScope;
        }

        public void updateAsync() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (asyncStopped) {
                        return;
                    }
                    this.update();
                }
            });
        }

        public void stopAsync() {
            this.asyncStopped = true;
        }

        void addDependencyNoCheck(ValueConsumer value, ValueSource<?> source) {
            List<ValueConsumer> reversedDeps = this.reversedDependenciesMap.get(source);
            if (reversedDeps == null) {
                reversedDeps = new ArrayList<ValueConsumer>(2);
                this.reversedDependenciesMap.put(source, reversedDeps);
            }
            reversedDeps.add(value);
        }

        void checkSourceVisibleInScope(ValueSource<?> source, Scope scope) {
            Scope sourceScope = this.source2Scope.get(source);
            if (sourceScope == null) {
                throw new IllegalArgumentException("Unregistered source");
            }
            do {
                if (!sourceScope.equals(scope)) continue;
                return;
            } while ((scope = scope.getOuterScope()) != null);
            throw new RuntimeException("Source from a wrong scope");
        }

        void addConsumerToUpdate(ValueConsumer consumer) {
            this.needsUpdateMap.put(consumer, Boolean.TRUE);
        }

        private void updateImpl() {
            boolean hasChanges = true;
            while (hasChanges) {
                hasChanges = false;
                for (Map.Entry<ValueConsumer, Boolean> en : this.needsUpdateMap.entrySet()) {
                    if (en.getValue() != Boolean.TRUE) continue;
                    en.setValue(Boolean.FALSE);
                    ValueConsumer currentValue = en.getKey();
                    ScopeImpl scope = this.consumer2Scope.get(currentValue);
                    if (scope.isActive()) {
                        currentValue.update(this);
                        continue;
                    }
                    scope.addDelayedConsumer(currentValue);
                }
            }
        }
    }

    public static interface ValueConsumer {
        public void update(Updater var1);
    }

    public static abstract class ValueProcessor<T>
    implements ValueConsumer,
    ValueSource<T> {
        private T currentValue = null;

        @Override
        public T getValue() {
            return this.currentValue;
        }

        protected void setCurrentValue(T currentValue) {
            this.currentValue = currentValue;
        }
    }

    public static interface ValueSource<T>
    extends Gettable<T> {
        @Override
        public T getValue();
    }
}

