/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.datatype.binding;

import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.binding.AccessPoint;
import org.uddi4j.datatype.binding.HostingRedirector;
import org.uddi4j.datatype.binding.TModelInstanceDetails;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BindingTemplate
extends UDDIElement {
    public static final String UDDI_TAG = "bindingTemplate";
    protected Element base = null;
    String bindingKey = null;
    String serviceKey = null;
    AccessPoint accessPoint = null;
    HostingRedirector hostingRedirector = null;
    TModelInstanceDetails tModelInstanceDetails = null;
    Vector description = new Vector();

    public BindingTemplate() {
    }

    public BindingTemplate(String bindingKey, TModelInstanceDetails tModelInstanceDetails) {
        this.bindingKey = bindingKey;
        this.tModelInstanceDetails = tModelInstanceDetails;
    }

    public BindingTemplate(String bindingKey, TModelInstanceDetails tModelInstanceDetails, AccessPoint accessPoint) {
        this.bindingKey = bindingKey;
        this.tModelInstanceDetails = tModelInstanceDetails;
        this.accessPoint = accessPoint;
    }

    public BindingTemplate(String bindingKey, TModelInstanceDetails tModelInstanceDetails, HostingRedirector hostingRedirector) {
        this.bindingKey = bindingKey;
        this.tModelInstanceDetails = tModelInstanceDetails;
        this.hostingRedirector = hostingRedirector;
    }

    public BindingTemplate(Element base) throws UDDIException {
        super(base);
        this.bindingKey = base.getAttribute("bindingKey");
        this.serviceKey = this.getAttr(base, "serviceKey");
        NodeList nl = null;
        nl = this.getChildElementsByTagName(base, "accessPoint");
        if (nl.getLength() > 0) {
            this.accessPoint = new AccessPoint((Element)nl.item(0));
        }
        if ((nl = this.getChildElementsByTagName(base, "hostingRedirector")).getLength() > 0) {
            this.hostingRedirector = new HostingRedirector((Element)nl.item(0));
        }
        if ((nl = this.getChildElementsByTagName(base, "tModelInstanceDetails")).getLength() > 0) {
            this.tModelInstanceDetails = new TModelInstanceDetails((Element)nl.item(0));
        }
        nl = this.getChildElementsByTagName(base, "description");
        int i = 0;
        while (i < nl.getLength()) {
            this.description.addElement(new Description((Element)nl.item(i)));
            ++i;
        }
    }

    private String getAttr(Element base, String attrname) {
        if (base.getAttributeNode(attrname) != null && base.getAttributeNode(attrname).getSpecified()) {
            return base.getAttribute(attrname);
        }
        return null;
    }

    public void setBindingKey(String s) {
        this.bindingKey = s;
    }

    public void setServiceKey(String s) {
        this.serviceKey = s;
    }

    public void setAccessPoint(AccessPoint s) {
        this.accessPoint = s;
        if (this.accessPoint != null && this.hostingRedirector != null) {
            this.hostingRedirector = null;
        }
    }

    public void setHostingRedirector(HostingRedirector s) {
        this.hostingRedirector = s;
        if (this.hostingRedirector != null && this.accessPoint != null) {
            this.accessPoint = null;
        }
    }

    public void setTModelInstanceDetails(TModelInstanceDetails s) {
        this.tModelInstanceDetails = s;
    }

    public void setDescriptionVector(Vector s) {
        this.description = s;
    }

    public void setDefaultDescriptionString(String s) {
        if (this.description.size() > 0) {
            this.description.setElementAt(new Description(s), 0);
        } else {
            this.description.addElement(new Description(s));
        }
    }

    public String getBindingKey() {
        return this.bindingKey;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public HostingRedirector getHostingRedirector() {
        return this.hostingRedirector;
    }

    public TModelInstanceDetails getTModelInstanceDetails() {
        return this.tModelInstanceDetails;
    }

    public Vector getDescriptionVector() {
        return this.description;
    }

    public String getDefaultDescriptionString() {
        if (this.description.size() > 0) {
            Description t = (Description)this.description.elementAt(0);
            return t.getText();
        }
        return null;
    }

    public void saveToXML(Element parent) {
        this.base = parent.getOwnerDocument().createElementNS(UDDIElement.XMLNS, String.valueOf(UDDIElement.XMLNS_PREFIX) + UDDI_TAG);
        if (this.bindingKey != null) {
            this.base.setAttribute("bindingKey", this.bindingKey);
        }
        if (this.serviceKey != null) {
            this.base.setAttribute("serviceKey", this.serviceKey);
        }
        if (this.description != null) {
            int i = 0;
            while (i < this.description.size()) {
                ((Description)this.description.elementAt(i)).saveToXML(this.base);
                ++i;
            }
        }
        if (this.accessPoint != null) {
            this.accessPoint.saveToXML(this.base);
        }
        if (this.hostingRedirector != null) {
            this.hostingRedirector.saveToXML(this.base);
        }
        if (this.tModelInstanceDetails != null) {
            this.tModelInstanceDetails.saveToXML(this.base);
        }
        parent.appendChild(this.base);
    }
}

