/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.TimeOfDayAnnotation;

public final class EclipseLinkSourceTimeOfDayAnnotation
extends SourceAnnotation
implements TimeOfDayAnnotation {
    private final DeclarationAnnotationElementAdapter<Integer> hourDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> hourAdapter;
    private Integer hour;
    private TextRange hourTextRange;
    private final DeclarationAnnotationElementAdapter<Integer> minuteDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> minuteAdapter;
    private Integer minute;
    private TextRange minuteTextRange;
    private final DeclarationAnnotationElementAdapter<Integer> secondDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> secondAdapter;
    private Integer second;
    private TextRange secondTextRange;
    private final DeclarationAnnotationElementAdapter<Integer> millisecondDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> millisecondAdapter;
    private Integer millisecond;
    private TextRange millisecondTextRange;

    public EclipseLinkSourceTimeOfDayAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
        this.hourDeclarationAdapter = EclipseLinkSourceTimeOfDayAnnotation.buildHourAdapter(daa);
        this.hourAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.hourDeclarationAdapter);
        this.minuteDeclarationAdapter = EclipseLinkSourceTimeOfDayAnnotation.buildMinuteAdapter(daa);
        this.minuteAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.minuteDeclarationAdapter);
        this.secondDeclarationAdapter = EclipseLinkSourceTimeOfDayAnnotation.buildSecondAdapter(daa);
        this.secondAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.secondDeclarationAdapter);
        this.millisecondDeclarationAdapter = EclipseLinkSourceTimeOfDayAnnotation.buildMillisecondAdapter(daa);
        this.millisecondAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.millisecondDeclarationAdapter);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.TimeOfDay";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.hour = this.buildHour(astAnnotation);
        this.hourTextRange = this.buildHourTextRange(astAnnotation);
        this.minute = this.buildMinute(astAnnotation);
        this.minuteTextRange = this.buildMinuteTextRange(astAnnotation);
        this.second = this.buildSecond(astAnnotation);
        this.secondTextRange = this.buildSecondTextRange(astAnnotation);
        this.millisecond = this.buildMillisecond(astAnnotation);
        this.millisecondTextRange = this.buildMillisecondTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncHour(this.buildHour(astAnnotation));
        this.hourTextRange = this.buildHourTextRange(astAnnotation);
        this.syncMinute(this.buildMinute(astAnnotation));
        this.minuteTextRange = this.buildMinuteTextRange(astAnnotation);
        this.syncSecond(this.buildSecond(astAnnotation));
        this.secondTextRange = this.buildSecondTextRange(astAnnotation);
        this.syncMillisecond(this.buildMillisecond(astAnnotation));
        this.millisecondTextRange = this.buildMillisecondTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.hour == null && this.minute == null && this.second == null && this.millisecond == null;
    }

    @Override
    public Integer getHour() {
        return this.hour;
    }

    @Override
    public void setHour(Integer hour) {
        if (ObjectTools.notEquals((Object)this.hour, (Object)hour)) {
            this.hour = hour;
            this.hourAdapter.setValue((Object)hour);
        }
    }

    private void syncHour(Integer astHour) {
        Integer old = this.hour;
        this.hour = astHour;
        this.firePropertyChanged("hour", old, astHour);
    }

    private Integer buildHour(Annotation astAnnotation) {
        return (Integer)this.hourAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getHourTextRange() {
        return this.hourTextRange;
    }

    private TextRange buildHourTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.hourDeclarationAdapter, astAnnotation);
    }

    @Override
    public Integer getMinute() {
        return this.minute;
    }

    @Override
    public void setMinute(Integer minute) {
        if (ObjectTools.notEquals((Object)this.minute, (Object)minute)) {
            this.minute = minute;
            this.minuteAdapter.setValue((Object)minute);
        }
    }

    private void syncMinute(Integer astMinute) {
        Integer old = this.minute;
        this.minute = astMinute;
        this.firePropertyChanged("minute", old, astMinute);
    }

    private Integer buildMinute(Annotation astAnnotation) {
        return (Integer)this.minuteAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getMinuteTextRange() {
        return this.minuteTextRange;
    }

    private TextRange buildMinuteTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.minuteDeclarationAdapter, astAnnotation);
    }

    @Override
    public Integer getSecond() {
        return this.second;
    }

    @Override
    public void setSecond(Integer newSecond) {
        if (ObjectTools.notEquals((Object)this.second, (Object)newSecond)) {
            this.second = newSecond;
            this.secondAdapter.setValue((Object)newSecond);
        }
    }

    private void syncSecond(Integer astSecond) {
        Integer old = this.second;
        this.second = astSecond;
        this.firePropertyChanged("second", old, astSecond);
    }

    private Integer buildSecond(Annotation astAnnotation) {
        return (Integer)this.secondAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getSecondTextRange() {
        return this.secondTextRange;
    }

    private TextRange buildSecondTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.secondDeclarationAdapter, astAnnotation);
    }

    @Override
    public Integer getMillisecond() {
        return this.millisecond;
    }

    @Override
    public void setMillisecond(Integer millisecond) {
        if (ObjectTools.notEquals((Object)this.millisecond, (Object)millisecond)) {
            this.millisecond = millisecond;
            this.millisecondAdapter.setValue((Object)millisecond);
        }
    }

    private void syncMillisecond(Integer astMillisecond) {
        Integer oldMillisecond = this.millisecond;
        this.millisecond = astMillisecond;
        this.firePropertyChanged("millisecond", oldMillisecond, astMillisecond);
    }

    private Integer buildMillisecond(Annotation astAnnotation) {
        return (Integer)this.millisecondAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getMillisecondTextRange() {
        return this.millisecondTextRange;
    }

    private TextRange buildMillisecondTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.millisecondDeclarationAdapter, astAnnotation);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildHourAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "hour", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildMinuteAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "minute", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildSecondAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "second", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildMillisecondAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "millisecond", NumberIntegerExpressionConverter.instance());
    }
}

