/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.conformance.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.WSPluginMessages;
import org.eclipse.jst.ws.internal.conformance.IJavaWebServiceRuleEngine;
import org.eclipse.jst.ws.internal.conformance.JavaWebServiceRule;
import org.eclipse.osgi.util.NLS;

public class JAXRPCRule0003
extends JavaWebServiceRule {
    private Map methodNames_;
    private Set overloadedMethodNames_;
    private String serviceClassName_;

    public JAXRPCRule0003() {
        this.id_ = 3;
        this.namespace_ = "http://www.eclipse.org/webtools/org.eclipse.jst.ws/jaxrpc/1.1";
        this.name_ = null;
        this.description_ = null;
    }

    @Override
    public void init(IJavaWebServiceRuleEngine engine) {
        super.init(engine);
        this.methodNames_ = new HashMap();
        this.overloadedMethodNames_ = new HashSet();
    }

    @Override
    public void visitClass(IType jdtClass, Stack peanutTrail) {
        if (peanutTrail.size() == 0) {
            this.serviceClassName_ = jdtClass.getFullyQualifiedName();
        }
    }

    @Override
    public void visitMethod(IMethod jdtMethod, Stack peanutTrail) {
        if (peanutTrail.size() == 1) {
            try {
                String methodName = jdtMethod.getElementName();
                String firstParameterSignature = (String)this.methodNames_.get(methodName);
                String thisParameterSignature = this.flattenedSignatureOf(jdtMethod);
                if (thisParameterSignature != null) {
                    if (firstParameterSignature != null) {
                        if (!this.overloadedMethodNames_.contains(methodName) && !thisParameterSignature.equals(firstParameterSignature)) {
                            this.overloadedMethodNames_.add(methodName);
                            String message = NLS.bind((String)WSPluginMessages.MSG_JAXRPC11_RULE_0003, (Object)methodName, (Object)this.serviceClassName_);
                            this.statusList_.add(new Status(2, "org.eclipse.jst.ws", 0, message, null));
                        }
                    } else {
                        this.methodNames_.put(methodName, thisParameterSignature);
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private String flattenedSignatureOf(IMethod jdtMethod) throws JavaModelException {
        String[] signatures = this.engine_.getJDTResolver().getParameterTypeNames(jdtMethod);
        StringBuffer flattenedSignature = new StringBuffer();
        int s = 0;
        while (s < signatures.length) {
            flattenedSignature.append(signatures[s]).append(",");
            ++s;
        }
        return flattenedSignature.toString();
    }
}

