/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.utils;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.ws.internal.cxf.core.CXFCoreMessages;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFInstall;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public final class LaunchUtils {
    private LaunchUtils() {
    }

    public static IStatus launch(String[] runtimeClasspath, String className, String[] programArgs) {
        IStatus status = Status.OK_STATUS;
        try {
            IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
            IVMRunner vmRunner = vmInstall.getVMRunner("run");
            VMRunnerConfiguration vmRunnerConfiguration = new VMRunnerConfiguration(className, runtimeClasspath);
            vmRunnerConfiguration.setProgramArguments(programArgs);
            Launch launch = new Launch(null, "run", null);
            vmRunner.run(vmRunnerConfiguration, (ILaunch)launch, null);
            while (!launch.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    CXFCorePlugin.log(ie);
                }
            }
            IProcess[] processes = launch.getProcesses();
            String outputStream = processes[0].getStreamsProxy().getOutputStreamMonitor().getContents();
            if (outputStream != null && outputStream.length() > 0) {
                status = new Status(1, "org.eclipse.jst.ws.cxf.core", outputStream);
            }
        }
        catch (CoreException ce) {
            CXFCorePlugin.log(ce);
        }
        return status;
    }

    public static void launch(IJavaProject javaProject, String className, String[] programArgs) throws CoreException {
        if (CXFCorePlugin.getDefault().getJava2WSContext().getDefaultRuntimeLocation().equals("")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.ws.cxf.core", CXFCoreMessages.CXF_FACET_INSTALL_DELEGATE_RUNTIME_LOCATION_NOT_SET));
        }
        IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        if (vmInstall == null) {
            vmInstall = JavaRuntime.getDefaultVMInstall();
        }
        String installedVersion = CXFCorePlugin.getDefault().getCXFRuntimeVersion(javaProject.getProject());
        CXFInstall cxfInstall = CXFCorePlugin.getDefault().getJava2WSContext().getInstallations().get(installedVersion);
        if (cxfInstall.getLocation() == null) {
            StringBuilder builder = new StringBuilder("Default [" + installedVersion + "] CXF Installation has no location\n");
            Map<String, CXFInstall> installations = CXFCorePlugin.getDefault().getJava2WSContext().getInstallations();
            for (Map.Entry<String, CXFInstall> entry : installations.entrySet()) {
                builder.append("Known CXF Installation: " + entry.getKey() + " location :" + entry.getValue().getLocation());
            }
            CXFCorePlugin.logMessage(1, builder.toString());
        }
        IVMRunner vmRunner = vmInstall.getVMRunner("run");
        String[] runtimeClasspath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        VMRunnerConfiguration vmRunnerConfiguration = new VMRunnerConfiguration(className, runtimeClasspath);
        vmRunnerConfiguration.setProgramArguments(programArgs);
        if (vmInstall instanceof IVMInstall2) {
            boolean ltJava9;
            IVMInstall2 install2 = (IVMInstall2)vmInstall;
            String vers = install2.getJavaVersion();
            boolean java6OrGreater = LaunchUtils.compareJavaVersions(vers, "1.6") >= 0;
            boolean bl = ltJava9 = LaunchUtils.compareJavaVersions(vers, "9") < 0;
            if (java6OrGreater && ltJava9) {
                vmRunnerConfiguration.setVMArguments(new String[]{"-Djava.endorsed.dirs=" + cxfInstall.getLocation()});
            }
        }
        Launch launch = new Launch(null, "run", null);
        vmRunner.run(vmRunnerConfiguration, (ILaunch)launch, null);
        while (!launch.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                CXFCorePlugin.log(ie);
            }
        }
        IProcess[] processes = launch.getProcesses();
        String outputStream = processes[0].getStreamsProxy().getOutputStreamMonitor().getContents();
        LaunchUtils.logStream(outputStream, cxfInstall);
        String errorStream = processes[0].getStreamsProxy().getErrorStreamMonitor().getContents();
        LaunchUtils.logStream(errorStream, cxfInstall);
        LaunchUtils.logErrorStreamContents(errorStream, className);
    }

    private static int compareJavaVersions(String fromInstall, String target) {
        List all = JavaCore.getAllVersions();
        int targetIndex = all.indexOf(target);
        int fromInstallIndex = -1;
        int i = 0;
        while (i < all.size()) {
            String prefix = (String)all.get(i);
            if (fromInstall.startsWith(prefix)) {
                fromInstallIndex = i;
                break;
            }
            ++i;
        }
        return fromInstallIndex - targetIndex;
    }

    private static void logStream(String outputStream, CXFInstall cxfInstall) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        try {
            MessageConsole cxfConsole = LaunchUtils.getCXFConsole(cxfInstall);
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            if (workbenchWindow != null) {
                IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
                String console_view_id = "org.eclipse.ui.console.ConsoleView";
                IConsoleView consoleView = (IConsoleView)workbenchPage.showView(console_view_id);
                consoleView.display((IConsole)cxfConsole);
                IOConsoleOutputStream consoleOutputStream = cxfConsole.newOutputStream();
                consoleOutputStream.write(outputStream);
                consoleOutputStream.close();
            }
        }
        catch (PartInitException pie) {
            CXFCorePlugin.log(pie);
        }
        catch (IOException ioe) {
            CXFCorePlugin.log(ioe);
        }
    }

    private static MessageConsole getCXFConsole(CXFInstall cxfInstall) {
        ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = consolePlugin.getConsoleManager();
        IConsole[] existingConsoles = consoleManager.getConsoles();
        int i = 0;
        while (i < existingConsoles.length) {
            if (existingConsoles[i].getName().equals(String.valueOf(cxfInstall.getType()) + " " + cxfInstall.getVersion())) {
                return (MessageConsole)existingConsoles[i];
            }
            ++i;
        }
        MessageConsole cxfConsole = new MessageConsole(String.valueOf(cxfInstall.getType()) + " " + cxfInstall.getVersion(), CXFCorePlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.cxf.core", (String)"icons/view16/console_view.gif"));
        consoleManager.addConsoles(new IConsole[]{cxfConsole});
        return cxfConsole;
    }

    private static void logErrorStreamContents(String message, String className) {
        String toolName = className.substring(className.lastIndexOf(".") + 1, className.length());
        if (message != null && message.indexOf(String.valueOf(toolName) + " Error") != -1) {
            Status toolStatus = new Status(4, "org.eclipse.jst.ws.cxf.core", message);
            CXFCorePlugin.log((IStatus)toolStatus);
        }
    }
}

