/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.internal.BrowserFactoryImplTestGate;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.FixtureChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.StubListener;
import org.eclipse.wst.jsdt.chromium.internal.standalonev8.StandaloneVmImpl;
import org.eclipse.wst.jsdt.chromium.internal.transport.ChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.eclipse.wst.jsdt.chromium.internal.v8native.CallFrameImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FrameObject;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.V8ProtocolParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.SomeRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.DataWithRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsObjectBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsValueBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsVariableBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.SubpropertiesMirror;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.eclipse.wst.jsdt.chromium.tests.internal.JsonBuilderUtil;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsObjectImplTest {
    private ChromeStub messageResponder;
    private CallFrameImpl callFrame;
    private ValueMirror eventMirror;
    private final StubListener listener = new StubListener();

    @Before
    public void setUpBefore() throws Exception {
        this.messageResponder = new FixtureChromeStub();
        StandaloneVmImpl javascriptVm = BrowserFactoryImplTestGate.createStandalone(new FakeConnection(this.messageResponder), FakeConnection.HANDSHAKER);
        javascriptVm.attach((DebugEventListener)this.listener);
        this.listener.expectSuspendedEvent();
        this.messageResponder.sendSuspendedEvent();
        DebugContext debugContext = this.listener.getDebugContext();
        JSONObject valueObject = (JSONObject)JSONValue.parse((String)("{\"ref\":" + FixtureChromeStub.getNumber3Ref() + ",\"type\":\"number\",\"value\":3,\"text\":\"3\"}"));
        SomeRef someRef = V8ProtocolParserAccess.get().parseSomeRef(valueObject);
        DataWithRef dataWithRef = DataWithRef.fromSomeRef((SomeRef)someRef);
        SubpropertiesMirror.ListBased subpropertiesMirror = new SubpropertiesMirror.ListBased(new PropertyReference[]{new PropertyReference((Object)"x", dataWithRef), new PropertyReference((Object)"y", dataWithRef)});
        InternalContext internalContext = ContextBuilder.getInternalContextForTests((DebugContext)debugContext);
        this.eventMirror = internalContext.getValueLoader().addDataToMap(Long.valueOf(11L), JsValue.Type.TYPE_OBJECT, null, null, (SubpropertiesMirror)subpropertiesMirror);
        JSONObject jsonObject = JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("line", 12L), JsonBuilderUtil.jsonProperty("index", 0L), JsonBuilderUtil.jsonProperty("sourceLineText", ""), JsonBuilderUtil.jsonProperty("script", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("ref", (long)FixtureChromeStub.getScriptId()))), JsonBuilderUtil.jsonProperty("func", JsonBuilderUtil.jsonObject(JsonBuilderUtil.jsonProperty("name", "foofunction"))));
        FrameObject frameObject = V8ProtocolParserAccess.get().parseFrameObject(jsonObject);
        this.callFrame = new CallFrameImpl(frameObject, internalContext);
    }

    @Test
    public void testObjectData() throws Exception {
        JsObjectBase.Impl jsObject = new JsObjectBase.Impl((ValueLoader)this.callFrame.getInternalContext().getValueLoader(), this.eventMirror);
        Assert.assertNotNull((Object)jsObject.asObject());
        Assert.assertNull((Object)jsObject.asArray());
        Collection variables = jsObject.getProperties();
        Assert.assertEquals((long)2L, (long)variables.size());
        Iterator it = variables.iterator();
        JsVariableBase.Property firstVar = (JsVariableBase.Property)it.next();
        JsVariableBase.Property secondVar = (JsVariableBase.Property)it.next();
        HashSet<String> names = new HashSet<String>();
        names.add("x");
        names.add("y");
        names.remove(firstVar.getName());
        names.remove(secondVar.getName());
        Assert.assertEquals((long)0L, (long)names.size());
        JsValueBase firstVal = firstVar.getValue();
        JsValueBase secondVal = firstVar.getValue();
        Assert.assertEquals((Object)"3", (Object)firstVal.getValueString());
        Assert.assertEquals((Object)"3", (Object)secondVal.getValueString());
        Assert.assertNull((Object)firstVal.asObject());
        Assert.assertNull((Object)secondVal.asObject());
        JsVariable xProperty = jsObject.getProperty("x");
        Assert.assertEquals((Object)"x", (Object)xProperty.getName());
        JsVariable yProperty = jsObject.getProperty("y");
        Assert.assertEquals((Object)"y", (Object)yProperty.getName());
    }
}

