/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence;

import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsDefaultsCalculator;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;

public class JaxWsDefaultsCalculatorTest
extends MockObjectTestCase {
    private static final String METHOD_NAME = "method";
    private Mock<IWebMethod> webMethod;
    private JaxWsDefaultsCalculator defCalc = new JaxWsDefaultsCalculator();

    public void setUp() {
        this.webMethod = this.mock(IWebMethod.class);
        this.webMethod.stubs().method("getSoapBindingStyle").will(this.returnValue(SOAPBindingStyle.DOCUMENT));
        this.webMethod.stubs().method("getSoapBindingParameterStyle").will(this.returnValue(SOAPBindingParameterStyle.BARE));
        this.webMethod.stubs().method("getName").will(this.returnValue(METHOD_NAME));
    }

    public void testDefineSBStyleDefaultValue() {
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingStyle.DOCUMENT, (Object)this.defCalc.defineSBStyle(null));
        Mock ann = this.mock(IAnnotation.class);
        ann.stubs().method("getPropertyValue").will(this.returnValue(null));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingStyle.DOCUMENT, (Object)this.defCalc.defineSBStyle((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("Style.DOCUMENT"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingStyle.DOCUMENT, (Object)this.defCalc.defineSBStyle((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("SOAPBinding.Style.DOCUMENT"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingStyle.DOCUMENT, (Object)this.defCalc.defineSBStyle((IAnnotation)ann.proxy()));
    }

    public void testDefineSBStyle() {
        Mock ann = this.mock(IAnnotation.class);
        ann.stubs().method("getPropertyValue").will(this.returnValue("Style.RPC"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingStyle.RPC, (Object)this.defCalc.defineSBStyle((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("SOAPBinding.Style.RPC"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingStyle.RPC, (Object)this.defCalc.defineSBStyle((IAnnotation)ann.proxy()));
    }

    public void testDefineSBUseDefaultValue() {
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingUse.LITERAL, (Object)this.defCalc.defineSBUse(null));
        Mock ann = this.mock(IAnnotation.class);
        ann.stubs().method("getPropertyValue").will(this.returnValue(null));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingUse.LITERAL, (Object)this.defCalc.defineSBUse((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("Style.LITERAL"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingUse.LITERAL, (Object)this.defCalc.defineSBUse((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("SOAPBinding.Style.LITERAL"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingUse.LITERAL, (Object)this.defCalc.defineSBUse((IAnnotation)ann.proxy()));
    }

    public void testDefineSBUse() {
        Mock ann = this.mock(IAnnotation.class);
        ann.stubs().method("getPropertyValue").will(this.returnValue("Use.ENCODED"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingUse.ENCODED, (Object)this.defCalc.defineSBUse((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("SOAPBinding.Use.ENCODED"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingUse.ENCODED, (Object)this.defCalc.defineSBUse((IAnnotation)ann.proxy()));
    }

    public void testDefineSBParameterStyleDefaultValue() {
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingParameterStyle.WRAPPED, (Object)this.defCalc.defineSBParameterStyle(null));
        Mock ann = this.mock(IAnnotation.class);
        ann.stubs().method("getPropertyValue").will(this.returnValue(null));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingParameterStyle.WRAPPED, (Object)this.defCalc.defineSBParameterStyle((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("ParameterStyle.WRAPPED"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingParameterStyle.WRAPPED, (Object)this.defCalc.defineSBParameterStyle((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("SOAPBinding.ParameterStyle.WRAPPED"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingParameterStyle.WRAPPED, (Object)this.defCalc.defineSBParameterStyle((IAnnotation)ann.proxy()));
    }

    public void testDefineSBParameterStyle() {
        Mock ann = this.mock(IAnnotation.class);
        ann.stubs().method("getPropertyValue").will(this.returnValue("ParameterStyle.BARE"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingParameterStyle.BARE, (Object)this.defCalc.defineSBParameterStyle((IAnnotation)ann.proxy()));
        ann.stubs().method("getPropertyValue").will(this.returnValue("SOAPBinding.ParameterStyle.BARE"));
        JaxWsDefaultsCalculatorTest.assertEquals((Object)SOAPBindingParameterStyle.BARE, (Object)this.defCalc.defineSBParameterStyle((IAnnotation)ann.proxy()));
    }

    public void testCalcWebParamDefaultName() {
        JaxWsDefaultsCalculatorTest.assertEquals((String)METHOD_NAME, (String)this.defCalc.calcWebParamDefaultName((IWebMethod)this.webMethod.proxy(), 0));
        this.webMethod.stubs().method("getSoapBindingStyle").will(this.returnValue(SOAPBindingStyle.RPC));
        JaxWsDefaultsCalculatorTest.assertEquals((String)"arg0", (String)this.defCalc.calcWebParamDefaultName((IWebMethod)this.webMethod.proxy(), 0));
        this.webMethod.stubs().method("getSoapBindingStyle").will(this.returnValue(SOAPBindingStyle.DOCUMENT));
        this.webMethod.stubs().method("getSoapBindingParameterStyle").will(this.returnValue(SOAPBindingParameterStyle.WRAPPED));
        JaxWsDefaultsCalculatorTest.assertEquals((String)"arg1", (String)this.defCalc.calcWebParamDefaultName((IWebMethod)this.webMethod.proxy(), 1));
    }

    public void testCalcWebParamDefaultTargetNS() {
        Mock webParam = this.mock(IWebParam.class);
        this.webMethod.stubs().method("getSoapBindingParameterStyle").will(this.returnValue(SOAPBindingParameterStyle.WRAPPED));
        webParam.stubs().method("isHeader").will(this.returnValue(false));
        Mock sei = this.mock(IServiceEndpointInterface.class);
        sei.stubs().method("getTargetNamespace").will(this.returnValue("http://com.sap.test"));
        this.webMethod.stubs().method("eContainer").will(this.returnValue(sei.proxy()));
        JaxWsDefaultsCalculatorTest.assertEquals((String)"", (String)this.defCalc.calcWebParamDefaultTargetNS((IWebMethod)this.webMethod.proxy(), (IWebParam)webParam.proxy()));
        this.webMethod.stubs().method("getSoapBindingStyle").will(this.returnValue(SOAPBindingStyle.RPC));
        JaxWsDefaultsCalculatorTest.assertEquals((String)"http://com.sap.test", (String)this.defCalc.calcWebParamDefaultTargetNS((IWebMethod)this.webMethod.proxy(), (IWebParam)webParam.proxy()));
        this.webMethod.stubs().method("getSoapBindingStyle").will(this.returnValue(SOAPBindingStyle.DOCUMENT));
        this.webMethod.stubs().method("getSoapBindingParameterStyle").will(this.returnValue(SOAPBindingParameterStyle.BARE));
        JaxWsDefaultsCalculatorTest.assertEquals((String)"http://com.sap.test", (String)this.defCalc.calcWebParamDefaultTargetNS((IWebMethod)this.webMethod.proxy(), (IWebParam)webParam.proxy()));
        this.webMethod.stubs().method("getSoapBindingStyle").will(this.returnValue(SOAPBindingStyle.DOCUMENT));
        this.webMethod.stubs().method("getSoapBindingParameterStyle").will(this.returnValue(SOAPBindingParameterStyle.WRAPPED));
        webParam.stubs().method("isHeader").will(this.returnValue(true));
        JaxWsDefaultsCalculatorTest.assertEquals((String)"http://com.sap.test", (String)this.defCalc.calcWebParamDefaultTargetNS((IWebMethod)this.webMethod.proxy(), (IWebParam)webParam.proxy()));
    }

    public void testCalcWebResultDefaultName() {
        JaxWsDefaultsCalculatorTest.assertEquals((String)"methodResponse", (String)this.defCalc.calcWebResultDefaultName((IWebMethod)this.webMethod.proxy()));
        this.webMethod.stubs().method("getSoapBindingStyle").will(this.returnValue(SOAPBindingStyle.RPC));
        JaxWsDefaultsCalculatorTest.assertEquals((String)"return", (String)this.defCalc.calcWebResultDefaultName((IWebMethod)this.webMethod.proxy()));
        this.webMethod.stubs().method("getSoapBindingStyle").will(this.returnValue(SOAPBindingStyle.DOCUMENT));
        this.webMethod.stubs().method("getSoapBindingParameterStyle").will(this.returnValue(SOAPBindingParameterStyle.WRAPPED));
        JaxWsDefaultsCalculatorTest.assertEquals((String)"return", (String)this.defCalc.calcWebResultDefaultName((IWebMethod)this.webMethod.proxy()));
    }
}

