/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReference;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFVersion;

public abstract class AbstractJSFLibraryReferenceImpl
implements JSFLibraryReference {
    protected JSFLibraryInternalReference libRef;
    private String _id;
    private String _label;
    private boolean _isImplementation;
    private boolean _isDeloyed;

    public AbstractJSFLibraryReferenceImpl(String id, String label, boolean isImplementation) {
        this._id = id;
        this._label = label;
        this._isImplementation = isImplementation;
    }

    public AbstractJSFLibraryReferenceImpl(JSFLibraryInternalReference libRef, boolean isDeployed) {
        this.libRef = libRef;
        this._isDeloyed = isDeployed;
    }

    @Override
    public String getId() {
        if (this.libRef != null) {
            return this.libRef.getID();
        }
        return this._id;
    }

    @Override
    public String getLabel() {
        if (this.libRef != null) {
            return this.libRef.getLabel();
        }
        return this._label;
    }

    @Override
    public boolean isDeployed() {
        return this._isDeloyed;
    }

    @Override
    public boolean isJSFImplementation() {
        if (this.libRef != null) {
            return this.libRef.isImplementation();
        }
        return this._isImplementation;
    }

    protected JSFLibrary getLibrary() {
        return this.libRef.getLibrary();
    }

    @Override
    public Collection<IClasspathEntry> getJars() {
        HashSet<IClasspathEntry> results = new HashSet<IClasspathEntry>();
        if (this.getLibrary() != null) {
            EList jars = this.getLibrary().getArchiveFiles();
            for (ArchiveFile jar : jars) {
                String path = jar.getResolvedSourceLocation();
                results.add(JavaCore.newLibraryEntry((IPath)new Path(path), null, null));
            }
        }
        return results;
    }

    @Override
    public JSFVersion getMaxSupportedVersion() {
        if (this.getLibrary() != null) {
            return this.adaptVersion(this.getLibrary().getJSFVersion());
        }
        return null;
    }

    private JSFVersion adaptVersion(org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion version) {
        switch (version.getValue()) {
            case 1: {
                return JSFVersion.V1_1;
            }
            case 2: {
                return JSFVersion.V1_2;
            }
        }
        return JSFVersion.UNKNOWN;
    }

    @Override
    public String getName() {
        if (this.getLibrary() != null) {
            return this.getLibrary().getName();
        }
        return this.getId();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("id: ");
        buf.append(this.getId());
        buf.append(", label: ");
        buf.append(this.getLabel());
        buf.append(", isDeployed: ");
        buf.append(this.isDeployed());
        buf.append(", isImpl: ");
        buf.append(this.isJSFImplementation());
        buf.append(", version: ");
        buf.append(this.getMaxSupportedVersion().name());
        return buf.toString();
    }
}

