/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.ui.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSContext;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIMessages;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.Java2WSWidgetFactory;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class Java2WSConfigWidget
extends SimpleWidgetDataContributor {
    private IStatus WSDL_FILENAME_OK_STATUS = Status.OK_STATUS;
    private IStatus WSDL_FILENAME_ERROR_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.JAVA2WS_ENTER_VALID_WSDL_NAME);
    private Button generateClientButton;
    private Button generateServerButton;
    private Button generateWraperFaultBeansButton;
    private Button generateWSDLButton;
    private Combo soapBindingCombo;
    private Button createXSDImports;
    private Text wsdlFileText;
    private Java2WSDataModel model;

    public void setJava2WSDataModel(Java2WSDataModel model) {
        this.model = model;
    }

    public void internalize() {
        if (this.model.getDefaultRuntimeVersion().compareTo("2.1") >= 0) {
            this.generateClientButton.setSelection(this.model.isGenerateClient());
            this.generateServerButton.setSelection(this.model.isGenerateServer());
            this.generateWraperFaultBeansButton.setSelection(this.model.isGenerateWrapperFaultBeans());
            this.generateWSDLButton.setSelection(this.model.isGenerateWSDL());
            this.enableWSDLGroup(this.model.isGenerateWSDL());
        }
        if (this.model.isSoap12Binding()) {
            this.soapBindingCombo.setText("SOAP 1.2");
        } else {
            this.soapBindingCombo.setText("SOAP 1.1");
        }
        this.createXSDImports.setSelection(this.model.isGenerateXSDImports());
    }

    public WidgetDataEvents addControls(Composite parent, final Listener statusListener) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gridData);
        Group java2wsGroup = null;
        if (this.model.getDefaultRuntimeVersion().compareTo("2.1") >= 0) {
            java2wsGroup = new Group(composite, 4);
            java2wsGroup.setText(CXFCreationUIMessages.JAVA2WS_GROUP_LABEL);
            GridLayout java2wslayout = new GridLayout();
            java2wslayout.numColumns = 3;
            java2wslayout.marginHeight = 10;
            java2wsGroup.setLayout((Layout)java2wslayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            java2wsGroup.setLayoutData((Object)gridData);
            this.generateClientButton = Java2WSWidgetFactory.createGenerateClientButton((Composite)java2wsGroup, (Java2WSContext)this.model);
            this.generateServerButton = Java2WSWidgetFactory.createGenerateServerButton((Composite)java2wsGroup, (Java2WSContext)this.model);
            this.generateWraperFaultBeansButton = Java2WSWidgetFactory.createGenerateWrapperFaultBeanButton((Composite)java2wsGroup, (Java2WSContext)this.model);
            this.generateWSDLButton = Java2WSWidgetFactory.createGenerateWSDLButton((Composite)java2wsGroup, (Java2WSContext)this.model);
            this.generateWSDLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Java2WSConfigWidget.this.enableWSDLGroup(Java2WSConfigWidget.this.generateWSDLButton.getSelection());
                }
            });
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.generateWSDLButton.setLayoutData((Object)gridData);
        }
        Group wsdlGroup = new Group((Composite)(java2wsGroup == null ? composite : java2wsGroup), 16);
        GridLayout wsdlGroupLayout = new GridLayout(2, false);
        wsdlGroup.setLayout((Layout)wsdlGroupLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        wsdlGroup.setLayoutData((Object)gridData);
        Java2WSWidgetFactory.createWSDLFileNameLabel((Composite)wsdlGroup);
        this.wsdlFileText = Java2WSWidgetFactory.createWSDLFileNameText((Composite)wsdlGroup, (Java2WSDataModel)this.model);
        this.wsdlFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                statusListener.handleEvent(null);
            }
        });
        gridData = new GridData(4, 0x1000000, true, false);
        this.wsdlFileText.setLayoutData((Object)gridData);
        Java2WSWidgetFactory.createSOAPBindingLabel((Composite)wsdlGroup);
        this.soapBindingCombo = Java2WSWidgetFactory.createSOAPBingCombo((Composite)wsdlGroup, (Java2WSContext)this.model);
        gridData = new GridData(4, 0x1000000, true, false);
        this.soapBindingCombo.setLayoutData((Object)gridData);
        this.createXSDImports = Java2WSWidgetFactory.createXSDImportsButton((Composite)wsdlGroup, (Java2WSContext)this.model);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        this.createXSDImports.setLayoutData((Object)gridData);
        this.enableWSDLGroup(this.model.isGenerateWSDL());
        return this;
    }

    private void enableWSDLGroup(boolean enable) {
        this.wsdlFileText.setEnabled(enable);
        this.soapBindingCombo.setEnabled(enable);
        this.createXSDImports.setEnabled(enable);
    }

    public IStatus getStatus() {
        return this.getWSDLFileNameStatus();
    }

    private IStatus getWSDLFileNameStatus() {
        IStatus status = this.WSDL_FILENAME_OK_STATUS;
        String wsdlFileName = this.wsdlFileText.getText();
        if (!WSDLUtils.isValidWSDLFileName((String)wsdlFileName)) {
            status = this.WSDL_FILENAME_ERROR_STATUS;
        }
        return status;
    }
}

