/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.tests.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.html.core.internal.validation.HTMLValidator;
import org.eclipse.wst.html.ui.tests.ProjectUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class TestHTMLValidator
extends TestCase {
    private static final String PROJECT_NAME = "TestHTMLValidator";
    private static final String PROJECT_FILES = "/testresources/TestHTMLValidator";
    private static IProject fProject;
    private HTMLValidator fValidator = new HTMLValidator();

    public TestHTMLValidator() {
        super("Test HTMLValidator");
    }

    public TestHTMLValidator(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(TestHTMLValidator.class, "Test HTMLValidator");
        return new TestHTMLValidatorSetup((Test)ts);
    }

    public void testRemoveAndAddBackCommentEndTag() throws Exception {
        IFile testFile = null;
        IStructuredModel model = null;
        try {
            testFile = fProject.getFile("RemoveAndAddBackCommentEndTag.html");
            TestHTMLValidator.assertTrue((String)("Test file " + testFile + " does not exist"), (boolean)testFile.exists());
            model = StructuredModelManager.getModelManager().getModelForEdit(testFile);
            IStructuredDocument document = model.getStructuredDocument();
            WorkbenchContext context = new WorkbenchContext();
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(testFile.getFullPath().toPortableString());
            context.setValidationFileURIs(fileList);
            TestReporter reporter = new TestReporter();
            this.fValidator.validate((IValidationContext)context, (IReporter)reporter);
            TestHTMLValidator.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
            String contents = document.get();
            int endCommentIndex = contents.indexOf("-->");
            document.replace(endCommentIndex, 3, "");
            reporter = new TestReporter();
            this.fValidator.validate((IValidationContext)context, (IReporter)reporter);
            TestHTMLValidator.assertTrue((String)("There should be validation errors on " + testFile), (boolean)reporter.isMessageReported());
            document.replace(endCommentIndex, 0, "-->");
            reporter = new TestReporter();
            this.fValidator.validate((IValidationContext)context, (IReporter)reporter);
            TestHTMLValidator.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testExtendedValidator() throws Exception {
        IFile testFile = fProject.getFile("validCustomTags.html");
        this.performExternalValidatorTest(testFile, false);
        testFile = fProject.getFile("customTags.html");
        this.performExternalValidatorTest(testFile, true);
        testFile = fProject.getFile("invalidAttrTestFile.html");
        this.performExternalValidatorTest(testFile, true);
    }

    private void performExternalValidatorTest(IFile testFile, boolean errorExpected) throws IOException, CoreException {
        IStructuredModel model = null;
        try {
            TestHTMLValidator.assertTrue((String)("Test file " + testFile + " does not exist"), (boolean)testFile.exists());
            model = StructuredModelManager.getModelManager().getModelForEdit(testFile);
            WorkbenchContext context = new WorkbenchContext();
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(testFile.getFullPath().toPortableString());
            context.setValidationFileURIs(fileList);
            TestReporter reporter = new TestReporter();
            this.fValidator.validate((IValidationContext)context, (IReporter)reporter);
            if (errorExpected) {
                TestHTMLValidator.assertTrue((String)("There should be validation errors on " + testFile), (boolean)reporter.isMessageReported());
            } else {
                TestHTMLValidator.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testInvalidateTagNameThenFix() throws Exception {
        IFile testFile = null;
        IStructuredModel model = null;
        try {
            testFile = fProject.getFile("InvalidateTagNameThenFix.html");
            TestHTMLValidator.assertTrue((String)("Test file " + testFile + " does not exist"), (boolean)testFile.exists());
            model = StructuredModelManager.getModelManager().getModelForEdit(testFile);
            IStructuredDocument document = model.getStructuredDocument();
            WorkbenchContext context = new WorkbenchContext();
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(testFile.getFullPath().toPortableString());
            context.setValidationFileURIs(fileList);
            TestReporter reporter = new TestReporter();
            this.fValidator.validate((IValidationContext)context, (IReporter)reporter);
            TestHTMLValidator.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
            String contents = document.get();
            int endOfStartTagIndex = contents.indexOf("></div>");
            document.replace(endOfStartTagIndex, 0, "x");
            reporter = new TestReporter();
            this.fValidator.validate((IValidationContext)context, (IReporter)reporter);
            TestHTMLValidator.assertTrue((String)("There should be validation errors on " + testFile), (boolean)reporter.isMessageReported());
            document.replace(endOfStartTagIndex, 1, "");
            reporter = new TestReporter();
            this.fValidator.validate((IValidationContext)context, (IReporter)reporter);
            TestHTMLValidator.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private static class TestHTMLValidatorSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public TestHTMLValidatorSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            fProject = ProjectUtil.createProject(TestHTMLValidator.PROJECT_NAME, null, null);
            ProjectUtil.copyBundleEntriesIntoWorkspace(TestHTMLValidator.PROJECT_FILES, TestHTMLValidator.PROJECT_NAME);
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private class TestReporter
    implements IReporter {
        private boolean messageReported = false;

        public void addMessage(IValidator origin, IMessage message) {
            this.messageReported = true;
        }

        public boolean isMessageReported() {
            return this.messageReported;
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }

        public List getMessages() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }
    }
}

