/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.TestProgressMonitor;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class TypeHierarchyTests
extends ModifyingResourceTests {
    ITypeHierarchy typeHierarchy;

    public static Test suite() {
        return TypeHierarchyTests.buildModelTestSuite(TypeHierarchyTests.class);
    }

    public TypeHierarchyTests(String name) {
        super(name);
        this.displayName = true;
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("TypeHierarchy");
        this.addLibrary("myLib.jar", "myLibsrc.zip", new String[]{"my/pkg/X.js", "package my.pkg;\npublic class X {\n}", "my/pkg/Y.js", "package my.pkg;\npublic class Y {\n  void foo() {\n    new X() {};  }\n}"}, "1.4");
        IPackageFragmentRoot root = this.currentProject.getPackageFragmentRoot((IResource)this.currentProject.getProject().getFile("lib.jar"));
        IRegion region = JavaScriptCore.newRegion();
        region.add((IJavaScriptElement)root);
        this.typeHierarchy = this.currentProject.newTypeHierarchy(region, null);
        IJavaScriptProject project15 = this.createJavaProject("TypeHierarchy15", new String[]{"src"}, new String[]{"JCL15_LIB"}, "bin", "1.5");
        this.addLibrary(project15, "lib15.jar", "lib15src.zip", new String[]{"util/AbstractList.js", "package util;\npublic class AbstractList<E> {\n}", "util/ArrayList.js", "package util;\npublic class ArrayList<E> extends AbstractList<E> implements List<E> {\n}", "util/List.js", "package util;\npublic interface List<E> {\n}", "util/Map.js", "package util;\npublic class Map<K,V> extends AbstractList<V> {\n}"}, "1.5");
        this.createFile("/TypeHierarchy15/src/X.js", "import util.*;\npublic class X<E> extends ArrayList<E> implements List<E> {\n}");
        this.createFile("/TypeHierarchy15/src/Y.js", "import util.*;\npublic class Y extends ArrayList implements List {\n}");
        this.createFile("/TypeHierarchy15/src/I.js", "public interface I<E> {\n}");
        this.createFile("/TypeHierarchy15/src/A.js", "public class A<E> implements I<E> {\n}");
        this.createFile("/TypeHierarchy15/src/X99606.js", "public class X99606 extends Y99606<X99606.Color> {\n\tstatic class Color {}\n}");
        this.createFile("/TypeHierarchy15/src/Y99606.js", "public class Y99606<T> {\n}");
        this.createFile("/TypeHierarchy15/src/A108740.js", "class A108740<T> {}");
        this.createFile("/TypeHierarchy15/src/B108740.js", "class B108740<T> extends A108740<C108740> {}");
        this.createFile("/TypeHierarchy15/src/C108740.js", "class C108740 extends B108740<C108740> {}");
        this.createFile("/TypeHierarchy15/src/D108740.js", "class D108740 extends B108740<D108740> {}");
        this.createFile("/TypeHierarchy15/src/CycleParent.js", "class CycleParent extends CycleBase<CycleChild> {}");
        this.createFile("/TypeHierarchy15/src/CycleBase.js", "class CycleBase<T extends CycleBase> {}");
        this.createFile("/TypeHierarchy15/src/CycleChild.js", "class CycleChild extends CycleParent implements Comparable<CycleChild> {\n\tpublic int compareTo(CycleChild o) { return 0; }\n}");
        this.createFile("/TypeHierarchy15/src/Try.js", "public enum Try {\n    THIS,\n    THAT(),\n    ANONYMOUS() {}\n}");
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.typeHierarchy = null;
        this.deleteProject("TypeHierarchy");
        this.deleteProject("TypeHierarchy15");
        super.tearDownSuite();
    }

    public void testAnonymousType01() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getInitializer(1).getType("", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: <anonymous #1> [in <initializer #1> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testAnonymousType02() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getInitializer(2).getType("", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: <anonymous #1> [in <initializer #2> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testAnonymousType03() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getField("field1").getType("", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: <anonymous #1> [in field1 [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testAnonymousType04() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getField("field2").getType("", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: <anonymous #1> [in field2 [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
        type = typeA.getField("field2").getType("", 2);
        hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: <anonymous #2> [in field2 [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testAnonymousType05() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getFunction("foo", new String[0]).getType("", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: <anonymous #1> [in foo() [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testAnonymousType06() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p8", "X.js").getType("X");
        IType type = typeA.getFunction("foo", new String[0]).getType("", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: <anonymous #1> [in foo() [in X [in X.java [in p8 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p8 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testAnonymousType07() throws CoreException {
        IType type = this.getClassFile("TypeHierarchy", "myLib.jar", "my.pkg", "X.class").getType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] subtypes = hierarchy.getSubclasses(type);
        TypeHierarchyTests.assertEquals((String)"Unexpected key", (String)"Lmy/pkg/Y$1;", subtypes.length < 1 ? null : subtypes[0].getKey());
    }

    public void testAnonymousType08() throws CoreException {
        IType type = this.getCompilationUnit("TypeHierarchy15/src/Try.js").getType("Try");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Try [in Try.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  Enum [in Enum.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "    Comparable [in Comparable.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "    Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "    Serializable [in Serializable.class [in java.io [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n" + "  <anonymous #1> [in ANONYMOUS [in Try [in Try.java [in <default> [in src [in TypeHierarchy15]]]]]]\n", hierarchy);
    }

    public void testAnonymousType09() throws CoreException {
        IType type = this.getCompilationUnit("TypeHierarchy15/src/Try.js").getType("Try").getField("ANONYMOUS").getType("", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: <anonymous #1> [in ANONYMOUS [in Try [in Try.java [in <default> [in src [in TypeHierarchy15]]]]]]\nSuper types:\n  Try [in Try.java [in <default> [in src [in TypeHierarchy15]]]]\n    Enum [in Enum.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "      Comparable [in Comparable.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "      Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "      Serializable [in Serializable.class [in java.io [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testAnonymousType10() throws CoreException {
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy/src/q7/X.js");
        cu.open(null);
        IType type = cu.getType("X").getType("Member");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Member [in X [in X.java [in q7 [in src [in TypeHierarchy]]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n" + "  <anonymous #1> [in foo(X) [in Y [in X.java [in q7 [in src [in TypeHierarchy]]]]]]\n", hierarchy);
    }

    public void testBinaryInnerTypeGetSuperclass() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "Y$Inner.class");
        IType type = cf.getType();
        ITypeHierarchy h = type.newSupertypeHierarchy(null);
        IType superclass = h.getSuperclass(type);
        TypeHierarchyTests.assertTrue((String)"Superclass not found for Y$Inner", (superclass != null ? 1 : 0) != 0);
        TypeHierarchyTests.assertEquals((String)"Unexpected super class", (String)"Z", (String)superclass.getElementName());
    }

    public void testBinaryInWrongPackage() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[]{"JCL_LIB", "lib"});
            this.createFolder("/P/src/p");
            this.createFile("/P/src/p/X.js", "pakage p;\npublic class X {\n}");
            this.getProject("P").build(6, null);
            TypeHierarchyTests.waitForAutoBuild();
            this.getFile("/P/bin/p/X.class").copy((IPath)new Path("/P/lib/X.class"), false, null);
            ITypeHierarchy hierarchy = this.getClassFile("P", "/P/lib", "", "X.class").getType().newSupertypeHierarchy(null);
            this.assertHierarchyEquals("Focus: X [in X.class [in <default> [in lib [in P]]]]\nSuper types:\nSub types:\nRoot classes:\n", hierarchy);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testBinarySubclass() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy/src/p48459/p1/X48459.js").getType("X48459");
        ITypeHierarchy h = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: X48459 [in X48459.java [in p48459.p1 [in src [in TypeHierarchy]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n" + "  <anonymous #1> [in foo [in Z48459 [in Z48459.java [in p48459.p1 [in src [in TypeHierarchy]]]]]]\n" + "  Y48459 [in Y48459.class [in p48459.p2 [in lib48459 [in TypeHierarchy]]]]\n", h);
    }

    public void testBinaryTypeGetSuperclass() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "Y.class");
        IType type = cf.getType();
        ITypeHierarchy h = type.newSupertypeHierarchy(null);
        IType superclass = h.getSuperclass(type);
        TypeHierarchyTests.assertTrue((String)"Superclass not found forY", (superclass != null ? 1 : 0) != 0);
        TypeHierarchyTests.assertEquals((String)"Unexpected superclass of Y", (String)"X", (String)superclass.getElementName());
    }

    public void testBinaryTypeGetSuperclass2() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "Deep.class");
        IType type = cf.getType();
        ITypeHierarchy h = type.newSupertypeHierarchy(null);
        IType superclass = h.getSuperclass(type);
        TypeHierarchyTests.assertTrue((String)"Superclass not found for Deep", (superclass != null ? 1 : 0) != 0);
        TypeHierarchyTests.assertEquals((String)"Unexpected superclass of Deep", (String)"Z", (String)superclass.getElementName());
    }

    public void testBinaryTypeHiddenByOtherJar() throws CoreException, IOException {
        String externalJar1 = null;
        String externalJar2 = null;
        try {
            externalJar1 = String.valueOf(Util.getOutputDirectory()) + File.separator + "test1.jar";
            Util.createJar((String[])new String[]{"p/X.js", "package p;\npublic class X {\n}", "p/Y.js", "package p;\npublic class Y extends X {\n}"}, new HashMap(), (String)externalJar1);
            externalJar2 = String.valueOf(Util.getOutputDirectory()) + File.separator + "test2.jar";
            Util.createJar((String[])new String[]{"p/X.js", "package p;\npublic class X {\n}", "p/Y.js", "package p;\npublic class Y extends X {\n}"}, new HashMap(), (String)externalJar2);
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[]{"JCL_LIB", externalJar1, externalJar2});
            IType focus = project.getPackageFragmentRoot(externalJar2).getPackageFragment("p").getClassFile("Y.class").getType();
            this.assertHierarchyEquals("Focus: Y [in Y.class [in p [in " + externalJar2 + "]]]\n" + "Super types:\n" + "  X [in X.class [in p [in " + externalJar1 + "]]]\n" + "    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", focus.newTypeHierarchy(null));
        }
        catch (Throwable throwable) {
            if (externalJar1 != null) {
                Util.delete(externalJar1);
            }
            if (externalJar2 != null) {
                Util.delete(externalJar2);
            }
            this.deleteProject("P");
            throw throwable;
        }
        if (externalJar1 != null) {
            Util.delete((String)externalJar1);
        }
        if (externalJar2 != null) {
            Util.delete((String)externalJar2);
        }
        this.deleteProject("P");
    }

    public void testBinaryTypeInDotClassJar() throws CoreException, IOException {
        String externalJar = null;
        try {
            externalJar = String.valueOf(Util.getOutputDirectory()) + File.separator + "test.classic.jar";
            Util.createJar((String[])new String[]{"p/X.js", "package p;\npublic class X {\n}", "p/Y.js", "package p;\npublic class Y {\n  void foo() {\n    new X() {\n    };\n }\n}"}, new HashMap(), (String)externalJar);
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[]{"JCL_LIB", externalJar});
            IType focus = project.getPackageFragmentRoot(externalJar).getPackageFragment("p").getClassFile("X.class").getType();
            this.assertHierarchyEquals("Focus: X [in X.class [in p [in " + externalJar + "]]]\n" + "Super types:\n" + "  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n" + "  <anonymous> [in Y$1.class [in p [in " + externalJar + "]]]\n", focus.newTypeHierarchy(null));
        }
        catch (Throwable throwable) {
            if (externalJar != null) {
                Util.delete(externalJar);
            }
            this.deleteProject("P");
            throw throwable;
        }
        if (externalJar != null) {
            Util.delete((String)externalJar);
        }
        this.deleteProject("P");
    }

    public void testCancel() throws JavaScriptModelException {
        boolean isCanceled = false;
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p1", "X.js").getType("X");
        IRegion region = JavaScriptCore.newRegion();
        region.add((IJavaScriptElement)this.getPackageFragmentRoot("TypeHierarchy", "src"));
        try {
            TestProgressMonitor monitor = TestProgressMonitor.getInstance();
            monitor.setCancelledCounter(1);
            type.getJavaScriptProject().newTypeHierarchy(type, region, (IProgressMonitor)monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            isCanceled = true;
        }
        TypeHierarchyTests.assertTrue((String)"Operation should have thrown an operation canceled exception", (boolean)isCanceled);
    }

    public void testContains() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "X.class");
        IType type = cf.getType();
        TypeHierarchyTests.assertTrue((String)"X must be included", (boolean)this.typeHierarchy.contains(type));
        cf = this.getClassFile("TypeHierarchy", this.getSystemJsPathString(), "java.lang", "Object.class");
        type = cf.getType();
        TypeHierarchyTests.assertTrue((String)"Object must be included", (boolean)this.typeHierarchy.contains(type));
        cf = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "I.class");
        TypeHierarchyTests.assertTrue((String)"I must be included", (boolean)this.typeHierarchy.contains(type));
    }

    public void testCycle() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy/src/cycle/X.js").getType("X");
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        this.assertHierarchyEquals("Focus: X [in X.java [in cycle [in src [in TypeHierarchy]]]]\nSuper types:\n  Y [in Y.java [in cycle [in src [in TypeHierarchy]]]]\nSub types:\n", hierarchy);
    }

    public void testCycle2() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy15/src/CycleParent.js").getType("CycleParent");
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        this.assertHierarchyEquals("Focus: CycleParent [in CycleParent.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  CycleBase [in CycleBase.java [in <default> [in src [in TypeHierarchy15]]]]\n    Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testEfficiencyMultipleProjects() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL_LIB"});
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createJavaProject("P3", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFile("/P1/X.js", "public class X {}");
            this.createFile("/P3/Y.js", "public class Y extends X {}");
            this.createFile("/P3/Z.js", "public class Z extends X {}");
            this.createFile("/P2/W.js", "public class W extends X {}");
            IType type = this.getCompilationUnit("/P1/X.js").getType("X");
            class ProgressCounter
            extends TestProgressMonitor {
                int count = 0;

                ProgressCounter() {
                }

                @Override
                public boolean isCanceled() {
                    ++this.count;
                    return false;
                }
            }
            ProgressCounter counter = new ProgressCounter();
            type.newTypeHierarchy((IProgressMonitor)counter);
            TypeHierarchyTests.assertEquals((String)"Unexpected work count", (int)18, (int)counter.count);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2", "P3"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2", "P3"});
    }

    public void testEmptyWorkingCopyPotentialSubtype() throws JavaScriptModelException {
        IJavaScriptUnit workingCopy = null;
        try {
            workingCopy = this.getCompilationUnit("/TypeHierarchy/src/q4/Y.js");
            workingCopy.becomeWorkingCopy(null);
            workingCopy.getBuffer().setContents("");
            workingCopy.makeConsistent(null);
            IType type = this.getCompilationUnit("/TypeHierarchy/src/q4/X.js").getType("X");
            ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
            this.assertHierarchyEquals("Focus: X [in X.java [in q4 [in src [in TypeHierarchy]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
        }
        finally {
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
        }
    }

    public void testFocusWithLocalAndAnonymousTypes() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p7", "X.js").getType("X");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: X [in X.java [in p7 [in src [in TypeHierarchy]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n" + "  <anonymous #1> [in <initializer #2> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "    Y2 [in foo() [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "  <anonymous #1> [in field1 [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "  <anonymous #1> [in field2 [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "  <anonymous #1> [in foo() [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "  <anonymous #1> [in <initializer #1> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "  <anonymous #2> [in field2 [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "  Y1 [in foo() [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "    Y2 [in <initializer #1> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n" + "  Y1 [in <initializer #1> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n", hierarchy);
    }

    public void testGeneric01() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy15/src/X.js").getType("X");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: X [in X.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  ArrayList [in ArrayList.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n  List [in List.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n    AbstractList [in AbstractList.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n    List [in List.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n      Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testGeneric02() throws JavaScriptModelException {
        IType type = this.getPackageFragmentRoot("/TypeHierarchy15/lib15.jar").getPackageFragment("util").getClassFile("ArrayList.class").getType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: ArrayList [in ArrayList.class [in util [in lib15.jar [in TypeHierarchy15]]]]\nSuper types:\n  AbstractList [in AbstractList.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n  List [in List.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n    Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n" + "  X [in X.java [in <default> [in src [in TypeHierarchy15]]]]\n" + "  Y [in Y.java [in <default> [in src [in TypeHierarchy15]]]]\n", hierarchy);
    }

    public void testGeneric03() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy15/src/Y.js").getType("Y");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Y [in Y.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  ArrayList [in ArrayList.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n  List [in List.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n    AbstractList [in AbstractList.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n    List [in List.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n      Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testGeneric04() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy15/src/X.js").getType("X");
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        this.assertHierarchyEquals("Focus: X [in X.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  ArrayList [in ArrayList.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n  List [in List.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n    AbstractList [in AbstractList.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n    List [in List.class [in util [in lib15.jar [in TypeHierarchy15]]]]\n      Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testGeneric05() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy15/src/I.js").getType("I");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: I [in I.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\nSub types:\n  A [in A.java [in <default> [in src [in TypeHierarchy15]]]]\n", hierarchy);
    }

    public void testGeneric06() throws CoreException {
        this.getJavaProject("TypeHierarcht15").close();
        IType type = this.getClassFile("TypeHierarchy15", "lib15.jar", "util", "AbstractList.class").getType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] subtypes = hierarchy.getSubclasses(type);
        TypeHierarchyTests.assertEquals((String)"Unexpected key", (String)"Lutil/Map<TK;TV;>;", subtypes.length < 2 ? null : subtypes[1].getKey());
    }

    public void testGeneric07() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy15/src/Y99606.js").getType("Y99606");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Y99606 [in Y99606.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n" + "  X99606 [in X99606.java [in <default> [in src [in TypeHierarchy15]]]]\n", hierarchy);
    }

    public void testGeneric08() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy15/src/D108740.js").getType("D108740");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: D108740 [in D108740.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  B108740 [in B108740.java [in <default> [in src [in TypeHierarchy15]]]]\n    A108740 [in A108740.java [in <default> [in src [in TypeHierarchy15]]]]\n      Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testGeneric09() throws CoreException {
        try {
            this.createFile("/TypeHierarchy15/src/I1_136095.js", "public interface I1_136095<E> {\n}");
            this.createFile("/TypeHierarchy15/src/I2_136095.js", "public interface I2_136095 extends I1_136095<String>{\n}");
            this.createFile("/TypeHierarchy15/src/X_136095.js", "public abstract class X_136095 implements I1_136095<Integer>, I2_136095 {\n}");
            IType type = this.getCompilationUnit("/TypeHierarchy15/src/X_136095.js").getType("X_136095");
            ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
            this.assertHierarchyEquals("Focus: X_136095 [in X_136095.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  I1_136095 [in I1_136095.java [in <default> [in src [in TypeHierarchy15]]]]\n  I2_136095 [in I2_136095.java [in <default> [in src [in TypeHierarchy15]]]]\n    I1_136095 [in I1_136095.java [in <default> [in src [in TypeHierarchy15]]]]\n  Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n", hierarchy);
        }
        finally {
            this.deleteFile("/TypeHierarchy15/src/I1_136095.js");
            this.deleteFile("/TypeHierarchy15/src/I2_136095.js");
            this.deleteFile("/TypeHierarchy15/src/X_136095.js");
        }
    }

    public void testGeneric10() throws CoreException {
        try {
            this.createFile("/TypeHierarchy15/src/Y_140340.js", "public class Y_140340 {\n  public static class Z {\n  }\n}");
            this.createFile("/TypeHierarchy15/src/X_140340.js", "public class X_140340 implements I1_140340<Y_140340.Z> {\n}\ninterface I1_140340<T> {\n}");
            IType type = this.getCompilationUnit("/TypeHierarchy15/src/X_140340.js").getType("X_140340");
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            this.assertHierarchyEquals("Focus: X_140340 [in X_140340.java [in <default> [in src [in TypeHierarchy15]]]]\nSuper types:\n  I1_140340 [in X_140340.java [in <default> [in src [in TypeHierarchy15]]]]\n  Object [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Sub types:\n", hierarchy);
        }
        finally {
            this.deleteFile("/TypeHierarchy15/src/Y_140340.js");
            this.deleteFile("/TypeHierarchy15/src/X_140340.js");
        }
    }

    public void testGetAllClassesInRegion() {
        IType[] types = this.typeHierarchy.getAllClasses();
        this.assertTypesEqual("Unexpected all classes in hierarchy", "binary.Deep\nbinary.X\nbinary.Y\nbinary.Y$Inner\nbinary.Z\njava.lang.Object\nrich.A\nrich.B\nrich.C\n", types);
    }

    public void testGetAllSubtypes() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p1", "X.js").getType("X");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] types = hierarchy.getAllSubtypes(type);
        this.assertTypesEqual("Unexpected sub types of X", "p1.Deep\np1.Y\np1.Z\n", types);
    }

    public void testGetAllSubtypesFromBinary() throws JavaScriptModelException {
        IType type = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "X.class").getType();
        IRegion region = JavaScriptCore.newRegion();
        region.add((IJavaScriptElement)type.getPackageFragment());
        ITypeHierarchy hierarchy = type.getJavaScriptProject().newTypeHierarchy(type, region, null);
        IType[] types = hierarchy.getAllSubtypes(type);
        this.assertTypesEqual("Unexpected all subtypes of binary.X", "binary.Deep\nbinary.Y\nbinary.Y$Inner\nbinary.Z\n", types);
    }

    public void testGetAllSuperclasses() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p1", "Z.js").getType("Z");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] types = hierarchy.getAllSuperclasses(type);
        this.assertTypesEqual("Unexpected all super classes of Z", "java.lang.Object\np1.X\np1.Y\n", types);
    }

    public void testGetAllSuperclassesFromBinary() throws JavaScriptModelException {
        String fileName = "TypeHierarchy/lib53095/p53095/X53095.class";
        IJavaScriptElement javaElement = JavaScriptCore.create((IFile)this.getFile(fileName));
        TypeHierarchyTests.assertNotNull((String)("Problem to get class file \"" + fileName + "\""), (Object)javaElement);
        TypeHierarchyTests.assertTrue((String)("Invalid type for class file \"" + fileName + "\""), (boolean)(javaElement instanceof IClassFile));
        IType type = ((IClassFile)javaElement).getType();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] types = hierarchy.getAllSuperclasses(type);
        this.assertTypesEqual("Unexpected all super classes of X53095", "java.lang.RuntimeException\njava.lang.Exception\njava.lang.Throwable\njava.lang.Object\n", types, false);
    }

    public void testGetAllSuperclassesFromBinary2() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("TypeHierarchy", "test54043.jar", "p54043", "X54043.class");
        IType type = cf.getType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] types = hierarchy.getAllSuperclasses(type);
        this.assertTypesEqual("Unexpected all super classes of X54043", "java.lang.RuntimeException\njava.lang.Exception\njava.lang.Throwable\njava.lang.Object\n", types, false);
    }

    public void testGetAllSupertypes() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p1", "Z.js").getType("Z");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] types = hierarchy.getAllSuperclasses(type);
        this.assertTypesEqual("Unexpected all super types of Z", "java.lang.Object\np1.I1\np1.I2\np1.X\np1.Y\n", types);
    }

    public void testGetAllSupertypes2() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p3", "B.js").getType("B");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] types = hierarchy.getAllSuperclasses(type);
        this.assertTypesEqual("Unexpected all super types of B", "java.lang.Object\np3.A\np3.I\np3.I1\n", types);
    }

    public void testGetAllTypes() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p1", "Y.js").getType("Y");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertTypesEqual("Unexpected types in hierarchy of Y", "java.lang.Object\np1.Deep\np1.I1\np1.I2\np1.X\np1.Y\np1.Z\n", hierarchy.getAllClasses());
    }

    public void testGetCachedFlags() throws JavaScriptModelException {
        IType type1 = this.getClassFile("TypeHierarchy", "test60365.jar", "q4", "I1.class").getType();
        ITypeHierarchy hierarchy = type1.newTypeHierarchy(null);
        IType type2 = this.getClassFile("TypeHierarchy", "test60365.jar", "q4", "I2.class").getType();
        hierarchy.getCachedFlags(type2);
    }

    public void testGetRootClasses() {
        IType[] types = this.typeHierarchy.getRootClasses();
        this.assertTypesEqual("Unexpected root classes", "java.lang.Object\n", types);
    }

    public void testGetSubclasses() throws JavaScriptModelException {
        IType type = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "X.class").getType();
        IType[] types = this.typeHierarchy.getSubclasses(type);
        this.assertTypesEqual("Unexpected subclasses of binary.X", "binary.Y\n", types);
        type = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "I.class").getType();
        types = this.typeHierarchy.getSubclasses(type);
        this.assertTypesEqual("Unexpected subclasses of binary.I", "", types);
    }

    public void testGetSubtypes() throws JavaScriptModelException {
        IType type = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "X.class").getType();
        IType[] types = this.typeHierarchy.getSubclasses(type);
        this.assertTypesEqual("Unexpected subtypes of binary.X", "binary.Y\n", types);
        type = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "I.class").getType();
        types = this.typeHierarchy.getSubclasses(type);
        this.assertTypesEqual("Unexpected subtypes of binary.I", "binary.X\nbinary.Y$Inner\n", types);
    }

    public void testGetSuperclassInRegion() throws JavaScriptModelException {
        IRegion r = JavaScriptCore.newRegion();
        IPackageFragment p = this.getPackageFragment("TypeHierarchy", "src", "p1");
        r.add((IJavaScriptElement)p);
        ITypeHierarchy hierarchy = p.getJavaScriptProject().newTypeHierarchy(r, null);
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p1", "Y.js").getType("Y");
        IType superclass = hierarchy.getSuperclass(type);
        TypeHierarchyTests.assertEquals((String)"Unexpected super class of Y", (String)"X", (String)superclass.getElementName());
    }

    public void testGetSupertypesInRegion() throws JavaScriptModelException {
        IType type = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "Y.class").getType();
        IType superType = this.typeHierarchy.getSuperclass(type);
        this.assertTypesEqual("Unexpected super types of Y", "binary.X\n", new IType[]{superType});
    }

    public void testGetSupertypesWithProjectRegion() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchy");
        IRegion region = JavaScriptCore.newRegion();
        region.add((IJavaScriptElement)project);
        IType type = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "Y.class").getType();
        ITypeHierarchy hierarchy = project.newTypeHierarchy(type, region, null);
        IType superType = hierarchy.getSuperclass(type);
        this.assertTypesEqual("Unexpected super types of Y", "binary.X\n", new IType[]{superType});
    }

    public void testGetType() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("TypeHierarchy", "lib.jar", "binary", "Y.class");
        IType type = cf.getType();
        ITypeHierarchy hierarchy = null;
        try {
            hierarchy = type.newSupertypeHierarchy(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TypeHierarchyTests.assertTrue((String)"IllegalArgumentException", (boolean)false);
        }
        TypeHierarchyTests.assertEquals((String)"Unexpected focus type", (Object)type, (Object)hierarchy.getType());
        TypeHierarchyTests.assertTrue((String)"Unexpected focus type for hierarchy on region", (this.typeHierarchy.getType() == null ? 1 : 0) != 0);
    }

    public void testImplementBinaryInnerInterface() throws JavaScriptModelException {
        IClassFile cf = this.getClassFile("TypeHierarchy", "test58440.jar", "p58440", "Y.class");
        IType type = cf.getType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Y [in Y.class [in p58440 [in test58440.jar [in TypeHierarchy]]]]\nSuper types:\n  Inner [in X$Inner.class [in p58440 [in test58440.jar [in TypeHierarchy]]]]\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testInnerType1() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p5", "X.js").getType("X").getType("Inner");
        ITypeHierarchy hierarchy = null;
        try {
            hierarchy = type.newTypeHierarchy(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TypeHierarchyTests.assertTrue((String)"IllegalArgumentException", (boolean)false);
        }
        this.assertHierarchyEquals("Focus: Inner [in X [in X.java [in p5 [in src [in TypeHierarchy]]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testInnerType2() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p6", "A.js").getType("A").getType("Inner");
        ITypeHierarchy hierarchy = null;
        try {
            hierarchy = type.newTypeHierarchy(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TypeHierarchyTests.assertTrue((String)"IllegalArgumentException", (boolean)false);
        }
        this.assertHierarchyEquals("Focus: Inner [in A [in A.java [in p6 [in src [in TypeHierarchy]]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n" + "  B [in A.java [in p6 [in src [in TypeHierarchy]]]]\n", hierarchy);
    }

    public void testLocalType1() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getInitializer(1).getType("Y1", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Y1 [in <initializer #1> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n" + "  Y2 [in <initializer #1> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n", hierarchy);
    }

    public void testLocalType2() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getInitializer(2).getType("Y3", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Y3 [in <initializer #2> [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testLocalType3() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getFunction("foo", new String[0]).getType("Y2", 1);
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Y2 [in foo() [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  Y1 [in foo() [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\n    X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n      Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testLocalType4() throws JavaScriptModelException {
        IType typeA = this.getCompilationUnit("TypeHierarchy", "src", "p7", "A.js").getType("A");
        IType type = typeA.getFunction("foo", new String[0]).getType("Y1", 1);
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Y1 [in foo() [in A [in A.java [in p7 [in src [in TypeHierarchy]]]]]]\nSuper types:\n  X [in X.java [in p7 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testMemberTypeSubtypeDifferentProject() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFile("/P1/X.js", "public class X {\n  public class Member {\n  }\n}");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFile("/P2/Y.js", "public class Y extends X.Member {\n}");
            IType focus = this.getCompilationUnit("/P1/X.js").getType("X").getType("Member");
            ITypeHierarchy hierarchy = focus.newTypeHierarchy(null);
            this.assertHierarchyEquals("Focus: Member [in X [in X.java [in <default> [in <project root> [in P1]]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n" + "  Y [in Y.java [in <default> [in <project root> [in P2]]]]\n", hierarchy);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testMissingInterface() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("TypeHierarchy", "src", "p4", "X.js").getType("X");
        ITypeHierarchy hierarchy = null;
        try {
            hierarchy = type.newTypeHierarchy(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TypeHierarchyTests.assertTrue((String)"IllegalArgumentException", (boolean)false);
        }
        this.assertHierarchyEquals("Focus: X [in X.java [in p4 [in src [in TypeHierarchy]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }

    public void testPotentialSubtypeNotInClasspath() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchy");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy", "src", "p1", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        IType[] types = h.getSubclasses(type);
        this.assertTypesEqual("Unexpected sub types of X", "p1.Y\n", types);
    }

    public void testRegion1() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("TypeHierarchy", "src", "q1");
        IRegion region = JavaScriptCore.newRegion();
        region.add((IJavaScriptElement)pkg);
        ITypeHierarchy h = pkg.getJavaScriptProject().newTypeHierarchy(region, null);
        this.assertTypesEqual("Unexpected types in hierarchy", "java.lang.Object\nq1.X\nq1.Z\nq2.Y\n", h.getAllClasses());
    }

    public void testRegion2() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("TypeHierarchy", "src", "q2");
        IRegion region = JavaScriptCore.newRegion();
        region.add((IJavaScriptElement)pkg);
        ITypeHierarchy h = pkg.getJavaScriptProject().newTypeHierarchy(region, null);
        this.assertTypesEqual("Unexpected types in hierarchy", "java.lang.Object\nq1.X\nq2.Y\n", h.getAllClasses());
    }

    public void testRegion3() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("TypeHierarchy", "src", "p9");
        IRegion region = JavaScriptCore.newRegion();
        region.add((IJavaScriptElement)pkg);
        ITypeHierarchy h = pkg.getJavaScriptProject().newTypeHierarchy(region, null);
        this.assertTypesEqual("Unexpected types in hierarchy", "java.lang.Object\np9.X\np9.X$1\np9.X$Y\n", h.getAllClasses());
    }

    public void testRegion4() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1");
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            IJavaScriptProject p3 = this.createJavaProject("P3", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFile("/P1/X.js", "public class X {\n}");
            this.createFile("/P2/Y.js", "public class Y extends X X {\n}");
            this.createFile("/P3/Z.js", "public class Z extends X X {\n}");
            IRegion region = JavaScriptCore.newRegion();
            region.add((IJavaScriptElement)p1);
            region.add((IJavaScriptElement)p2);
            region.add((IJavaScriptElement)p3);
            ITypeHierarchy hierarchy = JavaScriptCore.newTypeHierarchy((IRegion)region, null, null);
            this.assertHierarchyEquals("Focus: <NONE>\nSub types of root classes:\n  Class [in Class.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "    Y [in Y.java [in <default> [in <project root> [in P2]]]]\n" + "    Z [in Z.java [in <default> [in <project root> [in P3]]]]\n" + "  String [in String.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "    Error [in Error.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "      CloneNotSupportedException [in CloneNotSupportedException.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "        IllegalMonitorStateException [in IllegalMonitorStateException.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "      InterruptedException [in InterruptedException.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "      RuntimeException [in RuntimeException.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "    Exception [in Exception.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "  Throwable [in Throwable.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "  X [in X.java [in <default> [in <project root> [in P1]]]]\n", hierarchy);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2", "P3"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2", "P3"});
    }

    public void testRegion_Bug150289() throws JavaScriptModelException {
        ITypeHierarchy h = this.currentProject.newTypeHierarchy(JavaScriptCore.newRegion(), null);
        TypeHierarchyTests.assertEquals((String)"Unexpected number of types in hierarchy", (int)0, (int)h.getAllClasses().length);
    }

    public void testResilienceToMissingBinaries() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[]{"JCL_LIB", "/TypeHierarchy/test144976.jar"});
            this.createFolder("/P/src/tools/");
            this.createFile("/P/src/tools/DisplayTestResult2.js", "pakage tools;\nimport servlet.*;\npublic class DisplayTestResult2 extends TmrServlet2 {\n}");
            this.createFolder("/P/src/servlet/");
            this.createFile("/P/src/servlet/TmrServlet2.js", "pakage servlet;\npublic class TmrServlet2 extends TmrServlet {\n}");
            this.createFile("/P/src/servlet/TmrServlet.js", "pakage servlet;\nimport gk.*;\npublic class TmrServlet extends GKServlet {\n}");
            IType type = this.getCompilationUnit("P", "src", "tools", "DisplayTestResult2.js").getType("DisplayTestResult2");
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            TypeHierarchyTests.assertNotNull((Object)hierarchy.getSuperclass(type));
            this.assertHierarchyEquals("Focus: DisplayTestResult2 [in DisplayTestResult2.java [in tools [in src [in P]]]]\nSuper types:\n  TmrServlet2 [in TmrServlet2.java [in servlet [in src [in P]]]]\n    TmrServlet [in TmrServlet.java [in servlet [in src [in P]]]]\n      GKServlet [in GKServlet.class [in gk [in /TypeHierarchy/test144976.jar [in P]]]]\nSub types:\n", hierarchy);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testResolvedTypeAsFocus() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
            String source = "public class X {\n  Y<String> field;\n}\nclass Y<E> {\n}";
            this.createFile("/P/X.js", source);
            int start = source.indexOf("Y");
            int end = source.indexOf("<String>");
            IJavaScriptElement[] elements = this.getCompilationUnit("/P/X.js").codeSelect(start, end - start);
            IType focus = (IType)elements[0];
            ITypeHierarchy hierarchy = focus.newTypeHierarchy(null);
            this.assertElementsEqual("Unexpected focus type in hierarchy", "Y [in X.java [in <default> [in <project root> [in P]]]]", new IJavaScriptElement[]{hierarchy.getType()}, true);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testRootOrder() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"abc"}, new String[]{"JCL_LIB"});
            this.createFolder("/P/abc/p");
            this.createFile("/P/abc/p/X.js", "package p;\npublic class X {}");
            this.createFile("/P/abc/p/Y.js", "package p;\npublic class Y extends X {}");
            this.addLibrary(project, "lib.jar", "libsrc.zip", new String[]{"p/X.js", "package p;\npublic class X {}", "p/Y.js", "package p;\npublic class Y extends X {}"}, "1.4");
            IType type = this.getCompilationUnit("/P/abc/p/X.js").getType("X");
            ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
            this.assertHierarchyEquals("Focus: X [in X.java [in p [in abc [in P]]]]\nSuper types:\n  Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n" + "  Y [in Y.java [in p [in abc [in P]]]]\n", hierarchy);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testSourceTypeGetSuperclass() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy", "src", "p1", "Y.js");
        IType type = cu.getType("Y");
        ITypeHierarchy h = type.newSupertypeHierarchy(null);
        IType superclass = h.getSuperclass(type);
        TypeHierarchyTests.assertTrue((String)"Superclass not found for Y", (superclass != null ? 1 : 0) != 0);
        TypeHierarchyTests.assertEquals((String)"Unexpected super class for Y", (String)"X", (String)superclass.getElementName());
    }

    public void testSourceTypeGetSuperclass2() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy", "src", "p1", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newSupertypeHierarchy(null);
        IType superclass = h.getSuperclass(type);
        TypeHierarchyTests.assertTrue((String)"Superclass not found for X", (superclass != null ? 1 : 0) != 0);
        TypeHierarchyTests.assertEquals((String)"Unexpected super class for X", (String)"Object", (String)superclass.getElementName());
    }

    public void testSourceTypeGetSuperclass3() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy", "src", "p1", "Deep.js");
        IType type = cu.getType("Deep");
        ITypeHierarchy h = type.newSupertypeHierarchy(null);
        IType superclass = h.getSuperclass(type);
        TypeHierarchyTests.assertTrue((String)"Superclass not found for Deep", (superclass != null ? 1 : 0) != 0);
        TypeHierarchyTests.assertEquals((String)"Unexpected super class for Deep", (String)"Z", (String)superclass.getElementName());
    }

    public void testSourceTypeGetSuperclass4() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy", "src", "p1", "A.js");
        IType type = cu.getType("A");
        ITypeHierarchy h = type.newSupertypeHierarchy(null);
        IType superclass = h.getSuperclass(type);
        TypeHierarchyTests.assertTrue((String)"Superclass not found for A", (superclass != null ? 1 : 0) != 0);
        TypeHierarchyTests.assertEquals((String)"Unexpected super class for A", (String)"B", (String)superclass.getElementName());
    }

    public void testSupertypeHierarchyGetSubclasses() throws JavaScriptModelException {
        IType type = this.getClassFile("TypeHierarchy", this.getSystemJsPathString(), "java.lang", "Object.class").getType();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] types = hierarchy.getSubclasses(type);
        this.assertTypesEqual("Unexpected subclasses of Object", "", types);
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy", "src", "p1", "Y.js");
        type = cu.getType("Y");
        hierarchy = type.newSupertypeHierarchy(null);
        types = hierarchy.getSubclasses(type);
        this.assertTypesEqual("Unexpected subclasses of Y", "", types);
    }

    public void testSupertypeHierarchyGetSubtypes() throws JavaScriptModelException {
        IType type = this.getClassFile("TypeHierarchy", this.getSystemJsPathString(), "java.lang", "Object.class").getType();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] types = hierarchy.getSubclasses(type);
        this.assertTypesEqual("Unexpected subtypes of Object", "", types);
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy", "src", "p1", "Y.js");
        type = cu.getType("Y");
        hierarchy = type.newSupertypeHierarchy(null);
        types = hierarchy.getSubclasses(type);
        this.assertTypesEqual("Unexpected subtypes of Y", "", types);
    }

    public void testSupertypeHierarchyOnWorkingCopy() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchy", "src", "wc", "X.js");
        IJavaScriptUnit workingCopy = null;
        try {
            workingCopy = cu.getWorkingCopy(null);
            workingCopy.createType("class B{\n\tvoid m(){\n\t}\n\tvoid f(){\n\t\tm();\n\t}\n}\n", null, true, null);
            workingCopy.createType("class A extends B{\n\tvoid m(){\n\t}\n}", null, true, null);
            IType typeA = workingCopy.getType("A");
            ITypeHierarchy hierarchy = typeA.newSupertypeHierarchy(null);
            IType typeB = workingCopy.getType("B");
            TypeHierarchyTests.assertTrue((String)"hierarchy should contain B", (boolean)hierarchy.contains(typeB));
        }
        finally {
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
        }
    }

    public void testSuperTypeHierarchyWithMissingBinary() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchy");
        IIncludePathEntry[] originalClasspath = project.getRawIncludepath();
        try {
            int length = originalClasspath.length;
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[length + 1];
            System.arraycopy(originalClasspath, 0, newClasspath, 0, length);
            newClasspath[length] = JavaScriptCore.newLibraryEntry((IPath)new Path("/TypeHierarchy/test49809.jar"), null, null);
            project.setRawIncludepath(newClasspath, null);
            IJavaScriptUnit cu = this.getCompilationUnit("/TypeHierarchy/src/q3/Z.js");
            IType type = cu.getType("Z");
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            this.assertHierarchyEquals("Focus: Z [in Z.java [in q3 [in src [in TypeHierarchy]]]]\nSuper types:\n  Y49809 [in Y49809.class [in p49809 [in test49809.jar [in TypeHierarchy]]]]\nSub types:\n", hierarchy);
        }
        finally {
            project.setRawIncludepath(originalClasspath, null);
        }
    }

    public void testVisibility1() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeHierarchy/src/q6/Y.js").getType("Y");
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        this.assertHierarchyEquals("Focus: Y [in Y.java [in q6 [in src [in TypeHierarchy]]]]\nSuper types:\n  NonVisibleClass [in X.java [in q5 [in src [in TypeHierarchy]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + "]]]\n" + "Sub types:\n", hierarchy);
    }
}

