/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jst.pagedesigner.dnd.internal.DesignerSourceDropTargetListener;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorDropTargetListener;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class DesignerStructuredTextEditorJSP
extends StructuredTextEditor {
    private ITextEditorDropTargetListener _dropTargetListener;
    private DropTarget _dropTarget;
    private IStructuredModel _structuredModel;
    private IModelStateListener _modelStateListener;

    protected void installTextDragAndDrop(ISourceViewer textViewer) {
    }

    protected void uninstallTextDragAndDrop(ISourceViewer viewer) {
    }

    protected void initializeDrop(ITextViewer viewer) {
        int operations = 3;
        this._dropTarget = new DropTarget((Control)viewer.getTextWidget(), operations);
        this._dropTargetListener = new DesignerSourceDropTargetListener(this);
        this._dropTarget.setTransfer(this._dropTargetListener.getTransfers());
        this._dropTarget.addDropListener((DropTargetListener)this._dropTargetListener);
    }

    public IAction getAction(String actionID) {
        try {
            return super.getAction(actionID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getAdapter(Class required) {
        if (ITextEditorDropTargetListener.class.equals((Object)required)) {
            DesignerSourceDropTargetListener listener = new DesignerSourceDropTargetListener(this);
            return listener;
        }
        return super.getAdapter(required);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.addModelStateListener();
    }

    public void dispose() {
        if (this._dropTargetListener != null) {
            this._dropTargetListener = null;
        }
        if (this._dropTarget != null) {
            this._dropTarget.dispose();
            this._dropTarget = null;
        }
        this.removeModelStateListener();
        if (this._structuredModel != null) {
            this._structuredModel.releaseFromRead();
            this._structuredModel = null;
        }
        super.dispose();
    }

    private IStructuredModel getStructuredModel() {
        IStructuredModel model = null;
        if (this._structuredModel != null) {
            model = this._structuredModel;
        } else {
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider != null) {
                IDocument document = provider.getDocument((Object)this.getEditorInput());
                model = this._structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            }
        }
        return model;
    }

    private void addModelStateListener() {
        IStructuredModel model = this.getStructuredModel();
        if (model != null) {
            if (this._modelStateListener == null) {
                this._modelStateListener = new ModelStateListener();
            } else {
                model.removeModelStateListener(this._modelStateListener);
            }
            model.addModelStateListener(this._modelStateListener);
        }
    }

    private void removeModelStateListener() {
        IStructuredModel model = this.getStructuredModel();
        if (model != null && this._modelStateListener != null) {
            model.removeModelStateListener(this._modelStateListener);
            this._modelStateListener = null;
        }
    }

    private class ModelStateListener
    implements IModelStateListener {
        private ModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelChanged(IStructuredModel model) {
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
            IFile file;
            if (isDirty && (file = StructuredModelUtil.getFileFor(model)) != null) {
                file.getWorkspace().validateEdit(new IFile[]{file}, null);
            }
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }
    }
}

