/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableLayout2;
import org.eclipse.jst.pagedesigner.css2.layout.table.CachedTableCellLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableCaptionInfo;

public class CSSTableCaptionLayout
extends CachedTableCellLayout {
    private CSSTableLayout2 _tableLayout;
    private TableCaptionInfo _caption;

    public CSSTableCaptionLayout(CSSFigure cssfigure) {
        super(cssfigure);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this._tableLayout = null;
        this._caption = null;
    }

    @Override
    public Rectangle getCellRect() {
        int vspacing;
        int x = 0;
        int[] rowHeights = this._tableLayout.getRowHeights();
        int y = vspacing = this._tableLayout.getVSpacing();
        if (this._caption != null && "bottom".equalsIgnoreCase(this._caption.getAlign())) {
            int row = 0;
            while (row < rowHeights.length) {
                y += rowHeights[row];
                y += vspacing;
                ++row;
            }
        }
        int height = 0;
        height = this._tableLayout.getCaptionSize().height;
        int width = this._tableLayout.getCaptionSize().width;
        Rectangle rect = new Rectangle(x, y, width, height);
        return rect;
    }

    public CSSTableLayout2 getTableLayoutContext() {
        LayoutManager parentLayout;
        IFigure parent = this.getCSSFigure().getParent();
        if (parent != null && (parentLayout = parent.getLayoutManager()) instanceof CSSTableLayout2) {
            return (CSSTableLayout2)parentLayout;
        }
        return null;
    }

    @Override
    public boolean initializeTableInfo() {
        this._caption = null;
        this._tableLayout = this.getTableLayoutContext();
        if (this._tableLayout != null) {
            this._caption = this._tableLayout.getCaptionInfo();
            return this._caption != null;
        }
        return false;
    }

    public CSSTableLayout2 getTableLayout() {
        return this._tableLayout;
    }

    @Override
    public boolean isCalculatingMaxWidth() {
        return false;
    }
}

