/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.tests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.util.JDTTypeResolver;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.tests.ContextSymbolTestPlugin;
import org.eclipse.jst.jsf.context.symbol.tests.ModelBaseTestCase;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.text.edits.TextEdit;

public class TestIJavaTypeDescriptor2_ChangeStability
extends ModelBaseTestCase {
    private static final IType[] EMPTY_SUPER_TYPES = new IType[0];
    private IBeanInstanceSymbol _testBean1Symbol;
    private IBeanInstanceSymbol _testBean2Symbol;
    private Map<String, IPropertySymbol> _beanProperties;
    private Map<String, IBeanMethodSymbol> _bean1Methods;
    private Map<String, IBeanMethodSymbol> _bean2Methods;
    private Map<String, IPropertySymbol> _bean2Properties;
    private static final String packageName1 = "com.test";
    private static final String testBeanName1 = "TestBean1";
    private static final String testBeanName2 = "TestBean2";
    private static final String NON_BEAN_METHOD_CONTENTS = "public String myActionSource(){return \"foo\";}";
    private static final String NON_BEAN_METHOD_SIG = Signature.createMethodSignature((String[])new String[0], (String)"Ljava.lang.String;");
    private static final String BEAN_PROPERTY_NAME = "anAddedStringProperty";
    private static final String BEAN_METHOD_NAME = "getAnAddedStringProperty";
    private static final String BEAN_METHOD_CONTENTS = "public String getAnAddedStringProperty() {return \"foo\";}";
    private static final String BEAN_METHOD_SIG;
    private static final String EXISTING_BEAN_PROPERTY_TO_REMOVE = "readonlyStringProperty";
    private static final String EXISTING_BEAN_METHOD = "getReadonlyStringProperty";
    private static final String EXISTING_BEAN_METHOD_SIG;
    private static final String NEW_READONLY_BEAN_PROP_NAME = "ADifferentReadonlyPropertyName";
    private static final String NEW_READONLY_BEAN_METHOD_NAME = "getADifferentReadonlyPropertyName";
    private static final String READONLY_BEAN_REPLACEMENT_METHOD = "public Integer getReadonlyStringProperty(){return new Integer(4);}";
    private static final String READONLY_BEAN_REPLACEMENT_SIG;
    private static final String WRITEONLY_BEAN_PROPERTY_NAME = "writeonlyStringProperty";
    private static final String WRITEONLY_BEAN_REPLACEMENT_METHOD_NAME = "setWriteonlyStringProperty";
    private static final String WRITEONLY_BEAN_REPLACMENT_CONTENTS = "public void setWriteonlyStringProperty(Integer newValue){}";
    private static final String EXISTING_BEAN_SETTER_METHOD_SIG;
    private static final String REPLACEMENT_BEAN_SETTER_METHOD_SIG;

    static {
        EXISTING_BEAN_METHOD_SIG = BEAN_METHOD_SIG = Signature.createMethodSignature((String[])new String[0], (String)"Ljava.lang.String;");
        READONLY_BEAN_REPLACEMENT_SIG = Signature.createMethodSignature((String[])new String[0], (String)"Ljava.lang.Integer;");
        EXISTING_BEAN_SETTER_METHOD_SIG = Signature.createMethodSignature((String[])new String[]{"Ljava.lang.String;"}, (String)"V");
        REPLACEMENT_BEAN_SETTER_METHOD_SIG = Signature.createMethodSignature((String[])new String[]{"Ljava.lang.Integer;"}, (String)"V");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.loadSourceClass(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/ITestBean2.java.data", packageName1, "ITestBean2");
        this.loadSourceClass(TestsPlugin.getDefault().getBundle(), "/testfiles/AnotherBean.java.data", packageName1, "AnotherBean");
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)this._jdtTestEnvironment.getJavaProject().findType("com.test.AnotherBean"));
        this._beanProperties = new HashMap<String, IPropertySymbol>();
        this._testBean1Symbol = this.setupBeanProperty(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1.java.data", packageName1, testBeanName1, this._beanProperties);
        this._bean1Methods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(this._bean1Methods, this._testBean1Symbol);
        this._bean2Methods = new HashMap<String, IBeanMethodSymbol>();
        this._testBean2Symbol = this.setupBeanMethods("/testdata/TestBean2.java.data", testBeanName2, this._bean2Methods);
        this._bean2Properties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean2Symbol, this._bean2Properties);
    }

    private IBeanInstanceSymbol setupBeanMethods(String fileName, String beanClassName, Map<String, IBeanMethodSymbol> methods) throws Exception {
        this.loadSourceClass(ContextSymbolTestPlugin.getDefault().getBundle(), fileName, packageName1, beanClassName);
        IType testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test." + beanClassName);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)testBean1Type);
        IJavaTypeDescriptor2 testBeanDescriptor = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        testBeanDescriptor.setType(testBean1Type);
        IBeanInstanceSymbol bean = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        bean.setTypeDescriptor((ITypeDescriptor)testBeanDescriptor);
        bean.setName(beanClassName);
        this.populateMethodMap(methods, bean);
        return bean;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._jdtTestEnvironment.getProjectEnvironment().getTestProject().delete(true, null);
    }

    public void testAddNonBeanMethod() throws Exception {
        IType type = this._testBean1Symbol.getJavaTypeDescriptor().getType();
        IMethod newMethod = type.createMethod(NON_BEAN_METHOD_CONTENTS, null, true, null);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)newMethod);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)NON_BEAN_METHOD_SIG, (String)this.resolveMethodSignature(type, newMethod));
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)newMethod.exists());
        HashMap<String, IBeanMethodSymbol> newMethods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(newMethods, this._testBean1Symbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)(this._bean1Methods.size() + 1), (int)newMethods.size());
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull(newMethods.remove("myActionSource"));
        this.compareMethodMaps(this._bean1Methods, newMethods);
        HashMap<String, IPropertySymbol> newProperties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean1Symbol, newProperties);
        this.compareSymbolMaps(this._beanProperties, newProperties);
    }

    public void testRemoveNonBeanMethod() throws Exception {
        IType type = this._testBean1Symbol.getJavaTypeDescriptor().getType();
        IMethod method = type.getMethod("get", new String[0]);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)method);
        method.delete(true, null);
        TestIJavaTypeDescriptor2_ChangeStability.assertFalse((boolean)method.exists());
        HashMap<String, IBeanMethodSymbol> newMethods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(newMethods, this._testBean1Symbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)(this._bean1Methods.size() - 1), (int)newMethods.size());
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((newMethods.get("get") == null ? 1 : 0) != 0);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)this._bean1Methods.remove("get"));
        this.compareMethodMaps(this._bean1Methods, newMethods);
        HashMap<String, IPropertySymbol> newProperties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean1Symbol, newProperties);
        this.compareSymbolMaps(this._beanProperties, newProperties);
    }

    public void testAddBeanMethod() throws Exception {
        IType type = this._testBean1Symbol.getJavaTypeDescriptor().getType();
        IMethod newMethod = type.createMethod(BEAN_METHOD_CONTENTS, null, true, null);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)newMethod);
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)newMethod.exists());
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)BEAN_METHOD_SIG, (String)this.resolveMethodSignature(type, newMethod));
        HashMap<String, IBeanMethodSymbol> newMethods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(newMethods, this._testBean1Symbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)(this._bean1Methods.size() + 1), (int)newMethods.size());
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull(newMethods.remove(BEAN_METHOD_NAME));
        this.compareMethodMaps(this._bean1Methods, newMethods);
        HashMap<String, IPropertySymbol> newProperties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean1Symbol, newProperties);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)(this._beanProperties.size() + 1), (int)newProperties.size());
        IPropertySymbol prop = (IPropertySymbol)newProperties.remove(BEAN_PROPERTY_NAME);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)"Ljava.lang.String;", (String)prop.getTypeDescriptor().getTypeSignature());
        this.compareSymbolMaps(this._beanProperties, newProperties);
    }

    public void testRemoveBeanMethod() throws Exception {
        IType type = this._testBean1Symbol.getJavaTypeDescriptor().getType();
        IMethod method = type.getMethod(EXISTING_BEAN_METHOD, new String[0]);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)method);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)EXISTING_BEAN_METHOD_SIG, (String)this.resolveMethodSignature(type, method));
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)method.exists());
        method.delete(true, null);
        TestIJavaTypeDescriptor2_ChangeStability.assertFalse((boolean)method.exists());
        HashMap<String, IBeanMethodSymbol> newMethods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(newMethods, this._testBean1Symbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)(this._bean1Methods.size() - 1), (int)newMethods.size());
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((newMethods.get(EXISTING_BEAN_METHOD) == null ? 1 : 0) != 0);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)this._bean1Methods.remove(EXISTING_BEAN_METHOD));
        this.compareMethodMaps(this._bean1Methods, newMethods);
        HashMap<String, IPropertySymbol> newProperties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean1Symbol, newProperties);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)(this._beanProperties.size() - 1), (int)newProperties.size());
        IPropertySymbol prop = this._beanProperties.remove(EXISTING_BEAN_PROPERTY_TO_REMOVE);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)"Ljava.lang.String;", (String)prop.getTypeDescriptor().getTypeSignature());
        this.compareSymbolMaps(this._beanProperties, newProperties);
    }

    public void testRenameBeanProperty() throws Exception {
        IType type = this._testBean1Symbol.getJavaTypeDescriptor().getType();
        IMethod method = type.getMethod(EXISTING_BEAN_METHOD, new String[0]);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)method);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)EXISTING_BEAN_METHOD_SIG, (String)this.resolveMethodSignature(type, method));
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)method.exists());
        method.rename(NEW_READONLY_BEAN_METHOD_NAME, false, null);
        method = type.getMethod(NEW_READONLY_BEAN_METHOD_NAME, new String[0]);
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)method.exists());
        HashMap<String, IBeanMethodSymbol> newMethods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(newMethods, this._testBean1Symbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)this._bean1Methods.size(), (int)newMethods.size());
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((newMethods.get(EXISTING_BEAN_METHOD) == null ? 1 : 0) != 0);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)this._bean1Methods.remove(EXISTING_BEAN_METHOD));
        IBeanMethodSymbol changedMethod = (IBeanMethodSymbol)newMethods.get(NEW_READONLY_BEAN_METHOD_NAME);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)BEAN_METHOD_SIG, (String)changedMethod.getSignature());
        this._bean1Methods.put(NEW_READONLY_BEAN_METHOD_NAME, changedMethod);
        this.compareMethodMaps(this._bean1Methods, newMethods);
        HashMap<String, IPropertySymbol> newProperties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean1Symbol, newProperties);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)this._beanProperties.size(), (int)newProperties.size());
        IPropertySymbol prop = (IPropertySymbol)newProperties.get(NEW_READONLY_BEAN_PROP_NAME);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)prop);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)"Ljava.lang.String;", (String)prop.getTypeDescriptor().getTypeSignature());
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)this._beanProperties.remove(EXISTING_BEAN_PROPERTY_TO_REMOVE));
        this._beanProperties.put(prop.getName(), prop);
        this.compareSymbolMaps(this._beanProperties, newProperties);
    }

    public void testChangeTypeOfGetter() throws Exception {
        IType type = this._testBean1Symbol.getJavaTypeDescriptor().getType();
        IMethod method = type.getMethod(EXISTING_BEAN_METHOD, new String[0]);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)method);
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)method.exists());
        method.delete(true, null);
        TestIJavaTypeDescriptor2_ChangeStability.assertFalse((boolean)method.exists());
        type.createMethod(READONLY_BEAN_REPLACEMENT_METHOD, null, true, null);
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)method.exists());
        HashMap<String, IBeanMethodSymbol> newMethods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(newMethods, this._testBean1Symbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)this._bean1Methods.size(), (int)newMethods.size());
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull(newMethods.get(EXISTING_BEAN_METHOD));
        IBeanMethodSymbol methodSymbol = this._bean1Methods.remove(EXISTING_BEAN_METHOD);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)methodSymbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)EXISTING_BEAN_METHOD_SIG, (String)methodSymbol.getSignature());
        methodSymbol = (IBeanMethodSymbol)newMethods.get(EXISTING_BEAN_METHOD);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)methodSymbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)READONLY_BEAN_REPLACEMENT_SIG, (String)methodSymbol.getSignature());
        this._bean1Methods.put(EXISTING_BEAN_METHOD, methodSymbol);
        this.compareMethodMaps(this._bean1Methods, newMethods);
        HashMap<String, IPropertySymbol> newProperties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean1Symbol, newProperties);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)this._beanProperties.size(), (int)newProperties.size());
        IPropertySymbol prop = this._beanProperties.remove(EXISTING_BEAN_PROPERTY_TO_REMOVE);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)"Ljava.lang.String;", (String)prop.getTypeDescriptor().getTypeSignature());
        prop = (IPropertySymbol)newProperties.get(EXISTING_BEAN_PROPERTY_TO_REMOVE);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)"Ljava.lang.Integer;", (String)prop.getTypeDescriptor().getTypeSignature());
        this._beanProperties.put(EXISTING_BEAN_PROPERTY_TO_REMOVE, prop);
        this.compareSymbolMaps(this._beanProperties, newProperties);
    }

    public void testChangeTypeOfSetter() throws Exception {
        IType type = this._testBean1Symbol.getJavaTypeDescriptor().getType();
        IMethod method = type.getMethod(WRITEONLY_BEAN_REPLACEMENT_METHOD_NAME, new String[]{"QString;"});
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)method);
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)method.exists());
        method.delete(true, null);
        TestIJavaTypeDescriptor2_ChangeStability.assertFalse((boolean)method.exists());
        method = type.createMethod(WRITEONLY_BEAN_REPLACMENT_CONTENTS, null, true, null);
        TestIJavaTypeDescriptor2_ChangeStability.assertTrue((boolean)method.exists());
        HashMap<String, IBeanMethodSymbol> newMethods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(newMethods, this._testBean1Symbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)this._bean1Methods.size(), (int)newMethods.size());
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull(newMethods.get(WRITEONLY_BEAN_REPLACEMENT_METHOD_NAME));
        IBeanMethodSymbol methodSymbol = this._bean1Methods.remove(WRITEONLY_BEAN_REPLACEMENT_METHOD_NAME);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)methodSymbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)EXISTING_BEAN_SETTER_METHOD_SIG, (String)methodSymbol.getSignature());
        methodSymbol = (IBeanMethodSymbol)newMethods.get(WRITEONLY_BEAN_REPLACEMENT_METHOD_NAME);
        TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)methodSymbol);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)REPLACEMENT_BEAN_SETTER_METHOD_SIG, (String)methodSymbol.getSignature());
        this._bean1Methods.put(WRITEONLY_BEAN_REPLACEMENT_METHOD_NAME, methodSymbol);
        this.compareMethodMaps(this._bean1Methods, newMethods);
        HashMap<String, IPropertySymbol> newProperties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean1Symbol, newProperties);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)this._beanProperties.size(), (int)newProperties.size());
        IPropertySymbol prop = this._beanProperties.remove(WRITEONLY_BEAN_PROPERTY_NAME);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)"Ljava.lang.String;", (String)prop.getTypeDescriptor().getTypeSignature());
        prop = (IPropertySymbol)newProperties.get(WRITEONLY_BEAN_PROPERTY_NAME);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)"Ljava.lang.Integer;", (String)prop.getTypeDescriptor().getTypeSignature());
        this._beanProperties.put(WRITEONLY_BEAN_PROPERTY_NAME, prop);
        this.compareSymbolMaps(this._beanProperties, newProperties);
    }

    public void testAddSuperType() throws Exception {
        IType type = this._testBean1Symbol.getJavaTypeDescriptor().getType();
        this.changeSuperType(type, this._testBean2Symbol.getJavaTypeDescriptor().getType());
        HashMap<String, IBeanMethodSymbol> newMethods = new HashMap<String, IBeanMethodSymbol>();
        this.populateMethodMap(newMethods, this._testBean1Symbol);
        HashMap<String, IBeanMethodSymbol> mergedMethodMap = new HashMap<String, IBeanMethodSymbol>();
        mergedMethodMap.putAll(this._bean1Methods);
        mergedMethodMap.putAll(this._bean2Methods);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)mergedMethodMap.size(), (int)newMethods.size());
        this.compareMethodMaps(mergedMethodMap, newMethods);
        HashMap<String, IPropertySymbol> newProperties = new HashMap<String, IPropertySymbol>();
        this.populatePropertyMap(this._testBean1Symbol, newProperties);
        HashMap<String, IPropertySymbol> mergedSymbolMap = new HashMap<String, IPropertySymbol>();
        mergedSymbolMap.putAll(this._beanProperties);
        mergedSymbolMap.putAll(this._bean2Properties);
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)mergedSymbolMap.size(), (int)newProperties.size());
        this.compareSymbolMaps(mergedSymbolMap, newProperties);
    }

    private void populateMethodMap(Map<String, IBeanMethodSymbol> methods, IBeanInstanceSymbol bean) {
        EList methodList = bean.getMethods();
        for (IBeanMethodSymbol method : methodList) {
            methods.put(method.getName(), method);
        }
    }

    private void compareSymbolMaps(Map<String, ? extends IObjectSymbol> expected, Map<String, ? extends IObjectSymbol> actual) {
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)expected.size(), (int)actual.size());
        for (String name : actual.keySet()) {
            ITypeDescriptor expectedTypeDesc = expected.get(name).getTypeDescriptor();
            ITypeDescriptor actualTypeDesc = actual.get(name).getTypeDescriptor();
            this.assertTypeDescriptorsSame(expectedTypeDesc, actualTypeDesc);
        }
    }

    private void compareMethodMaps(Map<String, ? extends IMethodSymbol> expected, Map<String, ? extends IMethodSymbol> actual) {
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((int)expected.size(), (int)actual.size());
        for (String name : actual.keySet()) {
            TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)expected.get(name).getSignature(), (String)actual.get(name).getSignature());
        }
    }

    private void assertTypeDescriptorsSame(ITypeDescriptor expectedTypeDesc, ITypeDescriptor actualTypeDesc) {
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((String)expectedTypeDesc.getTypeSignature(), (String)actualTypeDesc.getTypeSignature());
        if (expectedTypeDesc.getArrayElement() != null) {
            TestIJavaTypeDescriptor2_ChangeStability.assertNotNull((Object)actualTypeDesc.getArrayElement());
            this.assertTypeDescriptorsSame(expectedTypeDesc.getArrayElement().getTypeDescriptor(), actualTypeDesc.getArrayElement().getTypeDescriptor());
        } else {
            TestIJavaTypeDescriptor2_ChangeStability.assertNull((Object)actualTypeDesc.getArrayElement());
        }
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((Object)expectedTypeDesc.getInterfaceTypeSignatures(), (Object)actualTypeDesc.getInterfaceTypeSignatures());
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((Object)expectedTypeDesc.getSuperTypeSignatures(), (Object)actualTypeDesc.getSuperTypeSignatures());
        TestIJavaTypeDescriptor2_ChangeStability.assertEquals((Object)expectedTypeDesc.getTypeParameterSignatures(), (Object)actualTypeDesc.getTypeParameterSignatures());
    }

    private void changeSuperType(IType type, IType newSuperType) throws Exception {
        ICompilationUnit cu = type.getCompilationUnit().getWorkingCopy(null);
        CompilationUnit astRoot = this.createASTAndStartRecording(cu);
        TypeDeclaration typeDeclaration = (TypeDeclaration)astRoot.types().get(0);
        AST ast = typeDeclaration.getAST();
        Name superName = ast.newName(newSuperType.getFullyQualifiedName());
        SimpleType superType = ast.newSimpleType(superName);
        typeDeclaration.setSuperclassType((Type)superType);
        this.commitAST(cu, astRoot);
    }

    private CompilationUnit createASTAndStartRecording(ICompilationUnit cu) throws Exception {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        CompilationUnit astRoot = (CompilationUnit)parser.createAST(null);
        astRoot.recordModifications();
        return astRoot;
    }

    private void commitAST(ICompilationUnit cu, CompilationUnit astRoot) throws Exception {
        String source = cu.getBuffer().getContents();
        Document document = new Document(source);
        TextEdit edits = astRoot.rewrite((IDocument)document, cu.getJavaProject().getOptions(true));
        edits.apply((IDocument)document);
        String newSource = document.get();
        cu.getBuffer().setContents(newSource);
        cu.commitWorkingCopy(true, null);
    }

    private String resolveMethodSignature(IType type, IMethod method) throws JavaModelException {
        return new JDTTypeResolver(type, EMPTY_SUPER_TYPES).resolveMethodEraseTypeParams(method.getSignature());
    }
}

