/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views.model.jsp;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jst.jsf.common.internal.policy.IIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.policy.IdentifierOrderedIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.strategy.IIdentifiableStrategy;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.CompositeTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.DefaultJSPTagResolver;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.ITagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDNamespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TagIntrospectingStrategy;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.BaseTestClass;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.TestUtil;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.VerifyRegistryUtil;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;

public class TestTLDNamespace
extends BaseTestClass {
    private TLDNamespace _coreNS;
    private TLDNamespace _htmlNS;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ArrayList<String> policies = new ArrayList<String>();
        policies.add("org.eclipse.jst.jsf.metadata.DefaultJSPTagResolver");
        policies.add("org.eclipse.jst.jsf.designtime.TagIntrospectingStrategy");
        IdentifierOrderedIteratorPolicy idOrderedPolicy = new IdentifierOrderedIteratorPolicy(policies);
        CompositeTagResolvingStrategy compStrategy = new CompositeTagResolvingStrategy((IIteratorPolicy)idOrderedPolicy);
        compStrategy.addStrategy((IIdentifiableStrategy)new TagIntrospectingStrategy(this._webProjectTestEnv.getTestProject()));
        compStrategy.addStrategy((IIdentifiableStrategy)new DefaultJSPTagResolver(this._webProjectTestEnv.getTestProject()));
        TLDDocument coreDoc = TestUtil.getDocument((ITaglibRecord)this._tagRecords.get("http://java.sun.com/jsf/core"));
        this._coreNS = new TLDNamespace(coreDoc, (ITagResolvingStrategy)compStrategy);
        TLDDocument htmlDoc = TestUtil.getDocument((ITaglibRecord)this._tagRecords.get("http://java.sun.com/jsf/html"));
        this._htmlNS = new TLDNamespace(htmlDoc, (ITagResolvingStrategy)compStrategy);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetNSUri() {
        TestTLDNamespace.assertEquals((String)"http://java.sun.com/jsf/core", (String)this._coreNS.getNSUri());
        TestTLDNamespace.assertEquals((String)"http://java.sun.com/jsf/html", (String)this._htmlNS.getNSUri());
    }

    public void testGetViewElements() {
        Map<String, ITagElement> coreElements = TestUtil.constructTagElements(this._coreNS.getViewElements());
        if (this._jsfVersion == JSFVersion.V1_2) {
            VerifyRegistryUtil.runVerifiers(VerifyRegistryUtil.CORE_VERIFIERS_12, coreElements);
        } else {
            VerifyRegistryUtil.runVerifiers(VerifyRegistryUtil.CORE_VERIFIERS_11, coreElements);
        }
        Map<String, ITagElement> htmlElements = TestUtil.constructTagElements(this._htmlNS.getViewElements());
        VerifyRegistryUtil.runVerifiers(VerifyRegistryUtil.HTML_VERIFIERS, htmlElements);
    }
}

