/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tableedit;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.jst.pagedesigner.editpolicies.ITableEditAdapter;
import org.eclipse.jst.pagedesigner.tableedit.ColumnHandle;
import org.eclipse.jst.pagedesigner.tableedit.ColumnResizeHandle;
import org.eclipse.jst.pagedesigner.tableedit.TableColumnHandle;
import org.eclipse.jst.pagedesigner.tableedit.TableEditHelper;

public class TableColumnHandleLocator
extends MoveHandleLocator {
    GraphicalEditPart _tablePart;

    public TableColumnHandleLocator(GraphicalEditPart tablePart) {
        super(tablePart.getFigure());
        this._tablePart = tablePart;
    }

    public void relocate(IFigure target) {
        Rectangle bounds = this.getReference() instanceof HandleBounds ? ((HandleBounds)this.getReference()).getHandleBounds() : this.getReference().getBounds();
        Insets referenceInsets = this.getReference().getInsets();
        Rectangle r = new Rectangle(bounds.x + referenceInsets.left, bounds.y + bounds.height, bounds.width - referenceInsets.getWidth(), 10);
        this.getReference().translateToAbsolute((Translatable)r);
        target.translateToRelative((Translatable)r);
        target.setBounds(r);
        this.relocateChildren(target, this.getReference());
    }

    private void relocateChildren(IFigure target, IFigure reference) {
        TableColumnHandle tableColumnHandle = (TableColumnHandle)target;
        tableColumnHandle.removeAll();
        tableColumnHandle.setupColumns();
        List children = target.getChildren();
        ITableEditAdapter tableAdapter = TableEditHelper.getTableEditAdapter(this._tablePart);
        if (tableAdapter == null) {
            return;
        }
        int i = 0;
        int size = children.size();
        while (i < size) {
            Rectangle rect = null;
            IFigure child = (IFigure)children.get(i);
            if (child instanceof ColumnHandle) {
                ColumnHandle columnHandle = (ColumnHandle)child;
                columnIndex = columnHandle.getIndex();
                rect = new Rectangle(tableAdapter.getColumnStart(columnIndex), 0, tableAdapter.getColumnWidth(columnIndex), 10);
            } else if (child instanceof ColumnResizeHandle) {
                ColumnResizeHandle resizeHandle = (ColumnResizeHandle)child;
                columnIndex = resizeHandle.getColumnIndex();
                rect = new Rectangle(tableAdapter.getColumnResizeStart(columnIndex), 0, tableAdapter.getColumnResizeWidth(), 10);
            }
            if (rect != null) {
                child.setBounds(rect);
            }
            ++i;
        }
    }
}

