/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.jst.pagedesigner.commands.single.ChangeStyleCommand;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.BlockBox;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.editpolicies.AbsolutePointLocator;
import org.eclipse.jst.pagedesigner.editpolicies.BasicLabelToolTip;
import org.eclipse.jst.pagedesigner.editpolicies.FragmentHandle;
import org.eclipse.jst.pagedesigner.editpolicies.IEnhancedSelectionEditPolicy;
import org.eclipse.jst.pagedesigner.editpolicies.MouseSelectableChildDecorator;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.requests.LocationModifierRequest;
import org.eclipse.jst.pagedesigner.tools.ObjectModeDragTracker;
import org.eclipse.jst.pagedesigner.tools.RangeDragTracker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementResizableEditPolicy
extends ResizableEditPolicy
implements IEnhancedSelectionEditPolicy {
    private static final Insets INSETS_1 = new Insets(1, 1, 1, 1);
    private static final int THRESHHOLD = 3;
    private static final int TOOLTIP_VERTICAL_OFFSET = 25;
    private static final Insets INSETS_CONST = new Insets(3, 3, 3, 3);
    private boolean _showLabelFeedback = true;
    private IFigure[] _hoverFeedbackFigure;
    private MouseSelectableChildDecorator _nonVisualChildDecorator;
    private static final Color HOVER_FEEDBACK_COLOR = ColorConstants.blue;

    public void deactivate() {
        super.deactivate();
        if (this._nonVisualChildDecorator != null) {
            this._nonVisualChildDecorator.dispose();
            this._nonVisualChildDecorator = null;
        }
    }

    public void showTargetFeedback(Request request) {
        if ("selection hover".equals(request.getType())) {
            if (this._hoverFeedbackFigure != null) {
                int i = 0;
                while (i < this._hoverFeedbackFigure.length) {
                    this.removeFeedback(this._hoverFeedbackFigure[i]);
                    ++i;
                }
                this._hoverFeedbackFigure = null;
            }
            Assert.isTrue((boolean)(request instanceof LocationRequest));
            this._showLabelFeedback = !((NodeEditPart)this.getHost()).isDragActive();
            this._hoverFeedbackFigure = this.showHoverFeedback((LocationRequest)request);
        } else {
            super.showTargetFeedback(request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("selection hover".equals(request.getType())) {
            if (this._hoverFeedbackFigure != null) {
                int i = 0;
                while (i < this._hoverFeedbackFigure.length) {
                    this.removeFeedback(this._hoverFeedbackFigure[i]);
                    ++i;
                }
                this._hoverFeedbackFigure = null;
                this.getNonVisualChildDecorator().updateState(32);
            }
        } else {
            super.eraseTargetFeedback(request);
        }
    }

    private IFigure[] showHoverFeedback(LocationRequest request) {
        if (!this.shouldUseObjectMode((Request)request) && !this.isStyleTags(this.getHost())) {
            return null;
        }
        IFigure figure = this.getHostFigure();
        Rectangle[] rects = figure instanceof CSSFigure ? ((CSSFigure)figure).getFragmentsBounds() : new Rectangle[]{figure.getBounds()};
        int figureSize = rects.length;
        if (this._showLabelFeedback) {
            ++figureSize;
        }
        IFigure[] figures = new IFigure[figureSize];
        int i = 0;
        while (i < rects.length) {
            RectangleFigure fig = new RectangleFigure();
            fig.setFill(false);
            fig.setOutline(true);
            fig.setLineWidth(1);
            fig.setForegroundColor(HOVER_FEEDBACK_COLOR);
            this.addFeedback((IFigure)fig);
            Rectangle r = rects[i].getCopy();
            figure.translateToAbsolute((Translatable)r);
            fig.translateToRelative((Translatable)r);
            fig.setBounds(r);
            figures[i] = fig;
            ++i;
        }
        if (this._showLabelFeedback) {
            this.getNonVisualChildDecorator().updateState(31);
            BasicLabelToolTip label = new BasicLabelToolTip(this.getTooltipText());
            this.addFeedback((IFigure)label);
            AbsolutePointLocator locator = AbsolutePointLocator.getInstance();
            locator.setReferencePoint(request.getLocation(), 0, 25);
            locator.setIntersectFigure(this.getFeedbackLayer());
            locator.relocate((IFigure)label);
            figures[rects.length] = label;
        }
        return figures;
    }

    private String getTooltipText() {
        Element element = (Element)this.getHost().getModel();
        StringBuffer text = new StringBuffer(element.getTagName());
        return text.toString();
    }

    private boolean isStyleTags(EditPart part) {
        if (part != null && part.getModel() instanceof Node) {
            return EditModelQuery.HTML_STYLE_NODES.contains(((Node)part.getModel()).getNodeName());
        }
        return false;
    }

    private MouseSelectableChildDecorator getNonVisualChildDecorator() {
        if (this._nonVisualChildDecorator == null) {
            this._nonVisualChildDecorator = new MouseSelectableChildDecorator((GraphicalEditPart)this.getHost(), 17, this.getLayer("Feedback Layer"), this.getLayer("Handle Layer"));
        }
        return this._nonVisualChildDecorator;
    }

    public boolean shouldUseObjectMode(Request request) {
        ElementEditPart part = (ElementEditPart)this.getHost();
        if (this.isStyleTags((EditPart)part)) {
            return false;
        }
        if (part.isWidget() || !part.canHaveDirectTextChild() && !part.haveNonWhitespaceTextChild()) {
            return true;
        }
        if (request instanceof SelectionRequest && ((SelectionRequest)request).isControlKeyPressed()) {
            return true;
        }
        if (request instanceof LocationModifierRequest && ((LocationModifierRequest)request).isControlKeyPressed()) {
            return true;
        }
        if (request instanceof LocationRequest) {
            Point location = ((LocationRequest)request).getLocation().getCopy();
            part.getFigure().translateToRelative((Translatable)location);
            return this.shouldUseObjectMode(location);
        }
        return false;
    }

    private boolean shouldUseObjectMode(Point location) {
        CSSFigure figure = (CSSFigure)this.getHostFigure();
        if (figure.getFragmentsBounds().length != 1) {
            return false;
        }
        Rectangle bounds = figure.getBounds().getCopy();
        Insets insets = figure.getInsets();
        bounds.crop(insets);
        if (insets.top > 3 && insets.left > 3 && insets.right > 3 && insets.bottom > 3) {
            return !bounds.contains(location);
        }
        if (bounds.height < 9 || bounds.width < 9) {
            bounds.crop(INSETS_1);
        } else {
            bounds.crop(INSETS_CONST);
        }
        return !bounds.contains(location);
    }

    protected List createSelectionHandles() {
        IFigure figure = this.getHostFigure();
        if (figure instanceof CSSFigure && this.getHost() instanceof ElementEditPart) {
            CSSFigure cssfigure = (CSSFigure)figure;
            List fragments = cssfigure.getFragmentsForRead();
            if (fragments != null && fragments.size() == 1 && fragments.get(0) instanceof BlockBox) {
                if (((ElementEditPart)this.getHost()).isResizable()) {
                    return super.createSelectionHandles();
                }
                return this.createNonResizeHandles();
            }
            return this.createFragmentsHandles();
        }
        return this.createNonResizeHandles();
    }

    private List createFragmentsHandles() {
        ArrayList<FragmentHandle> list = new ArrayList<FragmentHandle>();
        list.add(new FragmentHandle((GraphicalEditPart)this.getHost()));
        return list;
    }

    private List createNonResizeHandles() {
        ArrayList list = new ArrayList();
        if (this.isDragAllowed()) {
            NonResizableHandleKit.addHandles((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list);
        } else {
            NonResizableHandleKit.addHandles((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (DragTracker)new SelectEditPartTracker(this.getHost()), (Cursor)SharedCursors.ARROW);
        }
        return list;
    }

    protected void hideSelection() {
        super.hideSelection();
        this.getNonVisualChildDecorator().updateState(34);
    }

    protected void showSelection() {
        super.showSelection();
        this.getNonVisualChildDecorator().updateState(33);
    }

    protected Command getResizeCommand(IDOMElement element, int width, int height) {
        HashMap<String, CallSite> map = new HashMap<String, CallSite>();
        if (width > 0) {
            map.put("width", (CallSite)((Object)(width + "px")));
        }
        if (height > 0) {
            map.put("height", (CallSite)((Object)(height + "px")));
        }
        if (!map.isEmpty()) {
            return new ChangeStyleCommand(element, map);
        }
        return null;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        CSSFigure cssfigure;
        ICSSStyle style;
        ElementEditPart part = (ElementEditPart)this.getHost();
        Rectangle rect = part.getFigure().getBounds();
        rect = request.getTransformedRectangle(rect);
        int width = rect.width;
        int height = rect.height;
        if (part.getFigure() instanceof CSSFigure && (style = (cssfigure = (CSSFigure)part.getFigure()).getCSSStyle()) != null && !style.isSizeIncludeBorderPadding()) {
            width -= style.getBorderInsets().getWidth() + style.getPaddingInsets().getWidth();
            height -= style.getBorderInsets().getHeight() + style.getPaddingInsets().getHeight();
        }
        int resizeDirection = request.getResizeDirection();
        switch (resizeDirection) {
            case 8: 
            case 16: {
                height = -1;
                break;
            }
            case 1: 
            case 4: {
                width = -1;
            }
        }
        return this.getResizeCommand((IDOMElement)part.getIDOMNode(), width, height);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        rect = (PrecisionRectangle)rect.intersect(this.getFeedbackLayer().getBounds());
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
    }

    @Override
    public Cursor getSelectionToolCursor(Point mouseLocation) {
        return null;
    }

    protected DragTracker getSelectionTracker(LocationRequest request) {
        return null;
    }

    @Override
    public DragTracker getSelectionDragTracker(LocationRequest request) {
        if ("selection.tracker.request".equals(request.getType())) {
            return this.getSelectionTracker(request);
        }
        if (this.shouldUseObjectMode((Request)request)) {
            return new ObjectModeDragTracker(this.getHost());
        }
        return new RangeDragTracker(this.getHost());
    }
}

