/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;
import org.eclipse.wst.xml.tests.encoding.util.ProjectUnzipUtility;

public class ZippedTest {
    private static final String TEST_PROJECT_NAME = "org.eclipse.encoding.resource.newtests";
    private boolean isSetUp = false;
    private IProject fProject = null;

    public void setUp() throws CoreException {
        if (!this.isSetUp) {
            this.createProject();
            String destinationProjectString = this.fProject.getLocation().toOSString();
            String destinationFolder = String.valueOf(destinationProjectString) + "/";
            ProjectUnzipUtility projUtil = new ProjectUnzipUtility();
            projUtil.unzipAndImport(TestsPlugin.getTestResource("testfiles.zip"), destinationFolder);
            projUtil.initJavaProject(TEST_PROJECT_NAME);
            this.fProject.refreshLocal(2, null);
            this.isSetUp = true;
        }
    }

    public void shutDown() throws CoreException {
        if (this.isSetUp) {
            if (this.fProject != null && this.fProject.isAccessible()) {
                this.fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            this.isSetUp = false;
        }
    }

    public IFile getFile(String fileName) {
        IFile file = null;
        if (this.fProject != null) {
            file = (IFile)this.fProject.findMember(fileName);
        }
        return file;
    }

    protected IProject createProject() throws CoreException {
        IWorkspace workspace = TestsPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        this.fProject = root.getProject(TEST_PROJECT_NAME);
        this.createProject(this.fProject, null, null);
        this.fProject.refreshLocal(2, null);
        return this.fProject;
    }

    private void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

