/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.util.Locale;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class SyntaxErrorTest
extends AbstractCompilerTest {
    public static boolean optimizeStringLiterals = false;

    public SyntaxErrorTest(String testName) {
        super(testName);
    }

    public void checkParse(char[] source, String expectedSyntaxErrorDiagnosis, String testName) {
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        StringBuffer buffer = new StringBuffer(100);
        if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
            CategorizedProblem[] problems = compilationResult.getAllProblems();
            int count = problems.length;
            int problemCount = 0;
            char[] unitSource = compilationResult.compilationUnit.getContents();
            int i = 0;
            while (i < count) {
                if (problems[i] != null) {
                    if (problemCount == 0) {
                        buffer.append("----------\n");
                    }
                    buffer.append(String.valueOf(++problemCount) + (problems[i].isError() ? ". ERROR" : ". WARNING"));
                    buffer.append(" in " + new String(problems[i].getOriginatingFileName()).replace('/', '\\'));
                    try {
                        buffer.append(((DefaultProblem)problems[i]).errorReportSource(unitSource));
                        buffer.append("\n");
                        buffer.append(problems[i].getMessage());
                        buffer.append("\n");
                    }
                    catch (Exception exception) {}
                    buffer.append("----------\n");
                }
                ++i;
            }
        }
        String computedSyntaxErrorDiagnosis = buffer.toString();
        SyntaxErrorTest.assertEquals("Invalid syntax error diagnosis" + testName, Util.convertToIndependantLineDelimiter(expectedSyntaxErrorDiagnosis), Util.convertToIndependantLineDelimiter(computedSyntaxErrorDiagnosis));
    }

    public void test01() {
        String s = "function X() {\t\t\t\t\t\t\t\t\t\n function solve(){\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n  var results = new Array(10);\t\t\t\t\t\n  for(var i = 0; i < 10; i++){\t\t\t\t\t\n   var result = results[i];\t\t\t\t\t\n   var found = false;\t\t\t\t\t\t\t\n   for(var j = 0; j < 10; j++){\t\t\t\t\n    if (this == (result.documentName){\t\t\t\n     found = true;\t\t\t\t\t\t\t\t\n     break;\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n  return andResult;\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <parenthesis mismatch> (at line 9)\n\tif (this == (result.documentName){\t\t\t\n\t                                ^\nSyntax error, insert \") BlockStatement\" to complete BlockStatements\n----------\n2. ERROR in <parenthesis mismatch> (at line 1)\n\tif (this == (result.documentName){\t\t\t\n\t                                ^\nSyntax error, insert \") BlockStatement\" to complete BlockStatements\n----------\n";
        String testName = "<parenthesis mismatch>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test02() {
        String s = "function Bar() {\t\t\n this.a = (fred().x{); \n}\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <brace mismatch> (at line 2)\n\tthis.a = (fred().x{); \n\t                  ^\nSyntax error on token \"{\", delete this token\n----------\n";
        String testName = "<brace mismatch>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test03() {
        String s = "function X() { \t\t\t\t\t\t\t\t\t\t\t\t\n    o = { s: \"Success\"; };\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 2)\n\to = { s: \"Success\"; };\t\t\t\t\t\t\t\t\n\t                  ^\nSyntax error on token \";\", , expected\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test04() {
        String s = "function X() { \t\t\t\t\t\t\t\t\t\t\t\t\n    var o = { s: \"Success\"; };\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 2)\n\tvar o = { s: \"Success\"; };\t\t\t\t\t\t\t\t\n\t                      ^\nSyntax error on token \";\", , expected\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05a() {
        String s = "var foo = \"1\\\n2\";\n";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05b() {
        String s = "var foo = '111\\\n222';\t\n";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05c() {
        String s = "var foo = \"  \\\r\n    \";\t\r\n";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05d() {
        String s = "var foo = '  \\\r\n    ';\t\r\n";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05e() {
        String s = "var foo = \"  \\\r    \";\t\r";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05f() {
        String s = "var foo = '  \\\r    ';\t\r";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05g() {
        String s = "var foo = '  \\\n\n    \";\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 1)\n\tvar foo = '  \\\n\n\t          ^^^^^\nString literal is not properly closed by a matching quote\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05h() {
        String s = "var foo = \"  \\\n\n    ';\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 1)\n\tvar foo = \"  \\\n\n\t          ^^^^^\nString literal is not properly closed by a matching quote\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void testWhitespaces01() {
        String s = "var \t\r\n\u000b\f \ufeff\u00a0 x;\r";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void testWI106610() {
        String s = "\n<!-- Begin";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 2)\n\t<!-- Begin\n\t^\nSyntax error on token \"<\", delete this token\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void testCommaExpression01() {
        String s = "!function(){\n\twindow.alert(\"passed 1\");\n}(),\n\tfunction(){\n\t\twindow.alert(\"passed 2\");\n}();\nwindow.alert(\"passed 3\");";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), "", testName);
    }

    public void testRegExpression01() {
        String s = "searchStr.replace( /([!\"#$%&'()*+,./:;<=>?@[\\]^`{|}~])/g, '//' )";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void testRegExpression02() {
        String s = "searchStr.replace(/\\n( |\t)*[/][/]/g,'//')";
        String expectedSyntaxErrorDiagnosis = "";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }
}

