/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.rhino.Node;
import java.util.logging.Logger;

class RemoveUnusedPrototypeProperties
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(RemoveUnusedPrototypeProperties.class.getName());
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;

    RemoveUnusedPrototypeProperties(AbstractCompiler compiler, boolean canModifyExterns, boolean anchorUnusedVars) {
        this.compiler = compiler;
        this.canModifyExterns = canModifyExterns;
        this.anchorUnusedVars = anchorUnusedVars;
    }

    @Override
    public void process(Node externRoot, Node root) {
        AnalyzePrototypeProperties analyzer = new AnalyzePrototypeProperties(this.compiler, null, this.canModifyExterns, this.anchorUnusedVars);
        analyzer.process(externRoot, root);
        for (AnalyzePrototypeProperties.NameInfo nameInfo : analyzer.getAllNameInfo()) {
            if (nameInfo.isReferenced()) continue;
            for (AnalyzePrototypeProperties.Symbol declaration : nameInfo.getDeclarations()) {
                declaration.remove(this.compiler);
            }
            logger.fine("Removed unused prototype property: " + nameInfo.name);
        }
    }
}

